/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.managers;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.managers.AllyManager;
import ct.ajneb97.managers.MensajesManager;
import ct.ajneb97.managers.RegionManager;
import ct.ajneb97.managers.TurretsManager;
import ct.ajneb97.managers.WorldGuardManager;
import ct.ajneb97.managers.holograms.HologramsManager;
import ct.ajneb97.model.PlayerTurret;
import ct.ajneb97.model.estructura.TurretAttackPriority;
import dt.ajneb97.DefensiveTurrets;
import dt.ajneb97.Torreta;
import java.util.ArrayList;
import net.citizensnpcs.api.CitizensAPI;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.scheduler.BukkitRunnable;

public class DependencyManager {
    private ComplexTurrets plugin;
    private Economy econ;
    private HologramsManager hologramsManager;
    private AllyManager allyManager;
    private RegionManager regionManager;
    private WorldGuardManager worldGuardManager;
    private DefensiveTurrets defensiveTurrets;
    private boolean citizens;

    public DependencyManager(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
        this.hologramsManager = new HologramsManager(complexTurrets);
        this.allyManager = new AllyManager(complexTurrets);
        this.regionManager = new RegionManager(complexTurrets);
        this.citizens = false;
        this.configurar();
    }

    public void configurar() {
        this.setupEconomy();
        if (Bukkit.getServer().getPluginManager().getPlugin("Citizens") != null) {
            this.citizens = true;
        }
        if (Bukkit.getServer().getPluginManager().getPlugin("DefensiveTurrets") != null) {
            this.defensiveTurrets = (DefensiveTurrets)Bukkit.getServer().getPluginManager().getPlugin("DefensiveTurrets");
        }
        if (Bukkit.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
            this.worldGuardManager = new WorldGuardManager(this.plugin);
        }
    }

    private boolean setupEconomy() {
        if (Bukkit.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider registeredServiceProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (registeredServiceProvider == null) {
            return false;
        }
        this.econ = (Economy)registeredServiceProvider.getProvider();
        return this.econ != null;
    }

    public Economy getEconomy() {
        return this.econ;
    }

    public boolean isNPC(Entity entity) {
        if (this.citizens) {
            return CitizensAPI.getNPCRegistry().isNPC(entity);
        }
        return false;
    }

    public HologramsManager getHologramsManager() {
        return this.hologramsManager;
    }

    public AllyManager getAllyManager() {
        return this.allyManager;
    }

    public RegionManager getRegionManager() {
        return this.regionManager;
    }

    public WorldGuardManager getWorldGuardManager() {
        return this.worldGuardManager;
    }

    public boolean hasDefensiveTurrets() {
        return this.defensiveTurrets != null;
    }

    public void migrateFromDefensiveTurrets(final CommandSender commandSender) {
        final TurretsManager turretsManager = this.plugin.getTurretsManager();
        final MensajesManager mensajesManager = this.plugin.getMensajesManager();
        final ArrayList arrayList = this.defensiveTurrets.getTorretas();
        for (Torreta torreta : arrayList) {
            String string = torreta.getTipo();
            if (turretsManager.getTurret(string) != null) continue;
            mensajesManager.enviarMensaje(commandSender, "&cThe turret &7" + string + " &con DefensiveTurrets doesn't exists on ComplexTurrets. Create it first!", true);
            return;
        }
        new BukkitRunnable(){

            public void run() {
                String string = "";
                for (Torreta torreta : arrayList) {
                    String string2 = torreta.getUUIDJugador();
                    if (!string.equals(string2)) {
                        mensajesManager.enviarMensaje(commandSender, "&eMigrating data from &7" + string2 + "&e...", true);
                    }
                    PlayerTurret playerTurret = new PlayerTurret(torreta.getTipo(), torreta.getLevel(), torreta.getBase(), torreta.isAtacaMonstruos(), torreta.isAtacaJugadores(), torreta.isAtacaAnimales(), false, TurretAttackPriority.CLOSEST, false, torreta.getAmmo(), torreta.tieneAmmoInfinita(), torreta.getJugadores(), torreta.getUUIDJugador(), torreta.getJugador(), DependencyManager.this.plugin, 0, PlayerTurret.generateAmmoInventoryFromAmmo(torreta.getAmmo()), 0L);
                    turretsManager.createTurret(playerTurret);
                    string = torreta.getUUIDJugador();
                }
                DependencyManager.this.plugin.getConfigsManager().getPlayerConfigsManager().guardarJugadores();
                mensajesManager.enviarMensaje(commandSender, "&aMigration completed! Restart your server and remove DefensiveTurrets.", true);
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }
}

