/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.managers;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.api.TurretLevelUpEvent;
import ct.ajneb97.managers.ItemManager;
import ct.ajneb97.managers.MensajesManager;
import ct.ajneb97.managers.TurretsManager;
import ct.ajneb97.model.ClosePlayerInventoryReason;
import ct.ajneb97.model.InventoryTurret;
import ct.ajneb97.model.ItemInventoryTurret;
import ct.ajneb97.model.PlayerInventory;
import ct.ajneb97.model.PlayerTurret;
import ct.ajneb97.model.PlayerTurretAmmoInventoryPage;
import ct.ajneb97.model.PlayerTurretAmmoInventorySlot;
import ct.ajneb97.model.estructura.Turret;
import ct.ajneb97.model.estructura.TurretItemType;
import ct.ajneb97.model.estructura.TurretUpgrade;
import ct.ajneb97.model.estructura.UpgradeItemCost;
import ct.ajneb97.model.others.SavedTurretProperties;
import ct.ajneb97.utils.UtilsEffects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryManager {
    private ArrayList<PlayerInventory> players = new ArrayList();
    private ArrayList<InventoryTurret> inventories = new ArrayList();
    private ComplexTurrets plugin;

    public InventoryManager(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
    }

    public ArrayList<InventoryTurret> getInventories() {
        return this.inventories;
    }

    public void setInventories(ArrayList<InventoryTurret> arrayList) {
        this.inventories = arrayList;
    }

    public InventoryTurret getInventoryByName(String string) {
        for (InventoryTurret inventoryTurret : this.inventories) {
            if (!inventoryTurret.getName().equals(string)) continue;
            return inventoryTurret;
        }
        return null;
    }

    public void addPlayerInventory(PlayerInventory playerInventory) {
        this.players.add(playerInventory);
    }

    public PlayerInventory getPlayerInventory(Player player) {
        for (PlayerInventory playerInventory : this.players) {
            if (!playerInventory.getPlayer().equals(player)) continue;
            return playerInventory;
        }
        return null;
    }

    public PlayerInventory getPlayerInventory(PlayerTurret playerTurret) {
        for (PlayerInventory playerInventory : this.players) {
            if (!playerInventory.getTurret().equals(playerTurret)) continue;
            return playerInventory;
        }
        return null;
    }

    public void removePlayerInventory(Player player) {
        int n = 0;
        while (n < this.players.size()) {
            if (this.players.get(n).getPlayer().equals(player)) {
                this.players.remove(n);
            }
            ++n;
        }
    }

    public void openInventory(Player player, PlayerTurret playerTurret, InventoryTurret inventoryTurret, PlayerInventory playerInventory) {
        if (inventoryTurret.getName().equals("ammunition")) {
            this.openAmmoInventory(player, playerTurret, inventoryTurret, playerInventory);
            return;
        }
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        FileConfiguration fileConfiguration2 = this.plugin.getMessages();
        Inventory inventory = Bukkit.createInventory(null, (int)inventoryTurret.getSlots(), (String)MensajesManager.getMensajeColor(inventoryTurret.getTitle()));
        TurretsManager turretsManager = this.plugin.getTurretsManager();
        ItemManager itemManager = this.plugin.getItemManager();
        Turret turret = turretsManager.getTurret(playerTurret.getTurretName());
        int n = playerTurret.getTurretLevel();
        List<ItemInventoryTurret> list = inventoryTurret.getItems();
        block0: for (ItemInventoryTurret itemInventoryTurret : list) {
            List<String> list2;
            List<Integer> list3 = itemInventoryTurret.getSlots();
            String string = itemInventoryTurret.getType();
            if (string != null && string.equals("whitelist_player_item")) {
                List<String> list4 = playerTurret.getWhitelistedPlayers();
                int n2 = list4.size();
                int n3 = 0;
                list2 = list3.iterator();
                while (list2.hasNext()) {
                    int n4 = list2.next();
                    if (n2 <= 0) continue block0;
                    String string2 = list4.get(n3);
                    ItemStack itemStack = ItemManager.crearItemConfig(fileConfiguration, "items.whitelist_player_item");
                    ItemMeta itemMeta = itemStack.getItemMeta();
                    itemMeta.setDisplayName(itemMeta.getDisplayName().replace("%player%", string2));
                    itemStack.setItemMeta(itemMeta);
                    ItemManager.setTagStringItem(itemStack, "complex_turrets_whitelisted_player_name", string2);
                    ItemManager.setTagStringItem(itemStack, "complex_turrets_item_type", string);
                    inventory.setItem(n4, itemStack);
                    --n2;
                    ++n3;
                }
                continue;
            }
            for (int n5 : list3) {
                ItemStack itemStack = null;
                if (string != null) {
                    itemStack = this.getItemByType(string, player, turret, n, itemManager, playerTurret, fileConfiguration, fileConfiguration2);
                    if (itemStack == null) {
                        continue;
                    }
                } else {
                    itemStack = itemInventoryTurret.getItem().clone();
                    ItemMeta itemMeta = itemStack.getItemMeta();
                    if (itemInventoryTurret.getName() != null) {
                        itemMeta.setDisplayName(MensajesManager.getMensajeColor(itemInventoryTurret.getName()));
                    }
                    if (itemInventoryTurret.getLore() != null) {
                        list2 = new ArrayList<String>(itemInventoryTurret.getLore());
                        int n6 = 0;
                        while (n6 < list2.size()) {
                            list2.set(n6, MensajesManager.getMensajeColor(list2.get(n6)));
                            ++n6;
                        }
                        itemMeta.setLore(list2);
                    }
                    itemStack.setItemMeta(itemMeta);
                    if (itemInventoryTurret.getOpenInventory() != null) {
                        ItemManager.setTagStringItem(itemStack, "complex_turrets_open_inventory", itemInventoryTurret.getOpenInventory());
                    }
                    if ((list2 = itemInventoryTurret.getCommands()) != null && !list2.isEmpty()) {
                        String string3 = "";
                        int n7 = 0;
                        while (n7 < list2.size()) {
                            string3 = n7 == list2.size() - 1 ? String.valueOf(string3) + list2.get(n7) : String.valueOf(string3) + list2.get(n7) + "|";
                            ++n7;
                        }
                        ItemManager.setTagStringItem(itemStack, "complex_turrets_item_commands", string3);
                    }
                }
                inventory.setItem(n5, itemStack);
            }
        }
        player.openInventory(inventory);
        this.addPlayerInventory(new PlayerInventory(player, inventoryTurret.getName(), playerTurret, 1));
    }

    public ItemStack getItemByType(String string, Player player, Turret turret, int n, ItemManager itemManager, PlayerTurret playerTurret, FileConfiguration fileConfiguration, FileConfiguration fileConfiguration2) {
        ItemStack itemStack = null;
        switch (string) {
            case "turret_upgrade": {
                TurretItemType turretItemType = null;
                int n2 = 0;
                if (turret.getNextUpgrade(n) == null) {
                    turretItemType = TurretItemType.LAST_UPGRADE;
                    n2 = 1;
                } else {
                    turretItemType = TurretItemType.UPGRADE;
                }
                itemStack = itemManager.createTurretItem(player, turret, turretItemType, n, null);
                ItemManager.setTagIntItem(itemStack, "complex_turrets_last_upgrade", n2);
                break;
            }
            case "delete_turret_item": {
                itemStack = ItemManager.crearItemConfig(fileConfiguration, "items." + string);
                break;
            }
            case "attack_players_item": {
                itemStack = ItemManager.crearItemStatusConfig(fileConfiguration, fileConfiguration2, "items." + string, playerTurret.isAttackPlayers());
                break;
            }
            case "attack_monsters_item": {
                itemStack = ItemManager.crearItemStatusConfig(fileConfiguration, fileConfiguration2, "items." + string, playerTurret.isAttackMonsters());
                break;
            }
            case "attack_animals_item": {
                itemStack = ItemManager.crearItemStatusConfig(fileConfiguration, fileConfiguration2, "items." + string, playerTurret.isAttackAnimals());
                break;
            }
            case "attack_others_item": {
                itemStack = ItemManager.crearItemStatusConfig(fileConfiguration, fileConfiguration2, "items." + string, playerTurret.isAttackOthers());
                break;
            }
            case "whitelisted_players_item": {
                itemStack = ItemManager.crearItemWhitelistConfig(fileConfiguration, "items." + string, playerTurret);
                break;
            }
            case "turret_status_item": {
                itemStack = ItemManager.crearItemStatusConfig(fileConfiguration, fileConfiguration2, "items." + string, playerTurret.isEnabled());
                break;
            }
            case "priority_item": {
                itemStack = ItemManager.crearItemPriorityConfig(fileConfiguration, "items." + string, playerTurret.getPriority());
                break;
            }
            case "turret_ammo_item": {
                if (!turret.isRequireAmmunition()) break;
                itemStack = ItemManager.crearItemConfig(fileConfiguration, "items." + string);
                this.updateItemAmmoOptions(playerTurret, itemStack);
                break;
            }
            case "whitelist_add_player_item": {
                itemStack = ItemManager.crearItemConfig(fileConfiguration, "items." + string);
                break;
            }
            case "whitelist_apply_item": {
                itemStack = ItemManager.crearItemConfig(fileConfiguration, "items." + string);
                break;
            }
            case "infinite_ammo_item": {
                if (!player.isOp() && !player.hasPermission("complexturrets.admin") && !player.hasPermission("complexturrets.infiniteammo")) break;
                itemStack = ItemManager.crearItemStatusConfig(fileConfiguration, fileConfiguration2, "items." + string, playerTurret.isInfiniteAmmo());
            }
        }
        if (itemStack != null) {
            ItemManager.setTagStringItem(itemStack, "complex_turrets_item_type", string);
        }
        return itemStack;
    }

    private void updateItemAmmoOptions(PlayerTurret playerTurret, ItemStack itemStack) {
        TurretsManager turretsManager = this.plugin.getTurretsManager();
        ArrayList<String> arrayList = new ArrayList<String>(this.plugin.getConfigsManager().getMainConfigManager().getTurretAmmoItemLore());
        String string = "";
        String string2 = "";
        if (playerTurret.isInfiniteAmmo()) {
            string = "\u221e";
            string2 = "\u221e";
        } else {
            string = String.valueOf(playerTurret.getTotalAmmo());
            string2 = String.valueOf(turretsManager.getMaxAmmo(this.plugin.getTurretsManager().getTurret(playerTurret.getTurretName()), playerTurret.getTurretLevel()));
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        int n = 0;
        while (n < arrayList.size()) {
            arrayList.set(n, MensajesManager.getMensajeColor(((String)arrayList.get(n)).replace("%ammo%", string).replace("%max_ammo%", string2)));
            ++n;
        }
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
    }

    public boolean upgradeTurret(Player player, PlayerTurret playerTurret) {
        String string = playerTurret.getTurretName();
        Turret turret = this.plugin.getTurretsManager().getTurret(string);
        FileConfiguration fileConfiguration = this.plugin.getMessages();
        FileConfiguration fileConfiguration2 = this.plugin.getConfig();
        MensajesManager mensajesManager = this.plugin.getMensajesManager();
        ItemManager itemManager = this.plugin.getItemManager();
        boolean bl = false;
        TurretUpgrade turretUpgrade = turret.getNextUpgrade(playerTurret.getTurretLevel());
        Economy economy = this.plugin.getDependencyManager().getEconomy();
        int n = turretUpgrade.getMoneyCost();
        if (n != 0) {
            double d;
            if (economy != null && (d = economy.getBalance((OfflinePlayer)player)) >= (double)n) {
                bl = true;
            }
            if (!bl) {
                mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("noEnoughMoney"), true);
                return false;
            }
        }
        ArrayList<UpgradeItemCost> arrayList = turretUpgrade.getItemCost();
        boolean bl2 = false;
        if (!arrayList.isEmpty()) {
            bl2 = true;
        }
        for (UpgradeItemCost upgradeItemCost : arrayList) {
            int n2 = upgradeItemCost.getAmount();
            int n3 = itemManager.getAmountItemCost(player, upgradeItemCost);
            if (n3 >= n2) continue;
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("noEnoughItems"), true);
            return false;
        }
        int n4 = playerTurret.getTurretLevel() + 1;
        TurretLevelUpEvent turretLevelUpEvent = new TurretLevelUpEvent(player, playerTurret, n4);
        this.plugin.getServer().getPluginManager().callEvent(turretLevelUpEvent);
        if (turretLevelUpEvent.isCancelled()) {
            return false;
        }
        if (bl) {
            economy.withdrawPlayer((OfflinePlayer)player, (double)n);
        }
        if (bl2) {
            for (UpgradeItemCost upgradeItemCost : arrayList) {
                itemManager.removeItemCost(player, upgradeItemCost);
            }
        }
        playerTurret.upgrade(this.plugin);
        this.plugin.getJugadorManager().updateInformationHologram(playerTurret);
        UtilsEffects.playSoundPlayer(player, fileConfiguration2.getString("turret_upgrade_sound"), this.plugin);
        mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretUpgraded").replace("%level%", String.valueOf(n4)), true);
        return true;
    }

    public boolean destroyTurret(Player player, PlayerTurret playerTurret) {
        FileConfiguration fileConfiguration = this.plugin.getMessages();
        MensajesManager mensajesManager = this.plugin.getMensajesManager();
        if (!(playerTurret.isMaxHealth() || player.isOp() || player.hasPermission("complexturrets.admin") || player.hasPermission("complexturrets.destroynotfullhealth"))) {
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretRemoveIsNotFullHealth"), true);
            return false;
        }
        FileConfiguration fileConfiguration2 = this.plugin.getConfig();
        String string = playerTurret.getTurretName();
        int n = playerTurret.getTotalAmmo();
        if (fileConfiguration2.getBoolean("no_ammo_required_to_remove") && n >= 1) {
            mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretRemoveIsNotEmptyAmmo"), true);
            return false;
        }
        int n2 = playerTurret.getTurretLevel();
        Location location = playerTurret.getLocation().clone();
        World world = location.getWorld();
        this.plugin.getJugadorManager().removeTurret(playerTurret.getLocation(), false);
        if (fileConfiguration2.getBoolean("receive_turret_on_remove")) {
            Turret turret = this.plugin.getTurretsManager().getTurret(string);
            SavedTurretProperties savedTurretProperties = null;
            if (fileConfiguration2.getBoolean("save_properties_on_remove")) {
                savedTurretProperties = SavedTurretProperties.createProperties(playerTurret);
            }
            ItemStack itemStack = this.plugin.getItemManager().createTurretItem(player, turret, TurretItemType.BLOCK, n2, savedTurretProperties);
            if (player.getInventory().firstEmpty() == -1) {
                world.dropItemNaturally(location, itemStack);
            } else {
                player.getInventory().addItem(new ItemStack[]{itemStack});
            }
            if (n != 0) {
                ItemStack itemStack2 = this.plugin.getItemManager().createTurretItem(player, turret, TurretItemType.AMMUNITION, 0, null);
                int n3 = 0;
                while (n3 < n) {
                    if (player.getInventory().firstEmpty() == -1) {
                        world.dropItemNaturally(location, itemStack2);
                    } else {
                        player.getInventory().addItem(new ItemStack[]{itemStack2});
                    }
                    ++n3;
                }
            }
        }
        mensajesManager.enviarMensaje((CommandSender)player, fileConfiguration.getString("turretRemoved"), true);
        return true;
    }

    public void saveAmmo(PlayerTurret playerTurret, Inventory inventory, PlayerInventory playerInventory) {
        int n = playerInventory.getPage();
        ItemStack[] itemStackArray = inventory.getContents();
        PlayerTurretAmmoInventoryPage playerTurretAmmoInventoryPage = playerTurret.getAmmoInventoryPage(n);
        if (playerTurretAmmoInventoryPage == null) {
            playerTurretAmmoInventoryPage = new PlayerTurretAmmoInventoryPage(n, new ArrayList<PlayerTurretAmmoInventorySlot>());
            playerTurret.addAmmoInventoryPage(playerTurretAmmoInventoryPage);
        }
        TurretsManager turretsManager = this.plugin.getTurretsManager();
        int n2 = turretsManager.getMaxAmmo(this.plugin.getTurretsManager().getTurret(playerTurret.getTurretName()), playerTurret.getTurretLevel());
        int n3 = n2 / 576;
        int n4 = 0;
        n4 = n * 5 > n3 ? n3 - (n - 1) * 5 : 5;
        int n5 = n4 * 9;
        int n6 = 0;
        while (n6 <= n5) {
            String string;
            if (n6 >= itemStackArray.length) break;
            ItemStack itemStack = itemStackArray[n6];
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
                playerTurretAmmoInventoryPage.setAmmo(n6, 0);
            } else if (itemStack != null && (string = ItemManager.getTagStringItem(itemStack, "complex_turrets_ammunition_id")) != null) {
                playerTurretAmmoInventoryPage.setAmmo(n6, itemStack.getAmount());
            }
            ++n6;
        }
        if ((n6 = playerTurret.getPageAmmo(playerTurretAmmoInventoryPage)) == 0) {
            playerTurret.removeAmmoInventoryPage(playerTurretAmmoInventoryPage.getPage());
        }
    }

    public void updateAmmoInventory(PlayerTurret playerTurret) {
        block9: {
            PlayerInventory playerInventory = this.getPlayerInventory(playerTurret);
            TurretsManager turretsManager = this.plugin.getTurretsManager();
            if (playerInventory == null) break block9;
            Player player = playerInventory.getPlayer();
            if (playerInventory.getInventoryType().equals("ammunition")) {
                int n;
                int n2;
                Inventory inventory = player.getOpenInventory().getTopInventory();
                int n3 = playerInventory.getPage();
                if (playerTurret.isMoreAmmoInNextPages(n3, n2 = this.getMaxPages(n = turretsManager.getMaxAmmo(this.plugin.getTurretsManager().getTurret(playerTurret.getTurretName()), playerTurret.getTurretLevel())))) {
                    return;
                }
                ItemStack[] itemStackArray = inventory.getContents();
                int n4 = itemStackArray.length - 1;
                while (n4 >= 0) {
                    String string;
                    ItemStack itemStack = inventory.getItem(n4);
                    if (itemStack != null && (string = ItemManager.getTagStringItem(itemStack, "complex_turrets_item_type")) != null && string.equals("ammo_item")) {
                        if (itemStack.getAmount() == 1) {
                            inventory.setItem(n4, null);
                        } else {
                            itemStack.setAmount(itemStack.getAmount() - 1);
                        }
                        return;
                    }
                    --n4;
                }
            } else {
                Inventory inventory = player.getOpenInventory().getTopInventory();
                ItemStack[] itemStackArray = inventory.getContents();
                int n = itemStackArray.length - 1;
                while (n >= 0) {
                    String string;
                    ItemStack itemStack = inventory.getItem(n);
                    if (itemStack != null && (string = ItemManager.getTagStringItem(itemStack, "complex_turrets_item_type")) != null && string.equals("turret_ammo_item")) {
                        this.updateItemAmmoOptions(playerTurret, itemStack);
                        return;
                    }
                    --n;
                }
            }
        }
    }

    public boolean executeItemCommands(ItemStack itemStack, Player player) {
        String string = ItemManager.getTagStringItem(itemStack, "complex_turrets_item_commands");
        if (string != null) {
            String[] stringArray = string.split("\\|");
            ConsoleCommandSender consoleCommandSender = Bukkit.getConsoleSender();
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                if (string2.startsWith("msg %player% ")) {
                    player.sendMessage(MensajesManager.getMensajeColor(string2.replace("msg %player% ", "")));
                } else {
                    Bukkit.dispatchCommand((CommandSender)consoleCommandSender, (String)string2.replace("%player%", player.getName()));
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public void openAmmoInventory(Player player, PlayerTurret playerTurret, InventoryTurret inventoryTurret, PlayerInventory playerInventory) {
        Object object;
        List<Object> list;
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        FileConfiguration fileConfiguration2 = this.plugin.getMessages();
        TurretsManager turretsManager = this.plugin.getTurretsManager();
        int n = turretsManager.getMaxAmmo(turretsManager.getTurret(playerTurret.getTurretName()), playerTurret.getTurretLevel());
        int n2 = n / 576;
        int n3 = this.getMaxPages(n);
        int n4 = playerInventory.getPage();
        int n5 = 0;
        n5 = n4 * 5 > n2 ? n2 - (n4 - 1) * 5 : 5;
        int n6 = (n5 + 1) * 9;
        Inventory inventory = Bukkit.createInventory(null, (int)n6, (String)MensajesManager.getMensajeColor(inventoryTurret.getTitle()));
        TurretsManager turretsManager2 = this.plugin.getTurretsManager();
        ItemManager itemManager = this.plugin.getItemManager();
        Turret turret = turretsManager2.getTurret(playerTurret.getTurretName());
        int n7 = playerTurret.getTurretLevel();
        PlayerTurretAmmoInventoryPage playerTurretAmmoInventoryPage = playerTurret.getAmmoInventoryPage(n4);
        ItemStack itemStack = itemManager.createTurretItem(player, turret, TurretItemType.AMMUNITION, 0, null);
        ItemManager.setTagStringItem(itemStack, "complex_turrets_item_type", "ammo_item");
        if (playerTurretAmmoInventoryPage != null) {
            list = playerTurretAmmoInventoryPage.getSlots();
            for (Object object2 : list) {
                object = itemStack.clone();
                object.setAmount(((PlayerTurretAmmoInventorySlot)object2).getAmount());
                inventory.setItem(((PlayerTurretAmmoInventorySlot)object2).getSlot(), (ItemStack)object);
            }
        }
        list = inventoryTurret.getItems();
        for (Object object2 : list) {
            object = ((ItemInventoryTurret)object2).getSlots();
            String string = ((ItemInventoryTurret)object2).getType();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                int n8 = (Integer)iterator.next();
                ItemStack itemStack2 = null;
                if (string != null) {
                    if (string.equals("ammo_item")) continue;
                    if (string.equals("ammo_next_page")) {
                        if (n3 <= n4) continue;
                        itemStack2 = ItemManager.crearItemConfig(fileConfiguration, "items." + string);
                        ItemManager.setTagStringItem(itemStack2, "complex_turrets_item_type", string);
                    } else if (string.equals("ammo_previous_page")) {
                        if (n4 <= 1) continue;
                        itemStack2 = ItemManager.crearItemConfig(fileConfiguration, "items." + string);
                        ItemManager.setTagStringItem(itemStack2, "complex_turrets_item_type", string);
                    } else {
                        itemStack2 = this.getItemByType(string, player, turret, n7, itemManager, playerTurret, fileConfiguration, fileConfiguration2);
                        if (itemStack2 == null) {
                            continue;
                        }
                    }
                } else {
                    List<String> list2;
                    itemStack2 = ((ItemInventoryTurret)object2).getItem().clone();
                    ItemMeta itemMeta = itemStack2.getItemMeta();
                    if (((ItemInventoryTurret)object2).getName() != null) {
                        itemMeta.setDisplayName(MensajesManager.getMensajeColor(((ItemInventoryTurret)object2).getName()));
                    }
                    if (((ItemInventoryTurret)object2).getLore() != null) {
                        list2 = new ArrayList<String>(((ItemInventoryTurret)object2).getLore());
                        int n9 = 0;
                        while (n9 < list2.size()) {
                            list2.set(n9, MensajesManager.getMensajeColor(list2.get(n9)));
                            ++n9;
                        }
                        itemMeta.setLore(list2);
                    }
                    itemStack2.setItemMeta(itemMeta);
                    if (((ItemInventoryTurret)object2).getOpenInventory() != null) {
                        ItemManager.setTagStringItem(itemStack2, "complex_turrets_open_inventory", ((ItemInventoryTurret)object2).getOpenInventory());
                    }
                    if ((list2 = ((ItemInventoryTurret)object2).getCommands()) != null && !list2.isEmpty()) {
                        String string2 = "";
                        int n10 = 0;
                        while (n10 < list2.size()) {
                            string2 = n10 == list2.size() - 1 ? String.valueOf(string2) + list2.get(n10) : String.valueOf(string2) + list2.get(n10) + "|";
                            ++n10;
                        }
                        ItemManager.setTagStringItem(itemStack2, "complex_turrets_item_commands", string2);
                    }
                }
                if (n8 >= 36) {
                    n8 -= 36;
                }
                if (n8 < 0 || n8 > 8) continue;
                inventory.setItem(n8 += n5 * 9, itemStack2);
            }
        }
        playerInventory.setCloseReason(ClosePlayerInventoryReason.ITEM);
        player.openInventory(inventory);
        this.addPlayerInventory(new PlayerInventory(player, inventoryTurret.getName(), playerTurret, playerInventory.getPage()));
    }

    public int getMaxPages(int n) {
        int n2 = n / 576;
        int n3 = 0;
        n3 = n2 % 5 == 0 ? n2 / 5 : n2 / 5 + 1;
        return n3;
    }
}

