/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.managers;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.libs.actionbar.ActionBarAPI;
import ct.ajneb97.managers.InventoryManager;
import ct.ajneb97.managers.MensajesManager;
import ct.ajneb97.managers.TurretsManager;
import ct.ajneb97.managers.holograms.HologramsManager;
import ct.ajneb97.model.PlayerData;
import ct.ajneb97.model.PlayerHologram;
import ct.ajneb97.model.PlayerInventory;
import ct.ajneb97.model.PlayerTurret;
import ct.ajneb97.model.PlayerTurretAmmoInventoryPage;
import ct.ajneb97.model.estructura.Turret;
import ct.ajneb97.model.estructura.TurretItemType;
import ct.ajneb97.model.others.SavedTurretProperties;
import ct.ajneb97.utils.UtilsEffects;
import ct.ajneb97.utils.UtilsTurrets;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class JugadorManager {
    private ArrayList<PlayerData> players = new ArrayList();
    private ArrayList<PlayerHologram> playersHologram = new ArrayList();
    private ComplexTurrets plugin;

    public JugadorManager(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
    }

    public ArrayList<PlayerData> getPlayers() {
        return this.players;
    }

    public void setPlayers(ArrayList<PlayerData> arrayList) {
        this.players = arrayList;
    }

    public ArrayList<PlayerHologram> getPlayersHologram() {
        return this.playersHologram;
    }

    public PlayerData getPlayerData(Player player) {
        for (PlayerData playerData : this.players) {
            if (!playerData.getUuid().equals(player.getUniqueId().toString())) continue;
            return playerData;
        }
        return null;
    }

    public PlayerData getPlayerDataByUUID(String string) {
        for (PlayerData playerData : this.players) {
            if (!string.equals(playerData.getUuid())) continue;
            return playerData;
        }
        return null;
    }

    public void addTurret(String string, String string2, PlayerTurret playerTurret) {
        PlayerData playerData = this.getPlayerDataByUUID(string);
        if (playerData == null) {
            playerData = new PlayerData(string, string2, new ArrayList<PlayerTurret>());
            this.players.add(playerData);
        }
        playerData.getTurrets().add(playerTurret);
    }

    public PlayerHologram getPlayerHologram(Player player) {
        for (PlayerHologram playerHologram : this.playersHologram) {
            if (!playerHologram.getPlayer().equals(player)) continue;
            return playerHologram;
        }
        return null;
    }

    public void addPlayerHologram(PlayerHologram playerHologram) {
        this.playersHologram.add(playerHologram);
    }

    public void removePlayerHologram(Player player) {
        int n = 0;
        while (n < this.playersHologram.size()) {
            if (this.playersHologram.get(n).getPlayer().equals(player)) {
                this.playersHologram.remove(n);
            }
            ++n;
        }
    }

    public void restartCooldowns() {
        for (PlayerData playerData : this.players) {
            for (PlayerTurret playerTurret : playerData.getTurrets()) {
                playerTurret.restartCooldown(this.plugin);
            }
        }
    }

    public void removeTurret(Location location, boolean bl) {
        block0: for (PlayerData playerData : this.players) {
            int n = location.getBlockX();
            int n2 = location.getBlockY();
            int n3 = location.getBlockZ();
            String string = location.getWorld().getName();
            ArrayList<PlayerTurret> arrayList = playerData.getTurrets();
            int n4 = 0;
            while (n4 < arrayList.size()) {
                Location location2 = arrayList.get(n4).getLocation();
                int n5 = location2.getBlockX();
                int n6 = location2.getBlockY();
                int n7 = location2.getBlockZ();
                String string2 = location2.getWorld().getName();
                if (n == n5 && n2 == n6 && n3 == n7 && string.equals(string2)) {
                    this.destroyTurret(arrayList.get(n4), bl);
                    this.closeTurretInventory(arrayList.get(n4));
                    arrayList.get(n4).remove();
                    arrayList.remove(n4);
                    continue block0;
                }
                ++n4;
            }
        }
    }

    private void closeTurretInventory(PlayerTurret playerTurret) {
        InventoryManager inventoryManager = this.plugin.getInventoryManager();
        PlayerInventory playerInventory = inventoryManager.getPlayerInventory(playerTurret);
        if (playerInventory != null) {
            Player player = playerInventory.getPlayer();
            inventoryManager.removePlayerInventory(player);
            player.getPlayer().closeInventory();
        }
    }

    private void destroyTurret(final PlayerTurret playerTurret, boolean bl) {
        Location location;
        TurretsManager turretsManager = this.plugin.getTurretsManager();
        Location location2 = playerTurret.getLocation();
        Turret turret = turretsManager.getTurret(playerTurret.getTurretName());
        int n = turret.getStructure().size();
        int n2 = 0;
        while (n2 < n) {
            location = location2.clone().add(0.0, (double)n2, 0.0);
            location.getBlock().setType(Material.AIR);
            ++n2;
        }
        if (this.plugin.getConfigsManager().getMainConfigManager().isInformationHologramsAlwaysVisible()) {
            new BukkitRunnable(){

                public void run() {
                    JugadorManager.this.plugin.getDependencyManager().getHologramsManager().removeInformationHologram(null, playerTurret);
                }
            }.runTask((Plugin)this.plugin);
        }
        if (bl) {
            int n3;
            ItemStack itemStack;
            FileConfiguration fileConfiguration = this.plugin.getConfig();
            UtilsEffects.spawnParticle("EXPLOSION_LARGE", location2, 0.01f, this.plugin.getConfigsManager().getMainConfigManager().isForceParticles());
            UtilsEffects.playSound(location2, fileConfiguration.getString("turret_destroy_sound"), this.plugin);
            location = this.plugin.getMessages();
            MensajesManager mensajesManager = this.plugin.getMensajesManager();
            Player player = Bukkit.getPlayer((String)playerTurret.getOwnerName());
            int n4 = location2.getBlockX();
            int n5 = location2.getBlockY();
            int n6 = location2.getBlockZ();
            World world = location2.getWorld();
            if (player != null) {
                mensajesManager.enviarMensaje((CommandSender)player, location.getString("turretDestroyed").replace("%turret_alias%", turret.getAlias()).replace("%x_coord%", String.valueOf(n4)).replace("%y_coord%", String.valueOf(n5)).replace("%z_coord%", String.valueOf(n6)).replace("%world%", world.getName()), true);
            }
            if (fileConfiguration.getBoolean("drop_turret_on_destroy")) {
                SavedTurretProperties savedTurretProperties = null;
                if (fileConfiguration.getBoolean("save_properties_on_destroy")) {
                    savedTurretProperties = SavedTurretProperties.createProperties(playerTurret);
                }
                itemStack = this.plugin.getItemManager().createTurretItem(null, turret, TurretItemType.BLOCK, playerTurret.getTurretLevel(), savedTurretProperties);
                world.dropItemNaturally(location2, itemStack);
            }
            if (fileConfiguration.getBoolean("drop_ammo_on_destroy") && (n3 = playerTurret.getTotalAmmo()) != 0) {
                itemStack = this.plugin.getItemManager().createTurretItem(null, turret, TurretItemType.AMMUNITION, 0, null);
                int n7 = 0;
                while (n7 < n3) {
                    world.dropItemNaturally(location2, itemStack);
                    ++n7;
                }
            }
        }
    }

    public void updateInformationHologram(PlayerTurret playerTurret) {
        ArrayList<PlayerHologram> arrayList = this.plugin.getJugadorManager().getPlayersHologram();
        HologramsManager hologramsManager = this.plugin.getDependencyManager().getHologramsManager();
        if (playerTurret.getTurretHologram() != null) {
            hologramsManager.updateInformationHologram(null, playerTurret);
        } else {
            int n = 0;
            while (n < arrayList.size()) {
                if (arrayList.get(n).getPlayerTurret().equals(playerTurret)) {
                    hologramsManager.updateInformationHologram(arrayList.get(n).getPlayer(), playerTurret);
                }
                ++n;
            }
        }
    }

    public PlayerTurret getTurretFromLocation(Location location) {
        TurretsManager turretsManager = this.plugin.getTurretsManager();
        int n = location.getBlockX();
        int n2 = location.getBlockY();
        int n3 = location.getBlockZ();
        String string = location.getWorld().getName();
        for (PlayerData playerData : this.players) {
            for (PlayerTurret playerTurret : playerData.getTurrets()) {
                Location location2 = playerTurret.getLocation();
                int n4 = location2.getBlockX();
                int n5 = location2.getBlockZ();
                String string2 = location2.getWorld().getName();
                if (n != n4 || n3 != n5 || !string.equals(string2)) continue;
                int n6 = location2.getBlockY();
                int n7 = n6 + turretsManager.getTurret(playerTurret.getTurretName()).getStructure().size() - 1;
                if (n2 < n6 || n2 > n7) continue;
                return playerTurret;
            }
        }
        return null;
    }

    public void damageTurret(PlayerTurret playerTurret, int n, Player player) {
        int n2 = playerTurret.getCurrentHealth();
        int n3 = n2 - n;
        playerTurret.setCurrentHealth(n3);
        if (n3 <= 0) {
            Location location = playerTurret.getLocation();
            this.removeTurret(location, true);
        } else {
            this.updateInformationHologram(playerTurret);
            if (player != null) {
                FileConfiguration fileConfiguration = this.plugin.getMessages();
                FileConfiguration fileConfiguration2 = this.plugin.getConfig();
                String string = UtilsTurrets.getHealthBar(fileConfiguration2, playerTurret, playerTurret.getMaxHealth());
                int n4 = UtilsTurrets.getHealthPercentage(fileConfiguration2, playerTurret, playerTurret.getMaxHealth());
                TurretsManager turretsManager = this.plugin.getTurretsManager();
                Turret turret = turretsManager.getTurret(playerTurret.getTurretName());
                String string2 = fileConfiguration.getString("actionBarTurretDamageMessage").replace("%damage%", String.valueOf(n)).replace("%owner%", playerTurret.getOwnerName()).replace("%turret_alias%", turret.getAlias()).replace("%current_health%", String.valueOf(n3)).replace("%max_health%", String.valueOf(playerTurret.getMaxHealth())).replace("%health_bar%", string).replace("%health_percentage%", String.valueOf(n4));
                ActionBarAPI.sendActionBar(player, MensajesManager.getMensajeColor(string2));
            }
        }
    }

    public void fixTurretsAmmo() {
        TurretsManager turretsManager = this.plugin.getTurretsManager();
        for (PlayerData playerData : this.players) {
            ArrayList<PlayerTurret> arrayList = playerData.getTurrets();
            for (PlayerTurret playerTurret : arrayList) {
                Turret turret;
                int n;
                int n2 = playerTurret.getTotalAmmo();
                if (n2 <= (n = turretsManager.getMaxAmmo(turret = turretsManager.getTurret(playerTurret.getTurretName()), playerTurret.getTurretLevel()))) continue;
                List<PlayerTurretAmmoInventoryPage> list = PlayerTurret.generateAmmoInventoryFromAmmo(n);
                playerTurret.setAmmoInventoryPages(list);
            }
        }
    }
}

