/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.managers.holograms;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.configs.MainConfigManager;
import ct.ajneb97.managers.JugadorManager;
import ct.ajneb97.managers.MensajesManager;
import ct.ajneb97.managers.holograms.CMIManager;
import ct.ajneb97.managers.holograms.DecentHologramsManager;
import ct.ajneb97.managers.holograms.HologramCompatibility;
import ct.ajneb97.managers.holograms.HolographicDisplaysManager;
import ct.ajneb97.model.PlayerData;
import ct.ajneb97.model.PlayerHologram;
import ct.ajneb97.model.PlayerTurret;
import ct.ajneb97.model.TurretHologram;
import ct.ajneb97.model.estructura.Turret;
import ct.ajneb97.model.estructura.TurretUpgrade;
import ct.ajneb97.utils.UtilsMath;
import ct.ajneb97.utils.UtilsTurrets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class HologramsManager {
    private ComplexTurrets plugin;
    private HologramCompatibility hologramCompatibility;
    private HolographicDisplaysManager holographicDisplays;
    private CMIManager cmi;
    private DecentHologramsManager decentHolograms;

    public HologramsManager(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
        this.configurar();
    }

    public void configurar() {
        this.holographicDisplays = new HolographicDisplaysManager(this.plugin);
        this.cmi = new CMIManager(this.plugin);
        this.decentHolograms = new DecentHologramsManager(this.plugin);
        if (Bukkit.getServer().getPluginManager().getPlugin("HolographicDisplays") != null) {
            this.hologramCompatibility = HologramCompatibility.HOLOGRAPHIC_DISPLAY;
        } else if (Bukkit.getServer().getPluginManager().getPlugin("DecentHolograms") != null) {
            this.hologramCompatibility = HologramCompatibility.DECENT_HOLOGRAMS;
        } else if (Bukkit.getServer().getPluginManager().getPlugin("CMI") != null) {
            this.hologramCompatibility = HologramCompatibility.CMI;
        }
    }

    public List<String> getHologramMessage(PlayerTurret playerTurret, Turret turret, FileConfiguration fileConfiguration, FileConfiguration fileConfiguration2) {
        int n;
        int n2 = playerTurret.getTurretLevel();
        TurretUpgrade turretUpgrade = turret.getUpgrade(n2);
        double d = turretUpgrade.getMinDamage();
        double d2 = turretUpgrade.getMaxDamage();
        double d3 = turretUpgrade.getMinHeal();
        double d4 = turretUpgrade.getMaxHeal();
        long l = playerTurret.getActivationDelayMillis() - System.currentTimeMillis();
        ArrayList<String> arrayList = new ArrayList<String>(turret.getHologram());
        if (!playerTurret.isEnabled()) {
            arrayList.add(fileConfiguration.getString("informationHologramNotEnabledError"));
        } else if (l > 0L) {
            n = (int)l / 1000;
            arrayList.add(fileConfiguration.getString("informationHologramActivationDelayError").replace("%time%", String.valueOf(n)));
        } else {
            n = playerTurret.getTotalAmmo();
            if (turret.isRequireAmmunition() && n == 0 && !playerTurret.isInfiniteAmmo()) {
                arrayList.add(fileConfiguration.getString("informationHologramNoAmmoError"));
            }
        }
        n = turretUpgrade.getHealth();
        int n3 = playerTurret.getCurrentHealth();
        String string = UtilsTurrets.getHealthBar(fileConfiguration2, playerTurret, n);
        int n4 = UtilsTurrets.getHealthPercentage(fileConfiguration2, playerTurret, n);
        int n5 = playerTurret.getTotalAmmo();
        int n6 = 0;
        while (n6 < arrayList.size()) {
            arrayList.set(n6, MensajesManager.getMensajeColor(((String)arrayList.get(n6)).replace("%owner%", playerTurret.getOwnerName()).replace("%level%", String.valueOf(n2)).replace("%min_damage%", String.valueOf(d)).replace("%max_damage%", String.valueOf(d2)).replace("%current_health%", String.valueOf(n3)).replace("%max_health%", String.valueOf(n)).replace("%min_heal%", String.valueOf(d3)).replace("%max_heal%", String.valueOf(d4)).replace("%health_bar%", string).replace("%health_percentage%", String.valueOf(n4)).replace("%ammo%", String.valueOf(n5))));
            ++n6;
        }
        return arrayList;
    }

    public Location getHologramLocation(List<String> list, PlayerTurret playerTurret, Turret turret) {
        Location location = playerTurret.getLocation().clone().add(0.5, (double)turret.getStructure().size(), 0.5);
        double d = (double)list.size() * 0.2 + turret.getHologramVerticalOffset();
        location = location.add(0.0, d, 0.0);
        return location;
    }

    public void createInformationHologram(Player player, PlayerTurret playerTurret) {
        FileConfiguration fileConfiguration = this.plugin.getMessages();
        FileConfiguration fileConfiguration2 = this.plugin.getConfig();
        Turret turret = this.plugin.getTurretsManager().getTurret(playerTurret.getTurretName());
        List<String> list = this.getHologramMessage(playerTurret, turret, fileConfiguration, fileConfiguration2);
        Location location = this.getHologramLocation(list, playerTurret, turret);
        if (this.hologramCompatibility == null) {
            return;
        }
        switch (this.hologramCompatibility) {
            case CMI: {
                this.cmi.createInformationHologram(player, location, list, playerTurret);
                break;
            }
            case DECENT_HOLOGRAMS: {
                this.decentHolograms.createInformationHologram(player, location, list, playerTurret);
                break;
            }
            case HOLOGRAPHIC_DISPLAY: {
                this.holographicDisplays.createInformationHologram(player, location, list, playerTurret);
            }
        }
    }

    public void removeInformationHologram(Player player, PlayerTurret playerTurret) {
        long l = 0L;
        String string = null;
        JugadorManager jugadorManager = this.plugin.getJugadorManager();
        if (player != null) {
            PlayerHologram playerHologram = jugadorManager.getPlayerHologram(player);
            if (playerHologram == null) {
                return;
            }
            l = playerHologram.getHolographicDisplaysTimestamp();
            string = playerHologram.getCmiName();
        } else {
            TurretHologram turretHologram = playerTurret.getTurretHologram();
            if (turretHologram == null) {
                return;
            }
            l = turretHologram.getHolographicDisplaysTimestamp();
            string = turretHologram.getCmiName();
        }
        if (this.hologramCompatibility == null) {
            return;
        }
        switch (this.hologramCompatibility) {
            case CMI: {
                this.cmi.removeHologram(string);
                break;
            }
            case DECENT_HOLOGRAMS: {
                this.decentHolograms.removeHologram(string);
                break;
            }
            case HOLOGRAPHIC_DISPLAY: {
                this.holographicDisplays.removeHologram(l);
            }
        }
        if (player != null) {
            jugadorManager.removePlayerHologram(player);
        }
    }

    public void updateInformationHologram(Player player, PlayerTurret playerTurret) {
        long l = 0L;
        String string = null;
        JugadorManager jugadorManager = this.plugin.getJugadorManager();
        if (player != null) {
            PlayerHologram playerHologram = jugadorManager.getPlayerHologram(player);
            if (playerHologram != null) {
                l = playerHologram.getHolographicDisplaysTimestamp();
                string = playerHologram.getCmiName();
            }
        } else {
            TurretHologram turretHologram = playerTurret.getTurretHologram();
            l = turretHologram.getHolographicDisplaysTimestamp();
            string = turretHologram.getCmiName();
        }
        if (this.hologramCompatibility == null) {
            return;
        }
        switch (this.hologramCompatibility) {
            case CMI: {
                this.cmi.updateInformationHologram(string, playerTurret);
                break;
            }
            case DECENT_HOLOGRAMS: {
                this.decentHolograms.updateInformationHologram(string, playerTurret);
                break;
            }
            case HOLOGRAPHIC_DISPLAY: {
                this.holographicDisplays.updateInformationHologram(l, playerTurret);
            }
        }
    }

    public void reloadHolograms() {
        MainConfigManager mainConfigManager = this.plugin.getConfigsManager().getMainConfigManager();
        boolean bl = false;
        if (mainConfigManager.isInformationHolograms() && mainConfigManager.isInformationHologramsAlwaysVisible()) {
            bl = true;
        }
        ArrayList<PlayerData> arrayList = this.plugin.getJugadorManager().getPlayers();
        for (PlayerData playerData : arrayList) {
            for (PlayerTurret playerTurret : playerData.getTurrets()) {
                this.removeInformationHologram(null, playerTurret);
                if (!bl) continue;
                this.createInformationHologram(null, playerTurret);
            }
        }
    }

    public void createHitHologram(Turret turret, String string, String string2, Location location, int n, boolean bl) {
        double d = UtilsMath.getRandomNumber(180, 250) / 100.0;
        double d2 = UtilsMath.getRandomNumber(20, 50) / 100.0;
        double d3 = UtilsMath.getRandomNumber(20, 50) / 100.0;
        Location location2 = location.clone();
        Random random = new Random();
        int n2 = random.nextInt(10);
        if (n2 >= 5) {
            d2 = -d2;
        }
        if ((n2 = random.nextInt(10)) >= 5) {
            d3 = -d3;
        }
        ArrayList<String> arrayList = new ArrayList<String>(turret.getHitHologram());
        if (bl && turret.getHitHologramCriticalHit() != null) {
            arrayList = new ArrayList<String>(turret.getHitHologramCriticalHit());
        }
        int n3 = 0;
        while (n3 < arrayList.size()) {
            arrayList.set(n3, MensajesManager.getMensajeColor(((String)arrayList.get(n3)).replace("%value%", string).replace("%owner%", string2)));
            ++n3;
        }
        double d4 = (double)arrayList.size() * 0.2;
        location2 = location2.add(d2, d += d4, d3);
        if (this.hologramCompatibility == null) {
            return;
        }
        switch (this.hologramCompatibility) {
            case CMI: {
                this.cmi.createHitHologram(arrayList, location2, n);
                break;
            }
            case DECENT_HOLOGRAMS: {
                this.decentHolograms.createHitHologram(arrayList, location2, n);
                break;
            }
            case HOLOGRAPHIC_DISPLAY: {
                this.holographicDisplays.createHitHologram(arrayList, location2, n);
            }
        }
    }
}

