/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.tasks;

import ct.ajneb97.ComplexTurrets;
import ct.ajneb97.managers.JugadorManager;
import ct.ajneb97.managers.TurretsManager;
import ct.ajneb97.model.PlayerData;
import ct.ajneb97.model.PlayerTurret;
import ct.ajneb97.model.estructura.Turret;
import ct.ajneb97.utils.UtilsOthers;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GlobalCheckTask {
    private ComplexTurrets plugin;
    private boolean end;

    public GlobalCheckTask(ComplexTurrets complexTurrets) {
        this.plugin = complexTurrets;
        this.end = false;
    }

    public void start() {
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        int n = fileConfiguration.getInt("turrets_global_check_time");
        new BukkitRunnable(){

            public void run() {
                if (GlobalCheckTask.this.end) {
                    this.cancel();
                } else {
                    GlobalCheckTask.this.execute();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, 20L * (long)n);
    }

    public void end() {
        this.end = true;
    }

    public void execute() {
        if (this.plugin.isPluginDisabled()) {
            return;
        }
        JugadorManager jugadorManager = this.plugin.getJugadorManager();
        ArrayList<PlayerData> arrayList = jugadorManager.getPlayers();
        TurretsManager turretsManager = this.plugin.getTurretsManager();
        for (PlayerData playerData : arrayList) {
            ArrayList<PlayerTurret> arrayList2 = playerData.getTurrets();
            int n = 0;
            while (n < arrayList2.size()) {
                Location location = arrayList2.get(n).getLocation();
                if (UtilsOthers.isChunkLoaded(location)) {
                    Turret turret = turretsManager.getTurret(arrayList2.get(n).getTurretName());
                    int n2 = turret.getStructure().size();
                    int n3 = 0;
                    while (n3 < n2) {
                        Location location2 = location.clone().add(0.0, (double)n3, 0.0);
                        Block block = location2.getBlock();
                        if (block == null || block.getType().name().equals("AIR") || block.getType().name().contains("_AIR")) {
                            --n;
                            this.removeTurret(jugadorManager, location);
                            break;
                        }
                        ++n3;
                    }
                }
                ++n;
            }
        }
    }

    public void removeTurret(final JugadorManager jugadorManager, final Location location) {
        new BukkitRunnable(){

            public void run() {
                jugadorManager.removeTurret(location, true);
            }
        }.runTask((Plugin)this.plugin);
    }
}

