/*
 * Decompiled with CFR 0.152.
 */
package ct.ajneb97.utils;

import ct.ajneb97.managers.MensajesManager;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventarioItem {
    private Inventory inventory;
    private int slot;
    private ItemStack item;
    private ItemMeta meta;

    public InventarioItem(Inventory inventory, int n, Material material) {
        this.inventory = inventory;
        this.item = new ItemStack(material);
        this.meta = this.item.getItemMeta();
        this.slot = n;
    }

    public InventarioItem dataValue(short s) {
        this.item.setDurability(s);
        return this;
    }

    public InventarioItem cantidad(int n) {
        this.item.setAmount(n);
        return this;
    }

    public InventarioItem nombre(String string) {
        this.meta.setDisplayName(MensajesManager.getMensajeColor(string));
        return this;
    }

    public InventarioItem lore(List<String> list) {
        int n = 0;
        while (n < list.size()) {
            list.set(n, MensajesManager.getMensajeColor(list.get(n)));
            ++n;
        }
        this.meta.setLore(list);
        return this;
    }

    public InventarioItem encantado(boolean bl) {
        if (bl) {
            this.meta.addEnchant(Enchantment.ARROW_DAMAGE, 1, true);
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        return this;
    }

    public void listo() {
        this.item.setItemMeta(this.meta);
        this.inventory.setItem(this.slot, this.item);
    }
}

