/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.manager;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.listener.JoinQuitListener;
import net.momirealms.customnameplates.manager.ConfigManager;
import net.momirealms.customnameplates.object.Function;
import net.momirealms.customnameplates.object.bossbar.BossBarConfig;
import net.momirealms.customnameplates.object.bossbar.BossBarTask;
import net.momirealms.customnameplates.object.bossbar.Overlay;
import net.momirealms.customnameplates.utils.AdventureUtils;
import net.momirealms.customnameplates.utils.ConfigUtils;
import net.momirealms.customnameplates.utils.GeyserUtils;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class BossBarManager
extends Function {
    private final LinkedHashMap<String, BossBarConfig> bossBars;
    private final ConcurrentHashMap<UUID, BossBarTask> bossBarTaskMap;
    private final JoinQuitListener joinQuitListener;
    private final CustomNameplates plugin;

    public BossBarManager(CustomNameplates plugin) {
        this.plugin = plugin;
        this.joinQuitListener = new JoinQuitListener(this);
        this.bossBarTaskMap = new ConcurrentHashMap();
        this.bossBars = new LinkedHashMap();
    }

    @Override
    public void load() {
        if (!ConfigManager.enableBossBar) {
            return;
        }
        this.loadConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this.joinQuitListener, (Plugin)this.plugin);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.onJoin(player);
        }
    }

    @Override
    public void unload() {
        for (BossBarTask bossBarTask : this.bossBarTaskMap.values()) {
            bossBarTask.stop();
        }
        this.bossBarTaskMap.clear();
        HandlerList.unregisterAll((Listener)this.joinQuitListener);
    }

    @Override
    public void onJoin(Player player) {
        if (ConfigManager.disableForBedrock && this.plugin.getVersionHelper().isGeyser() && GeyserUtils.isBedrockPlayer(player.getUniqueId())) {
            return;
        }
        BossBarTask bossBarTask = new BossBarTask(player, this.bossBars.values().toArray(new BossBarConfig[0]));
        this.bossBarTaskMap.put(player.getUniqueId(), bossBarTask);
        bossBarTask.start();
    }

    @Override
    public void onQuit(Player player) {
        BossBarTask bossBarTask = this.bossBarTaskMap.remove(player.getUniqueId());
        if (bossBarTask != null) {
            bossBarTask.stop();
        }
    }

    private void loadConfig() {
        this.bossBars.clear();
        YamlConfiguration config = ConfigUtils.getConfig("configs" + File.separator + "bossbar.yml");
        for (String key : config.getKeys(false)) {
            String[] stringArray;
            ConfigurationSection bossBarSection = config.getConfigurationSection(key);
            if (bossBarSection == null) continue;
            if (bossBarSection.getString("text") == null) {
                stringArray = bossBarSection.getStringList("dynamic-text").toArray(new String[0]);
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = bossBarSection.getString("text");
            }
            this.bossBars.put(key, new BossBarConfig(stringArray, Overlay.valueOf(bossBarSection.getString("overlay", "progress").toUpperCase(Locale.ENGLISH)), BarColor.valueOf((String)bossBarSection.getString("color", "white").toUpperCase(Locale.ENGLISH)), bossBarSection.getInt("switch-interval", 5) * 20, Math.max(1, bossBarSection.getInt("refresh-rate", 1)), ConfigUtils.getRequirements(bossBarSection.getConfigurationSection("conditions"))));
        }
        AdventureUtils.consoleMessage("[CustomNameplates] Loaded <green>" + this.bossBars.size() + " <gray>bossbars");
    }

    public LinkedHashMap<String, BossBarConfig> getBossBars() {
        return this.bossBars;
    }
}

