/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object.actionbar;

import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.object.actionbar.ActionBarConfig;
import net.momirealms.customnameplates.object.actionbar.ActionBarSender;
import net.momirealms.customnameplates.object.scheduler.TimerTask;
import org.bukkit.entity.Player;

public class ActionBarTask {
    private TimerTask timerTask;
    private final ActionBarSender[] actionBarSenders;
    private String otherText;
    private long expireTime;

    public ActionBarTask(Player player, ActionBarConfig[] configs) {
        this.actionBarSenders = new ActionBarSender[configs.length];
        this.otherText = "";
        for (int i = 0; i < configs.length; ++i) {
            ActionBarConfig actionBarConfig = configs[i];
            this.actionBarSenders[i] = new ActionBarSender(actionBarConfig.interval(), actionBarConfig.texts(), actionBarConfig.conditions(), player);
        }
    }

    public void stop() {
        if (this.timerTask != null && !this.timerTask.isCancelled()) {
            this.timerTask.cancel();
        }
    }

    public void start() {
        this.timerTask = CustomNameplates.getInstance().getScheduler().runTaskAsyncTimer(() -> {
            if (System.currentTimeMillis() > this.getExpireTime()) {
                this.otherText = "";
            }
            for (ActionBarSender actionBarSender : this.actionBarSenders) {
                if (!actionBarSender.canSend()) continue;
                actionBarSender.send();
                return;
            }
        }, 1L, 1L);
    }

    public String getOtherText() {
        return this.otherText;
    }

    public void setOtherText(String otherText, long time) {
        this.otherText = otherText;
        this.expireTime = time + 4000L;
    }

    public long getExpireTime() {
        return this.expireTime;
    }
}

