/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object.carrier;

import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.listener.JoinQuitListener;
import net.momirealms.customnameplates.manager.TeamManager;
import net.momirealms.customnameplates.object.DisplayMode;
import net.momirealms.customnameplates.object.Function;
import net.momirealms.customnameplates.object.scheduler.TimerTask;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public abstract class AbstractTextCarrier
extends Function {
    protected TimerTask refreshTask;
    protected CustomNameplates plugin;
    protected JoinQuitListener joinQuitListener;
    protected DisplayMode displayMode;

    public AbstractTextCarrier(CustomNameplates plugin, DisplayMode displayMode) {
        this.displayMode = displayMode;
        this.plugin = plugin;
        this.joinQuitListener = new JoinQuitListener(this);
    }

    @Override
    public void load() {
        this.loadToAllPlayers();
        this.arrangeRefreshTask();
        Bukkit.getPluginManager().registerEvents((Listener)this.joinQuitListener, (Plugin)this.plugin);
    }

    @Override
    public void unload() {
        if (this.refreshTask != null) {
            this.refreshTask.cancel();
        }
        HandlerList.unregisterAll((Listener)this.joinQuitListener);
    }

    public void arrangeRefreshTask() {
    }

    public void loadToAllPlayers() {
        TeamManager teamManager = this.plugin.getTeamManager();
        for (Player player : Bukkit.getOnlinePlayers()) {
            teamManager.sendUpdateToAll(player, true);
            teamManager.sendUpdateToOne(player);
        }
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }
}

