/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.object.carrier;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.listener.EntityTagListener;
import net.momirealms.customnameplates.listener.compatibility.MagicCosmeticsListener;
import net.momirealms.customnameplates.object.ConditionalText;
import net.momirealms.customnameplates.object.DisplayMode;
import net.momirealms.customnameplates.object.carrier.AbstractPacketsHandler;
import net.momirealms.customnameplates.object.carrier.AbstractTextCarrier;
import net.momirealms.customnameplates.object.carrier.NamedEntityManager;
import net.momirealms.customnameplates.object.carrier.NamedEntityPacketsHandler;
import net.momirealms.customnameplates.object.carrier.VehicleChecker;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class NamedEntityCarrier
extends AbstractTextCarrier {
    protected final ConcurrentHashMap<Player, NamedEntityManager> namedEntityManagerMap = new ConcurrentHashMap();
    protected EntityTagListener entityTagListener;
    protected AbstractPacketsHandler handler;
    protected MagicCosmeticsListener magicCosmeticsListener;
    private final VehicleChecker vehicleChecker = new VehicleChecker(this);
    private final HashMap<ConditionalText, Double> persistentText;

    public NamedEntityCarrier(CustomNameplates plugin, DisplayMode displayMode, @NotNull HashMap<ConditionalText, Double> persistentText) {
        super(plugin, displayMode);
        this.entityTagListener = new EntityTagListener(this);
        this.persistentText = persistentText;
        this.handler = new NamedEntityPacketsHandler(this);
        if (Bukkit.getPluginManager().getPlugin("MagicCosmetics") != null) {
            this.magicCosmeticsListener = new MagicCosmeticsListener(this);
        }
    }

    @Override
    public void load() {
        super.load();
        this.handler.load();
        this.vehicleChecker.load();
        Bukkit.getPluginManager().registerEvents((Listener)this.entityTagListener, (Plugin)CustomNameplates.getInstance());
        if (this.magicCosmeticsListener != null) {
            Bukkit.getPluginManager().registerEvents((Listener)this.magicCosmeticsListener, (Plugin)CustomNameplates.getInstance());
        }
    }

    @Override
    public void unload() {
        super.unload();
        this.handler.unload();
        for (NamedEntityManager nem : this.namedEntityManagerMap.values()) {
            nem.destroy();
        }
        this.namedEntityManagerMap.clear();
        HandlerList.unregisterAll((Listener)this.entityTagListener);
        this.vehicleChecker.unload();
        if (this.magicCosmeticsListener != null) {
            HandlerList.unregisterAll((Listener)this.magicCosmeticsListener);
        }
    }

    @Override
    public void onJoin(Player player) {
        this.handler.onJoin(player);
        this.createNamedEntityManager(player);
        for (Player viewer : Bukkit.getOnlinePlayers()) {
            this.spawnNamedEntity(viewer, player);
            this.spawnNamedEntity(player, viewer);
        }
    }

    @Override
    public void onQuit(Player player) {
        this.handler.onQuit(player);
        NamedEntityManager nem = this.namedEntityManagerMap.remove(player);
        if (nem != null) {
            nem.destroy();
        }
        for (NamedEntityManager all : this.namedEntityManagerMap.values()) {
            all.unregisterPlayer(player);
        }
    }

    @Override
    public void loadToAllPlayers() {
        super.loadToAllPlayers();
        for (Player all : Bukkit.getOnlinePlayers()) {
            this.createNamedEntityManager(all);
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.spawnNamedEntity(player, all);
            }
        }
    }

    public NamedEntityManager createNamedEntityManager(Player player) {
        NamedEntityManager nem = new NamedEntityManager(this, player);
        this.namedEntityManagerMap.put(player, nem);
        return nem;
    }

    public void onSneak(Player player, boolean isSneaking) {
        if (player.isFlying()) {
            return;
        }
        NamedEntityManager nem = this.getNamedEntityManager(player);
        if (nem != null) {
            nem.setSneak(isSneaking, true);
        }
    }

    public void onRespawn(Player player) {
        this.getNamedEntityManager(player).respawn();
    }

    public void onDeath(Player player) {
        this.getNamedEntityManager(player).destroy();
    }

    @Override
    public void arrangeRefreshTask() {
        this.refreshTask = this.plugin.getScheduler().runTaskAsyncTimer(() -> {
            for (NamedEntityManager nem : this.namedEntityManagerMap.values()) {
                nem.refresh(false);
            }
        }, 1L, 1L);
    }

    public NamedEntityManager getNamedEntityManager(Player player) {
        return this.namedEntityManagerMap.get(player);
    }

    protected void spawnNamedEntity(Player viewer, Player target) {
        if (target == viewer || target.getGameMode() == GameMode.SPECTATOR || viewer.getWorld() != target.getWorld() || target.isDead()) {
            return;
        }
        if (this.getDistance(target, viewer) < 48.0 && viewer.canSee(target)) {
            NamedEntityManager nem = this.getNamedEntityManager(target);
            nem.spawn(viewer);
        }
    }

    protected double getDistance(Player player1, Player player2) {
        Location loc1 = player1.getLocation();
        Location loc2 = player2.getLocation();
        return Math.sqrt(Math.pow(loc1.getX() - loc2.getX(), 2.0) + Math.pow(loc1.getZ() - loc2.getZ(), 2.0));
    }

    public HashMap<ConditionalText, Double> getPersistentText() {
        return this.persistentText;
    }
}

