/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.utils;

import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.dvs.versioning.BasicVersioning;
import dev.dejvokep.boostedyaml.dvs.versioning.Versioning;
import dev.dejvokep.boostedyaml.settings.dumper.DumperSettings;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.loader.LoaderSettings;
import dev.dejvokep.boostedyaml.settings.updater.UpdaterSettings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import net.momirealms.customnameplates.CustomNameplates;
import net.momirealms.customnameplates.helper.Log;
import net.momirealms.customnameplates.object.carrier.TextDisplayMeta;
import net.momirealms.customnameplates.object.requirements.BiomeImpl;
import net.momirealms.customnameplates.object.requirements.CustomPapiImpl;
import net.momirealms.customnameplates.object.requirements.DateImpl;
import net.momirealms.customnameplates.object.requirements.GeyserImpl;
import net.momirealms.customnameplates.object.requirements.PermissionImpl;
import net.momirealms.customnameplates.object.requirements.Requirement;
import net.momirealms.customnameplates.object.requirements.TimeImpl;
import net.momirealms.customnameplates.object.requirements.WeatherImpl;
import net.momirealms.customnameplates.object.requirements.WorldImpl;
import net.momirealms.customnameplates.object.requirements.YPosImpl;
import net.momirealms.customnameplates.utils.AdventureUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigUtils {
    public static void update(String file_name) {
        try {
            YamlDocument.create((File)new File(CustomNameplates.getInstance().getDataFolder(), file_name), (InputStream)Objects.requireNonNull(CustomNameplates.getInstance().getResource(file_name)), (GeneralSettings)GeneralSettings.DEFAULT, (LoaderSettings)LoaderSettings.builder().setAutoUpdate(true).build(), (DumperSettings)DumperSettings.DEFAULT, (UpdaterSettings)UpdaterSettings.builder().setVersioning((Versioning)new BasicVersioning("config-version")).build());
        }
        catch (IOException e) {
            Log.warn(e.getMessage());
        }
    }

    public static YamlConfiguration getConfig(String config_name) {
        File file = new File(CustomNameplates.getInstance().getDataFolder(), config_name);
        if (!file.exists()) {
            CustomNameplates.getInstance().saveResource(config_name, false);
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public static YamlConfiguration readData(File file) {
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                if (!file.createNewFile()) {
                    AdventureUtils.consoleMessage("<red>[CustomNameplates] Failed to generate data files!</red>");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                AdventureUtils.consoleMessage("<red>[CustomNameplates] Failed to generate data files!</red>");
            }
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public static Requirement[] getRequirements(ConfigurationSection section) {
        ArrayList<Object> requirements = new ArrayList<Object>();
        if (section != null) {
            Iterator iterator = section.getKeys(false).iterator();
            while (iterator.hasNext()) {
                String type;
                switch (type = (String)iterator.next()) {
                    case "biome": {
                        requirements.add(new BiomeImpl(new HashSet<String>(section.getStringList(type))));
                        break;
                    }
                    case "weather": {
                        requirements.add(new WeatherImpl(section.getStringList(type)));
                        break;
                    }
                    case "ypos": {
                        requirements.add(new YPosImpl(section.getStringList(type)));
                        break;
                    }
                    case "world": {
                        requirements.add(new WorldImpl(section.getStringList(type)));
                        break;
                    }
                    case "permission": {
                        requirements.add(new PermissionImpl(section.getString(type)));
                        break;
                    }
                    case "time": {
                        requirements.add(new TimeImpl(section.getStringList(type)));
                        break;
                    }
                    case "date": {
                        requirements.add(new DateImpl(new HashSet<String>(section.getStringList(type))));
                        break;
                    }
                    case "geyser": {
                        requirements.add(new GeyserImpl(section.getBoolean(type)));
                        break;
                    }
                    case "papi-condition": {
                        requirements.add(new CustomPapiImpl(Objects.requireNonNull(section.getConfigurationSection(type)).getValues(false)));
                    }
                }
            }
        }
        return requirements.toArray(new Requirement[0]);
    }

    public static TextDisplayMeta getTextDisplayMeta(ConfigurationSection section) {
        if (section == null) {
            return TextDisplayMeta.defaultValue;
        }
        return new TextDisplayMeta(section.getBoolean("has-shadow", false), section.getBoolean("is-see-through", false), section.getBoolean("use-default-background-color", false), ConfigUtils.rgbToDecimal(section.getString("background-color", "0,0,0,128")), (byte)section.getInt("text-opacity"));
    }

    public static int rgbToDecimal(String rgba) {
        String[] split = rgba.split(",");
        int r = Integer.parseInt(split[0]);
        int g = Integer.parseInt(split[1]);
        int b = Integer.parseInt(split[2]);
        int a = Integer.parseInt(split[3]);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

