/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.api.mechanic.bubble;

import net.momirealms.customnameplates.api.mechanic.character.ConfiguredChar;
import net.momirealms.customnameplates.api.mechanic.font.OffsetFont;
import net.momirealms.customnameplates.api.util.FontUtils;

public class Bubble {
    private String startFormat;
    private String endFormat;
    private String displayName;
    private ConfiguredChar left;
    private ConfiguredChar middle;
    private ConfiguredChar right;
    private ConfiguredChar tail;

    private Bubble() {
    }

    public Bubble(String startFormat, String endFormat, String displayName, ConfiguredChar left, ConfiguredChar middle, ConfiguredChar right, ConfiguredChar tail) {
        this.startFormat = startFormat;
        this.endFormat = endFormat;
        this.displayName = displayName;
        this.left = left;
        this.middle = middle;
        this.right = right;
        this.tail = tail;
    }

    public String getPrefixWithFont(int textWidth) {
        return FontUtils.surroundNameplateFont(this.getPrefix(textWidth));
    }

    public String getPrefix(int textWidth) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<#FEFEFE>");
        stringBuilder.append(OffsetFont.getShortestNegChars(textWidth + this.left.getWidth() + 1));
        stringBuilder.append(this.left.getCharacter());
        stringBuilder.append(OffsetFont.NEG_1.getCharacter());
        int mid_amount = textWidth - 1 <= this.tail.getWidth() ? -1 : (textWidth - 1 - this.tail.getWidth()) / this.middle.getWidth();
        if (mid_amount == -1) {
            stringBuilder.append("<#FDFEFE>").append(this.tail.getCharacter()).append("</#FDFEFE>").append(OffsetFont.NEG_1.getCharacter());
        } else if (mid_amount == 0) {
            stringBuilder.append("<#FDFEFE>").append(this.tail.getCharacter()).append("</#FDFEFE>").append(OffsetFont.NEG_1.getCharacter());
            stringBuilder.append(OffsetFont.getShortestNegChars(this.middle.getWidth() - (textWidth - 1 - this.tail.getWidth()) % this.middle.getWidth()));
            stringBuilder.append(this.middle.getCharacter()).append(OffsetFont.NEG_1.getCharacter());
        } else {
            stringBuilder.append(this.middle.getCharacter()).append(OffsetFont.NEG_1.getCharacter());
            for (int i = 0; i < mid_amount; ++i) {
                if (i == mid_amount / 2) {
                    stringBuilder.append("<#FDFEFE>").append(this.tail.getCharacter()).append("</#FDFEFE>").append(OffsetFont.NEG_1.getCharacter());
                    continue;
                }
                stringBuilder.append(this.middle.getCharacter()).append(OffsetFont.NEG_1.getCharacter());
            }
            stringBuilder.append(OffsetFont.getShortestNegChars(this.middle.getWidth() - (textWidth - 1 - this.tail.getWidth()) % this.middle.getWidth()));
            stringBuilder.append(this.middle.getCharacter()).append(OffsetFont.NEG_1.getCharacter());
        }
        stringBuilder.append("<#FDFEFE>");
        stringBuilder.append(this.right.getCharacter());
        stringBuilder.append("</#FDFEFE>");
        stringBuilder.append(OffsetFont.getShortestNegChars(textWidth + this.right.getWidth()));
        stringBuilder.append("</#FEFEFE>");
        return stringBuilder.toString();
    }

    public String getSuffixWithFont(int textWidth) {
        return FontUtils.surroundNameplateFont(this.getSuffix(textWidth));
    }

    public String getSuffix(int textWidth) {
        return OffsetFont.getShortestNegChars(textWidth + textWidth % 2 + 1);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStartFormat() {
        return this.startFormat;
    }

    public String getEndFormat() {
        return this.endFormat;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ConfiguredChar getLeft() {
        return this.left;
    }

    public ConfiguredChar getMiddle() {
        return this.middle;
    }

    public ConfiguredChar getRight() {
        return this.right;
    }

    public ConfiguredChar getTail() {
        return this.tail;
    }

    public static class Builder {
        private final Bubble bubble = new Bubble();

        public static Builder of() {
            return new Builder();
        }

        public Builder startFormat(String startFormat) {
            this.bubble.startFormat = startFormat;
            return this;
        }

        public Builder endFormat(String endFormat) {
            this.bubble.endFormat = endFormat;
            return this;
        }

        public Builder left(ConfiguredChar left) {
            this.bubble.left = left;
            return this;
        }

        public Builder displayName(String displayName) {
            this.bubble.displayName = displayName;
            return this;
        }

        public Builder middle(ConfiguredChar middle) {
            this.bubble.middle = middle;
            return this;
        }

        public Builder right(ConfiguredChar right) {
            this.bubble.right = right;
            return this;
        }

        public Builder tail(ConfiguredChar tail) {
            this.bubble.tail = tail;
            return this;
        }

        public Bubble build() {
            return this.bubble;
        }
    }
}

