/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.api.mechanic.placeholder;

import me.clip.placeholderapi.PlaceholderAPI;
import net.momirealms.customnameplates.api.mechanic.background.BackGround;
import net.momirealms.customnameplates.api.util.FontUtils;
import org.bukkit.OfflinePlayer;

public class BackGroundText {
    private String text;
    private BackGround backGround;
    private boolean removeShadow;

    private BackGroundText() {
    }

    public BackGroundText(String text, BackGround backGround, boolean removeShadow) {
        this.text = text;
        this.backGround = backGround;
        this.removeShadow = removeShadow;
    }

    public String getText() {
        return this.text;
    }

    public BackGround getBackGround() {
        return this.backGround;
    }

    public String getValue(OfflinePlayer player) {
        String parsed = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)this.text);
        if (parsed.equals("")) {
            return "";
        }
        int parsedWidth = FontUtils.getTextWidth(parsed);
        String bg = FontUtils.surroundNameplateFont(this.backGround.getBackGroundImage(parsedWidth));
        return (String)(this.removeShadow ? "<#FFFEFD>" + bg + "</#FFFEFD>" : bg) + parsed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final BackGroundText text = new BackGroundText();

        public static Builder of() {
            return new Builder();
        }

        public Builder text(String value) {
            this.text.text = value;
            return this;
        }

        public Builder background(BackGround backGround) {
            this.text.backGround = backGround;
            return this;
        }

        public Builder removeShadow(boolean remove) {
            this.text.removeShadow = remove;
            return this;
        }

        public BackGroundText build() {
            return this.text;
        }
    }
}

