/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.api.mechanic.placeholder;

import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import net.momirealms.customnameplates.api.manager.RequirementManager;
import net.momirealms.customnameplates.api.requirement.Condition;
import net.momirealms.customnameplates.api.requirement.Requirement;
import net.momirealms.customnameplates.common.Pair;
import org.bukkit.OfflinePlayer;

public class ConditionalText {
    private List<Pair<String, Requirement[]>> textList;

    private ConditionalText() {
    }

    public ConditionalText(List<Pair<String, Requirement[]>> textList) {
        this.textList = textList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getValue(OfflinePlayer player) {
        Condition condition = new Condition(player);
        for (Pair<String, Requirement[]> pair : this.textList) {
            if (!RequirementManager.isRequirementMet(condition, pair.right())) continue;
            return PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)pair.left());
        }
        return "";
    }

    public static class Builder {
        private final ConditionalText conditionalText = new ConditionalText();

        public static Builder of() {
            return new Builder();
        }

        public Builder textList(List<Pair<String, Requirement[]>> textList) {
            this.conditionalText.textList = textList;
            return this;
        }

        public ConditionalText build() {
            return this.conditionalText;
        }
    }
}

