/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.api.mechanic.placeholder;

import me.clip.placeholderapi.PlaceholderAPI;
import net.momirealms.customnameplates.api.util.FontUtils;
import org.bukkit.OfflinePlayer;

public class DescentText {
    private int ascent;
    private String text;
    private boolean isUnicode;

    public DescentText(int ascent, String text, boolean isUnicode) {
        this.ascent = ascent;
        this.text = text;
        this.isUnicode = isUnicode;
    }

    private DescentText() {
    }

    public int getAscent() {
        return this.ascent;
    }

    public boolean isUnicode() {
        return this.isUnicode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getValue(OfflinePlayer player) {
        String parsed = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)this.text);
        return FontUtils.surroundAscentFont(parsed, this.ascent);
    }

    public static class Builder {
        private final DescentText descentText = new DescentText();

        public static Builder of() {
            return new Builder();
        }

        public Builder ascent(int ascent) {
            this.descentText.ascent = ascent;
            return this;
        }

        public Builder descent(int descent) {
            this.descentText.ascent = 8 - descent;
            return this;
        }

        public Builder text(String text) {
            this.descentText.text = text;
            return this;
        }

        public Builder unicode(boolean unicode) {
            this.descentText.isUnicode = unicode;
            return this;
        }

        public DescentText build() {
            return this.descentText;
        }
    }
}

