/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.api.mechanic.placeholder;

import me.clip.placeholderapi.PlaceholderAPI;
import net.momirealms.customnameplates.api.mechanic.nameplate.Nameplate;
import net.momirealms.customnameplates.api.util.FontUtils;
import net.momirealms.customnameplates.common.team.TeamColor;
import org.bukkit.OfflinePlayer;

public class NameplateText {
    private String text;
    private Nameplate nameplate;

    private NameplateText() {
    }

    public NameplateText(String text, Nameplate nameplate) {
        this.text = text;
        this.nameplate = nameplate;
    }

    public String getText() {
        return this.text;
    }

    public Nameplate getNameplate() {
        return this.nameplate;
    }

    public String getValue(OfflinePlayer player) {
        String parsed = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)(switch (this.nameplate.getTeamColor()) {
            case TeamColor.CUSTOM -> this.nameplate.getNamePrefix() + this.text + this.nameplate.getNameSuffix();
            case TeamColor.NONE -> this.text;
            default -> "<" + this.nameplate.getTeamColor().name() + ">" + this.text + "</" + this.nameplate.getTeamColor().name() + ">";
        }));
        int parsedWidth = FontUtils.getTextWidth(parsed);
        return this.nameplate.getPrefixWithFont(parsedWidth) + parsed + this.nameplate.getSuffixWithFont(parsedWidth);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final NameplateText text = new NameplateText();

        public static Builder of() {
            return new Builder();
        }

        public Builder text(String value) {
            this.text.text = value;
            return this;
        }

        public Builder nameplate(Nameplate value) {
            this.text.nameplate = value;
            return this;
        }

        public NameplateText build() {
            return this.text;
        }
    }
}

