/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.api.mechanic.placeholder;

import me.clip.placeholderapi.PlaceholderAPI;
import net.momirealms.customnameplates.api.mechanic.font.OffsetFont;
import net.momirealms.customnameplates.api.util.FontUtils;
import org.bukkit.OfflinePlayer;

public class StaticText {
    private String text;
    private int value;
    private StaticState staticState;

    private StaticText() {
    }

    public StaticText(String text, int value, StaticState staticState) {
        this.text = text;
        this.value = value;
        this.staticState = staticState;
    }

    public String getText() {
        return this.text;
    }

    public int getValue() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public StaticState getStaticState() {
        return this.staticState;
    }

    public String getValue(OfflinePlayer player) {
        String parsed = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)this.text);
        int parsedWidth = FontUtils.getTextWidth(parsed);
        switch (this.staticState) {
            case LEFT: {
                return parsed + FontUtils.surroundNameplateFont(OffsetFont.getOffsetChars(this.value - parsedWidth));
            }
            case RIGHT: {
                return FontUtils.surroundNameplateFont(OffsetFont.getOffsetChars(this.value - parsedWidth)) + parsed;
            }
            case MIDDLE: {
                int half = (this.value - parsedWidth) / 2;
                String left = FontUtils.surroundNameplateFont(OffsetFont.getOffsetChars(half));
                String right = FontUtils.surroundNameplateFont(OffsetFont.getOffsetChars(this.value - parsedWidth - half));
                return left + parsed + right;
            }
        }
        return "";
    }

    public static enum StaticState {
        LEFT,
        MIDDLE,
        RIGHT;

    }

    public static class Builder {
        private final StaticText text = new StaticText();

        public static Builder of() {
            return new Builder();
        }

        public Builder value(int value) {
            this.text.value = value;
            return this;
        }

        public Builder text(String value) {
            this.text.text = value;
            return this;
        }

        public Builder state(StaticState state) {
            this.text.staticState = state;
            return this;
        }

        public StaticText build() {
            return this.text;
        }
    }
}

