/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.bossbar;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.InternalStructure;
import com.comphenix.protocol.events.PacketContainer;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import net.momirealms.customnameplates.paper.adventure.AdventureManagerImpl;
import net.momirealms.customnameplates.paper.mechanic.bossbar.BarColor;
import net.momirealms.customnameplates.paper.mechanic.bossbar.Overlay;
import net.momirealms.customnameplates.paper.mechanic.misc.PacketManager;
import net.momirealms.customnameplates.paper.util.ReflectionUtils;
import org.bukkit.entity.Player;

public class BossBar {
    private final Overlay overlay;
    private final BarColor barColor;
    private final UUID uuid;
    private final Player owner;
    private String latestMiniMessage;
    private boolean visible;

    public BossBar(Player owner, Overlay overlay, BarColor barColor) {
        this.owner = owner;
        this.overlay = overlay;
        this.barColor = barColor;
        this.uuid = UUID.randomUUID();
        this.visible = false;
    }

    public void show() {
        PacketManager.getInstance().send(this.owner, this.getCreatePacket());
        this.visible = true;
    }

    public void hide() {
        PacketManager.getInstance().send(this.owner, this.getRemovePacket());
        this.visible = false;
    }

    public void update() {
        PacketManager.getInstance().send(this.owner, this.getUpdatePacket());
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setMiniMessageText(String text) {
        this.latestMiniMessage = text;
    }

    private PacketContainer getCreatePacket() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.BOSS);
        packet.getModifier().write(0, (Object)this.uuid);
        InternalStructure internalStructure = (InternalStructure)packet.getStructures().read(1);
        internalStructure.getChatComponents().write(0, (Object)AdventureManagerImpl.getInstance().getWrappedChatComponentFromMiniMessage(this.latestMiniMessage));
        internalStructure.getFloat().write(0, (Object)Float.valueOf(1.0f));
        internalStructure.getEnumModifier(BarColor.class, 2).write(0, (Object)this.barColor);
        internalStructure.getEnumModifier(Overlay.class, 3).write(0, (Object)this.overlay);
        internalStructure.getModifier().write(4, (Object)false);
        internalStructure.getModifier().write(5, (Object)false);
        internalStructure.getModifier().write(6, (Object)false);
        return packet;
    }

    private PacketContainer getUpdatePacket() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.BOSS);
        packet.getModifier().write(0, (Object)this.uuid);
        try {
            Object chatComponent = AdventureManagerImpl.getInstance().getIChatComponentFromMiniMessage(this.latestMiniMessage);
            Object updatePacket = ReflectionUtils.getUpdateConstructor().newInstance(chatComponent);
            packet.getModifier().write(1, updatePacket);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    private PacketContainer getRemovePacket() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.BOSS);
        packet.getModifier().write(0, (Object)this.uuid);
        packet.getModifier().write(1, ReflectionUtils.getRemoveBossBarPacket());
        return packet;
    }
}

