/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.bossbar;

import net.momirealms.customnameplates.api.requirement.Requirement;
import net.momirealms.customnameplates.paper.mechanic.bossbar.BarColor;
import net.momirealms.customnameplates.paper.mechanic.bossbar.Overlay;
import net.momirealms.customnameplates.paper.mechanic.misc.TimeLimitText;

public class BossBarConfig {
    private Overlay overlay;
    private BarColor barColor;
    private int checkFrequency;
    private Requirement[] requirements;
    private TimeLimitText[] textDisplayOrder;

    private BossBarConfig() {
        this.overlay = Overlay.PROGRESS;
        this.barColor = BarColor.YELLOW;
        this.checkFrequency = 1;
        this.requirements = new Requirement[0];
        this.textDisplayOrder = new TimeLimitText[0];
    }

    public BossBarConfig(Overlay overlay, BarColor barColor, int checkFrequency, Requirement[] requirements, TimeLimitText[] textDisplayOrder) {
        this.overlay = overlay;
        this.barColor = barColor;
        this.checkFrequency = checkFrequency;
        this.requirements = requirements;
        this.textDisplayOrder = textDisplayOrder;
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    public BarColor getBarColor() {
        return this.barColor;
    }

    public int getCheckFrequency() {
        return this.checkFrequency;
    }

    public Requirement[] getRequirements() {
        return this.requirements;
    }

    public TimeLimitText[] getTextDisplayOrder() {
        return this.textDisplayOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final BossBarConfig config = new BossBarConfig();

        public static Builder of() {
            return new Builder();
        }

        public Builder overlay(Overlay overlay) {
            this.config.overlay = overlay;
            return this;
        }

        public Builder barColor(BarColor barColor) {
            this.config.barColor = barColor;
            return this;
        }

        public Builder checkFrequency(int checkFrequency) {
            this.config.checkFrequency = checkFrequency;
            return this;
        }

        public Builder requirement(Requirement[] requirements) {
            this.config.requirements = requirements;
            return this;
        }

        public Builder displayOrder(TimeLimitText[] textDisplayOrder) {
            this.config.textDisplayOrder = textDisplayOrder;
            return this;
        }

        public BossBarConfig build() {
            return this.config;
        }
    }
}

