/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.bossbar;

import java.util.concurrent.TimeUnit;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.requirement.Condition;
import net.momirealms.customnameplates.api.scheduler.CancellableTask;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.common.Pair;
import net.momirealms.customnameplates.paper.mechanic.bossbar.BossBar;
import net.momirealms.customnameplates.paper.mechanic.misc.DisplayController;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class BossBarReceiver {
    private final CustomNameplatesPlugin plugin;
    private final Player player;
    private final int bossBarSize;
    private final Pair<DisplayController, BossBar>[] bossBars;
    private CancellableTask bossBarTask;

    public BossBarReceiver(CustomNameplatesPlugin plugin, Player player, Pair<DisplayController, BossBar>[] bossBars) {
        this.player = player;
        this.plugin = plugin;
        this.bossBars = bossBars;
        this.bossBarSize = bossBars.length;
    }

    public void arrangeTask() {
        if (this.bossBarTask != null && !this.bossBarTask.isCancelled()) {
            LogUtils.warn("There's already a BossBar task running");
            return;
        }
        this.bossBarTask = this.plugin.getScheduler().runTaskAsyncTimer(() -> {
            try {
                this.timer();
            }
            catch (Exception e) {
                LogUtils.severe("Error occurred when sending BossBars. This might not be a bug in CustomNameplates. Please report to the Plugin on the top of the following stack trace.");
                e.printStackTrace();
            }
        }, 50L, 50L, TimeUnit.MILLISECONDS);
    }

    public void cancelTask() {
        if (this.bossBarTask == null) {
            LogUtils.warn("BossBar task has been already cancelled");
            return;
        }
        this.bossBarTask.cancel();
        this.bossBarTask = null;
    }

    public void destroy() {
        for (Pair<DisplayController, BossBar> pair : this.bossBars) {
            pair.right().hide();
        }
    }

    public void timer() {
        Condition condition = new Condition((OfflinePlayer)this.player);
        block4: for (int i = 0; i < this.bossBarSize; ++i) {
            Pair<DisplayController, BossBar> pair = this.bossBars[i];
            switch (pair.left().stateCheck(condition)) {
                case KEEP: {
                    if (!pair.left().isShown() || !pair.left().updateText(condition)) continue block4;
                    pair.right().setMiniMessageText(pair.left().getLatestContent());
                    pair.right().update();
                    continue block4;
                }
                case UPDATE: {
                    DisplayController controller = pair.left();
                    if (controller.isShown()) {
                        int j;
                        for (j = i + 1; j < this.bossBarSize; ++j) {
                            if (!this.bossBars[j].left().isShown()) continue;
                            this.bossBars[j].right().hide();
                        }
                        controller.initialize(condition);
                        pair.right().setMiniMessageText(pair.left().getLatestContent());
                        pair.right().show();
                        for (j = i + 1; j < this.bossBarSize; ++j) {
                            if (!this.bossBars[j].left().isShown()) continue;
                            this.bossBars[j].right().show();
                        }
                        continue block4;
                    }
                    pair.right().hide();
                }
            }
        }
    }
}

