/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.bubble.provider;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import net.draycia.carbon.api.CarbonChat;
import net.draycia.carbon.api.channels.ChannelRegistry;
import net.draycia.carbon.api.channels.ChatChannel;
import net.draycia.carbon.api.event.CarbonEventSubscription;
import net.draycia.carbon.api.event.events.CarbonChatEvent;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.manager.BubbleManager;
import net.momirealms.customnameplates.api.mechanic.bubble.provider.AbstractChatProvider;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.paper.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class CarbonChatProvider
extends AbstractChatProvider {
    private final CarbonChat api = net.draycia.carbon.api.CarbonChatProvider.carbonChat();
    private CarbonEventSubscription<CarbonChatEvent> subscription;
    private Method originalMessageMethod;
    private Method channelKeyMethod;
    private Method getChannelByKeyMethod;

    public CarbonChatProvider(BubbleManager chatBubblesManager) {
        super(chatBubblesManager);
        try {
            this.originalMessageMethod = CarbonChatEvent.class.getMethod("originalMessage", new Class[0]);
            this.channelKeyMethod = ChatChannel.class.getMethod("key", new Class[0]);
            this.getChannelByKeyMethod = ChannelRegistry.class.getMethod("channel", ReflectionUtils.getKeyClass());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void register() {
        this.subscription = this.api.eventHandler().subscribe(CarbonChatEvent.class, event -> {
            if (event.cancelled()) {
                return;
            }
            ChatChannel chatChannel = event.chatChannel();
            Object key = this.getChannelKey(chatChannel);
            if (key == null) {
                return;
            }
            String channel = ReflectionUtils.getKeyAsString(key);
            for (String black : this.chatBubblesManager.getBlacklistChannels()) {
                if (!channel.equals(black)) continue;
                return;
            }
            Player player = Bukkit.getPlayer((UUID)event.sender().uuid());
            if (player == null || !player.isOnline()) {
                return;
            }
            Object component = this.getComponentFromEvent((CarbonChatEvent)event);
            String message = ReflectionUtils.getMiniMessageTextFromNonShadedComponent(component);
            CustomNameplatesPlugin.get().getScheduler().runTaskAsync(() -> this.chatBubblesManager.onChat(player, message, channel));
        });
    }

    @Override
    public void unregister() {
        if (this.subscription != null) {
            this.subscription.dispose();
        }
    }

    @Override
    public boolean hasJoinedChannel(Player player, String channelID) {
        CarbonPlayer cPlayer = null;
        for (CarbonPlayer carbonPlayer : this.api.server().players()) {
            if (!carbonPlayer.uuid().equals(player.getUniqueId())) continue;
            cPlayer = carbonPlayer;
            break;
        }
        if (cPlayer == null) {
            return false;
        }
        ChatChannel selectedChannel = cPlayer.selectedChannel();
        if (selectedChannel == null) {
            return false;
        }
        Object key = this.getChannelKey(selectedChannel);
        String str = ReflectionUtils.getKeyAsString(key);
        return str.equals(channelID);
    }

    @Override
    public boolean canJoinChannel(Player player, String channelID) {
        ChannelRegistry registry = this.api.channelRegistry();
        Object key = ReflectionUtils.getKerFromString(channelID);
        if (key == null) {
            return false;
        }
        ChatChannel channel = null;
        try {
            channel = (ChatChannel)this.getChannelByKeyMethod.invoke((Object)registry, key);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        if (channel == null) {
            LogUtils.warn("Channel " + channelID + " doesn't exist.");
            return false;
        }
        String perm = channel.permission();
        if (perm == null) {
            return true;
        }
        return player.hasPermission(perm);
    }

    private Object getChannelKey(ChatChannel channel) {
        try {
            return this.channelKeyMethod.invoke((Object)channel, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object getComponentFromEvent(CarbonChatEvent event) {
        try {
            return this.originalMessageMethod.invoke((Object)event, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return ReflectionUtils.getEmptyComponent();
        }
    }
}

