/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.bubble.provider;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.manager.BubbleManager;
import net.momirealms.customnameplates.api.mechanic.bubble.provider.AbstractChatProvider;
import net.momirealms.customnameplates.paper.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class PaperAsyncChatProvider
extends AbstractChatProvider {
    private Method messageMethod;

    public PaperAsyncChatProvider(BubbleManager chatBubblesManager) {
        super(chatBubblesManager);
        try {
            this.messageMethod = AsyncChatEvent.class.getMethod("message", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)CustomNameplatesPlugin.get());
    }

    @Override
    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public boolean hasJoinedChannel(Player player, String channelID) {
        return true;
    }

    @Override
    public boolean canJoinChannel(Player player, String channelID) {
        return true;
    }

    @EventHandler(ignoreCancelled=true)
    public void onChat(AsyncChatEvent event) {
        Object component = this.getComponentFromEvent(event);
        String message = ReflectionUtils.getMiniMessageTextFromNonShadedComponent(component);
        CustomNameplatesPlugin.get().getScheduler().runTaskAsync(() -> this.chatBubblesManager.onChat(event.getPlayer(), message));
    }

    private Object getComponentFromEvent(AsyncChatEvent event) {
        try {
            return this.messageMethod.invoke((Object)event, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return ReflectionUtils.getEmptyComponent();
        }
    }
}

