/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.bubble.provider;

import mineverse.Aust1n46.chat.api.MineverseChatAPI;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import mineverse.Aust1n46.chat.api.events.VentureChatEvent;
import mineverse.Aust1n46.chat.channel.ChatChannel;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.manager.BubbleManager;
import net.momirealms.customnameplates.api.mechanic.bubble.provider.AbstractChatProvider;
import net.momirealms.customnameplates.api.util.LogUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class VentureChatProvider
extends AbstractChatProvider {
    public VentureChatProvider(BubbleManager chatBubblesManager) {
        super(chatBubblesManager);
    }

    @Override
    public void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)CustomNameplatesPlugin.get());
    }

    @Override
    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public boolean hasJoinedChannel(Player player, String channelID) {
        MineverseChatPlayer mcp = MineverseChatAPI.getOnlineMineverseChatPlayer((Player)player);
        return mcp.getCurrentChannel().getName().equals(channelID);
    }

    @Override
    public boolean canJoinChannel(Player player, String channelID) {
        ChatChannel channel = ChatChannel.getChannel((String)channelID);
        if (channel == null) {
            LogUtils.warn("Channel " + channelID + " doesn't exist.");
            return false;
        }
        if (channel.hasPermission().booleanValue()) {
            return player.hasPermission(channel.getPermission());
        }
        return true;
    }

    @EventHandler(ignoreCancelled=true)
    public void onVentureChat(VentureChatEvent event) {
        String channelName = event.getChannel().getName();
        for (String channel : this.chatBubblesManager.getBlacklistChannels()) {
            if (!channelName.equals(channel)) continue;
            return;
        }
        MineverseChatPlayer chatPlayer = event.getMineverseChatPlayer();
        if (chatPlayer == null) {
            return;
        }
        CustomNameplatesPlugin.get().getScheduler().runTaskAsync(() -> this.chatBubblesManager.onChat(chatPlayer.getPlayer(), event.getChat(), channelName));
    }
}

