/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.misc;

import me.clip.placeholderapi.PlaceholderAPI;
import net.momirealms.customnameplates.api.manager.RequirementManager;
import net.momirealms.customnameplates.api.requirement.Condition;
import net.momirealms.customnameplates.api.requirement.Requirement;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.paper.mechanic.misc.TimeLimitText;
import org.bukkit.entity.Player;

public class DisplayController {
    private final Player owner;
    private final int checkFrequency;
    private final Requirement[] requirements;
    private boolean isShown;
    private int checkTimer;
    private int refreshTimer;
    private String latestValue;
    private int timeLeft;
    private int index;
    private final TimeLimitText[] texts;
    private boolean metAnyCondition;

    public DisplayController(Player player, int checkFrequency, Requirement[] requirements, TimeLimitText[] texts) {
        this.owner = player;
        this.checkFrequency = checkFrequency;
        this.refreshTimer = 0;
        this.requirements = requirements;
        this.texts = texts;
        this.checkTimer = checkFrequency - 1;
    }

    public NextStage stateCheck(Condition condition) {
        ++this.checkTimer;
        if (this.checkTimer % this.checkFrequency != 0) {
            return NextStage.KEEP;
        }
        boolean canShow = RequirementManager.isRequirementMet(condition, this.requirements);
        if (canShow) {
            if (this.isShown) {
                return NextStage.KEEP;
            }
            this.isShown = true;
            return NextStage.UPDATE;
        }
        if (!this.isShown) {
            return NextStage.KEEP;
        }
        this.isShown = false;
        return NextStage.UPDATE;
    }

    public boolean isShown() {
        return this.isShown;
    }

    public boolean updateText(Condition condition) {
        if (this.timeLeft > 0) {
            --this.timeLeft;
        }
        if (this.timeLeft == 0) {
            int triedTimes = 0;
            do {
                ++this.index;
                if (this.index >= this.texts.length) {
                    this.index = 0;
                }
                if (triedTimes == this.texts.length) {
                    this.timeLeft = Math.max(this.checkFrequency, 1);
                    this.metAnyCondition = false;
                    LogUtils.warn("No text is available for player " + this.owner.getName() + ". Please check your conditions.");
                    return this.updateText("");
                }
                ++triedTimes;
            } while (!RequirementManager.isRequirementMet(condition, this.texts[this.index].getRequirements()));
            this.metAnyCondition = true;
            this.timeLeft = this.texts[this.index].getDuration();
            this.refreshTimer = 0;
            return this.updateText(this.texts[this.index].getText());
        }
        if (!this.metAnyCondition || this.texts[this.index].getRefreshFrequency() <= 0) {
            return false;
        }
        ++this.refreshTimer;
        if (this.refreshTimer >= this.texts[this.index].getRefreshFrequency()) {
            this.refreshTimer = 0;
            return this.updateText(this.texts[this.index].getText());
        }
        return false;
    }

    private boolean updateText(String text) {
        String newText = PlaceholderAPI.setPlaceholders((Player)this.owner, (String)text);
        if (newText.equals(this.latestValue)) {
            return false;
        }
        this.latestValue = newText;
        return true;
    }

    public void initialize(Condition condition) {
        this.index = this.texts.length - 1;
        this.checkTimer = 0;
        this.refreshTimer = 0;
        this.timeLeft = 1;
        this.updateText(condition);
    }

    public String getLatestContent() {
        return this.latestValue;
    }

    public static enum NextStage {
        KEEP,
        UPDATE;

    }
}

