/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.misc;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CompletableFuture;
import me.clip.placeholderapi.PlaceholderAPI;
import net.momirealms.customnameplates.api.manager.VersionManager;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.paper.CustomNameplatesPluginImpl;
import net.momirealms.customnameplates.paper.adventure.AdventureManagerImpl;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.jetbrains.annotations.NotNull;

public class VersionManagerImpl
implements VersionManager,
Listener {
    private final boolean isNewerThan1_19;
    private final boolean isNewerThan1_19_R2;
    private final boolean isNewerThan1_19_R3;
    private final boolean isNewerThan1_20;
    private final boolean isNewerThan1_20_R2;
    private final String serverVersion;
    private final CustomNameplatesPluginImpl plugin;
    private boolean isFolia;
    private final String pluginVersion;
    private boolean isLatest = true;

    public VersionManagerImpl(CustomNameplatesPluginImpl plugin) {
        this.plugin = plugin;
        this.serverVersion = plugin.getServer().getClass().getPackage().getName().split("\\.")[3];
        String[] split = this.serverVersion.split("_");
        int main_ver = Integer.parseInt(split[1]);
        if (main_ver >= 20) {
            this.isNewerThan1_20_R2 = Integer.parseInt(split[2].substring(1)) >= 2;
            this.isNewerThan1_19_R3 = true;
            this.isNewerThan1_19_R2 = true;
            this.isNewerThan1_20 = true;
            this.isNewerThan1_19 = true;
        } else if (main_ver == 19) {
            this.isNewerThan1_19_R2 = Integer.parseInt(split[2].substring(1)) >= 2;
            this.isNewerThan1_19_R3 = Integer.parseInt(split[2].substring(1)) >= 3;
            this.isNewerThan1_20_R2 = false;
            this.isNewerThan1_20 = false;
            this.isNewerThan1_19 = true;
        } else {
            this.isNewerThan1_19_R3 = false;
            this.isNewerThan1_19_R2 = false;
            this.isNewerThan1_19 = false;
            this.isNewerThan1_20_R2 = false;
            this.isNewerThan1_20 = false;
        }
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.AsyncScheduler");
            this.isFolia = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.pluginVersion = plugin.getDescription().getVersion();
    }

    @Override
    public boolean isVersionNewerThan1_19_R2() {
        return this.isNewerThan1_19_R2;
    }

    @Override
    public boolean isVersionNewerThan1_20() {
        return this.isNewerThan1_20;
    }

    @Override
    public boolean isVersionNewerThan1_20_R2() {
        return this.isNewerThan1_20_R2;
    }

    @Override
    @NotNull
    public String getPluginVersion() {
        return this.pluginVersion;
    }

    @Override
    public boolean isLatest() {
        return this.isLatest;
    }

    @Override
    public boolean isVersionNewerThan1_19() {
        return this.isNewerThan1_19;
    }

    @Override
    public boolean isVersionNewerThan1_19_R3() {
        return this.isNewerThan1_19_R3;
    }

    @Override
    public int getPackFormat() {
        switch (this.serverVersion) {
            case "v1_20_R3": {
                return 22;
            }
            case "v1_20_R2": {
                return 18;
            }
            case "v1_20_R1": {
                return 15;
            }
            case "v1_19_R3": {
                return 13;
            }
            case "v1_19_R2": {
                return 12;
            }
            case "v1_19_R1": {
                return 9;
            }
            case "v1_18_R1": 
            case "v1_18_R2": {
                return 8;
            }
        }
        return 7;
    }

    @Override
    public boolean isFolia() {
        return this.isFolia;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    public CompletableFuture<Boolean> checkUpdate() {
        CompletableFuture<Boolean> updateFuture = new CompletableFuture<Boolean>();
        this.plugin.getScheduler().runTaskAsync(() -> {
            try {
                URL url = new URL("https://api.polymart.org/v1/getResourceInfoSimple/?resource_id=2543&key=version");
                URLConnection conn = url.openConnection();
                conn.setConnectTimeout(3000);
                conn.setReadTimeout(3000);
                InputStream inputStream = conn.getInputStream();
                String newest = new BufferedReader(new InputStreamReader(inputStream)).readLine();
                String current = this.getPluginVersion();
                inputStream.close();
                if (!this.compareVer(newest, current)) {
                    updateFuture.complete(false);
                    return;
                }
                this.isLatest = false;
                updateFuture.complete(true);
            }
            catch (Exception exception) {
                LogUtils.warn("Error occurred when checking update.");
                updateFuture.completeExceptionally(exception);
            }
        });
        return updateFuture;
    }

    private boolean compareVer(String newV, String currentV) {
        if (newV == null || currentV == null || newV.isEmpty() || currentV.isEmpty()) {
            return false;
        }
        String[] newVS = newV.split("\\.");
        String[] currentVS = currentV.split("\\.");
        int maxL = Math.min(newVS.length, currentVS.length);
        for (int i = 0; i < maxL; ++i) {
            try {
                String[] newPart = newVS[i].split("-");
                String[] currentPart = currentVS[i].split("-");
                int newNum = Integer.parseInt(newPart[0]);
                int currentNum = Integer.parseInt(currentPart[0]);
                if (newNum > currentNum) {
                    return true;
                }
                if (newNum < currentNum) {
                    return false;
                }
                if (newPart.length > 1 && currentPart.length > 1) {
                    int currentHotfixNum;
                    String[] newHotfix = newPart[1].split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
                    String[] currentHotfix = currentPart[1].split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
                    if (newHotfix.length == 2 && currentHotfix.length == 1) {
                        return true;
                    }
                    if (newHotfix.length <= 1 || currentHotfix.length <= 1) continue;
                    int newHotfixNum = Integer.parseInt(newHotfix[1]);
                    if (newHotfixNum > (currentHotfixNum = Integer.parseInt(currentHotfix[1]))) {
                        return true;
                    }
                    if (newHotfixNum < currentHotfixNum) {
                        return false;
                    }
                    return newHotfix[0].compareTo(currentHotfix[0]) > 0;
                }
                if (newPart.length > 1) {
                    return true;
                }
                if (currentPart.length <= 1) continue;
                return false;
            }
            catch (NumberFormatException ignored) {
                return false;
            }
        }
        return newVS.length > currentVS.length;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.isOp() && !PlaceholderAPI.isRegistered((String)"player")) {
            AdventureManagerImpl.getInstance().sendMessageWithPrefix((CommandSender)player, "You haven't installed Player Expansion yet. Click <b><gold><click:run_command:/papi ecloud download Player>HERE</click></gold><b> to download.");
        }
    }
}

