/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.nameplate.tag.team;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.scheduler.CancellableTask;
import net.momirealms.customnameplates.common.team.TeamColor;
import net.momirealms.customnameplates.paper.mechanic.misc.PacketManager;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.team.TeamPlayer;
import net.momirealms.customnameplates.paper.util.FakeEntityUtils;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;

public class TeamPreviewSimpleEntity {
    private final TeamPlayer teamPlayer;
    private final UUID uuid = UUID.randomUUID();
    private final int entityId;
    private CancellableTask tpTask;

    public TeamPreviewSimpleEntity(TeamPlayer teamPlayer) {
        this.teamPlayer = teamPlayer;
        this.entityId = FakeEntityUtils.getAndIncrease();
    }

    private String getTagString() {
        TeamColor teamColor = CustomNameplatesPlugin.get().getNameplateManager().getTeamColor(this.teamPlayer.getPlayer());
        if (teamColor == TeamColor.NONE || teamColor == TeamColor.CUSTOM) {
            teamColor = TeamColor.WHITE;
        }
        return this.teamPlayer.getPrefix().getLatestValue(this.teamPlayer.getPlayer()) + "<" + teamColor.name() + ">" + this.teamPlayer.getPlayer().getName() + "</" + teamColor.name() + ">" + this.teamPlayer.getSuffix().getLatestValue(this.teamPlayer.getPlayer());
    }

    public void spawn() {
        this.teamPlayer.getSuffix().updateForViewer(this.teamPlayer.getPlayer());
        this.teamPlayer.getPrefix().updateForViewer(this.teamPlayer.getPlayer());
        PacketManager.getInstance().send(this.teamPlayer.getPlayer(), this.getSpawnPackets(this.getTagString()));
        this.tpTask = CustomNameplatesPlugin.get().getScheduler().runTaskAsyncTimer(() -> PacketManager.getInstance().send(this.teamPlayer.getPlayer(), this.getTeleportPacket()), 50L, 50L, TimeUnit.MILLISECONDS);
    }

    public void destroy() {
        if (this.tpTask != null && !this.tpTask.isCancelled()) {
            this.tpTask.cancel();
        }
        PacketContainer destroyPacket = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        destroyPacket.getIntLists().write(0, List.of(Integer.valueOf(this.entityId)));
        PacketManager.getInstance().send(this.teamPlayer.getPlayer(), destroyPacket);
        this.teamPlayer.getSuffix().removeViewer(this.teamPlayer.getPlayer());
        this.teamPlayer.getPrefix().removeViewer(this.teamPlayer.getPlayer());
    }

    public void update() {
        if (this.teamPlayer.getPrefix().updateForViewer(this.teamPlayer.getPlayer()) | this.teamPlayer.getSuffix().updateForViewer(this.teamPlayer.getPlayer())) {
            PacketManager.getInstance().send(this.teamPlayer.getPlayer(), FakeEntityUtils.getMetaPacket(this.entityId, this.getTagString(), false));
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public PacketContainer getTeleportPacket() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
        packet.getIntegers().write(0, (Object)this.entityId);
        Location location = this.teamPlayer.getPlayer().getLocation();
        packet.getDoubles().write(0, (Object)location.getX());
        packet.getDoubles().write(1, (Object)(location.getY() + 0.8));
        packet.getDoubles().write(2, (Object)location.getZ());
        return packet;
    }

    private PacketContainer[] getSpawnPackets(String text) {
        PacketContainer entityPacket = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY);
        entityPacket.getModifier().write(0, (Object)this.entityId);
        entityPacket.getModifier().write(1, (Object)this.uuid);
        entityPacket.getEntityTypeModifier().write(0, (Object)EntityType.ARMOR_STAND);
        Location location = this.teamPlayer.getPlayer().getLocation();
        entityPacket.getDoubles().write(0, (Object)location.getX());
        entityPacket.getDoubles().write(1, (Object)(location.getY() + 0.8));
        entityPacket.getDoubles().write(2, (Object)location.getZ());
        PacketContainer metaPacket = FakeEntityUtils.getMetaPacket(this.entityId, text, false);
        return new PacketContainer[]{entityPacket, metaPacket};
    }
}

