/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.manager.NameplateManager;
import net.momirealms.customnameplates.api.manager.UnlimitedTagManager;
import net.momirealms.customnameplates.api.mechanic.misc.ViewerText;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.DynamicTextEntity;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.DynamicTextTagSetting;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.EntityTagEntity;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.EntityTagPlayer;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.StaticTextEntity;
import net.momirealms.customnameplates.api.mechanic.tag.unlimited.StaticTextTagSetting;
import net.momirealms.customnameplates.api.scheduler.CancellableTask;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.listener.MagicCosmeticsListener;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited.DynamicTextEntityImpl;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited.StaticTextEntityImpl;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited.UnlimitedEntity;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited.UnlimitedPlayer;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited.VehicleChecker;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnlimitedTagManagerImpl
implements UnlimitedTagManager {
    private final NameplateManager manager;
    private final ConcurrentHashMap<UUID, UnlimitedEntity> unlimitedEntityMap;
    private CancellableTask refreshTask;
    private MagicCosmeticsListener magicCosmeticsListener;
    private final VehicleChecker vehicleChecker;

    public UnlimitedTagManagerImpl(NameplateManager nameplateManager) {
        this.manager = nameplateManager;
        this.unlimitedEntityMap = new ConcurrentHashMap();
        this.vehicleChecker = new VehicleChecker(this);
        if (Bukkit.getPluginManager().getPlugin("MagicCosmetics") != null) {
            this.magicCosmeticsListener = new MagicCosmeticsListener(this);
        }
    }

    public void load() {
        this.vehicleChecker.load();
        this.refreshTask = CustomNameplatesPlugin.get().getScheduler().runTaskAsyncTimer(() -> {
            try {
                for (UnlimitedEntity unlimitedEntity : this.unlimitedEntityMap.values()) {
                    if (!(unlimitedEntity instanceof UnlimitedPlayer)) continue;
                    UnlimitedPlayer unlimitedPlayer = (UnlimitedPlayer)unlimitedEntity;
                    unlimitedPlayer.timer();
                }
            }
            catch (Exception e) {
                LogUtils.severe("Error occurred when updating unlimited tags. This might not be a bug in CustomNameplates. Please report to the Plugin on the top of the following stack trace.");
                e.printStackTrace();
            }
        }, 50L, 50L, TimeUnit.MILLISECONDS);
        if (this.magicCosmeticsListener != null) {
            Bukkit.getPluginManager().registerEvents((Listener)this.magicCosmeticsListener, (Plugin)CustomNameplatesPlugin.get());
        }
    }

    public void unload() {
        this.vehicleChecker.unload();
        if (this.refreshTask != null && !this.refreshTask.isCancelled()) {
            this.refreshTask.cancel();
        }
        for (UnlimitedEntity entry : this.unlimitedEntityMap.values()) {
            entry.destroy();
        }
        if (this.magicCosmeticsListener != null) {
            HandlerList.unregisterAll((Listener)this.magicCosmeticsListener);
        }
    }

    @Override
    @NotNull
    public StaticTextEntity createNamedEntity(EntityTagEntity entity, StaticTextTagSetting setting) {
        return new StaticTextEntityImpl((UnlimitedEntity)entity, setting.getVerticalOffset(), setting.getComeRule(), setting.getLeaveRule(), setting.getDefaultText(), setting.getPlugin());
    }

    @Override
    @NotNull
    public DynamicTextEntity createNamedEntity(EntityTagPlayer player, DynamicTextTagSetting setting) {
        return new DynamicTextEntityImpl((UnlimitedPlayer)player, new ViewerText(player.getPlayer(), setting.getRawText()), setting.getRefreshFrequency(), setting.getCheckFrequency(), setting.getVerticalOffset(), setting.getOwnerRequirements(), setting.getViewerRequirements());
    }

    @Override
    public UnlimitedEntity createOrGetTagForEntity(Entity entity) {
        UUID uuid = entity.getUniqueId();
        if (this.unlimitedEntityMap.containsKey(uuid)) {
            return this.unlimitedEntityMap.get(uuid);
        }
        UnlimitedEntity unlimitedEntity = new UnlimitedEntity(this, entity);
        this.unlimitedEntityMap.put(uuid, unlimitedEntity);
        unlimitedEntity.addNearByPlayerToMap(48);
        return unlimitedEntity;
    }

    @Override
    public UnlimitedPlayer createOrGetTagForPlayer(Player player) {
        if (!player.isOnline()) {
            return null;
        }
        UUID uuid = player.getUniqueId();
        if (this.unlimitedEntityMap.containsKey(uuid)) {
            return (UnlimitedPlayer)this.unlimitedEntityMap.get(uuid);
        }
        UnlimitedPlayer unlimitedPlayer = new UnlimitedPlayer(this, player);
        this.unlimitedEntityMap.put(uuid, unlimitedPlayer);
        unlimitedPlayer.addNearByPlayerToMap(48);
        return unlimitedPlayer;
    }

    public UnlimitedEntity removeUnlimitedEntityFromMap(UUID uuid) {
        return this.unlimitedEntityMap.remove(uuid);
    }

    @Nullable
    public UnlimitedEntity getUnlimitedObject(UUID uuid) {
        return this.unlimitedEntityMap.get(uuid);
    }

    public void handleEntitySpawnPacket(Player receiver, int entityId) {
        Player spawned = this.manager.getPlayerByEntityID(entityId);
        if (spawned == null) {
            return;
        }
        UnlimitedEntity unlimitedEntity = this.getUnlimitedObject(spawned.getUniqueId());
        if (unlimitedEntity == null) {
            return;
        }
        unlimitedEntity.addNearbyPlayerNaturally(receiver);
    }

    public void handlePlayerPose(Player player, Pose pose) {
        UnlimitedEntity unlimitedEntity = this.getUnlimitedObject(player.getUniqueId());
        if (unlimitedEntity != null) {
            unlimitedEntity.handlePose(player.getPose(), pose);
        }
    }

    public void handlePlayerQuit(Player quit) {
        UnlimitedEntity unlimitedEntity = this.getUnlimitedObject(quit.getUniqueId());
        if (unlimitedEntity != null) {
            unlimitedEntity.destroy();
        }
        for (UnlimitedEntity entry : this.unlimitedEntityMap.values()) {
            entry.removeNearbyPlayerNaturally(quit);
        }
    }

    public void handleEntityMovePacket(Player receiver, int entityID, short x, short y, short z, boolean onGround) {
        Entity mover = this.manager.getEntityByEntityID(entityID);
        if (mover == null) {
            return;
        }
        UnlimitedEntity unlimitedEntity = this.getUnlimitedObject(mover.getUniqueId());
        if (unlimitedEntity == null) {
            return;
        }
        unlimitedEntity.move(receiver, x, y, z, onGround);
    }

    public void handleEntityTeleportPacket(Player receiver, int entityID, double x, double y, double z, boolean onGround) {
        Entity tp = this.manager.getEntityByEntityID(entityID);
        if (tp == null) {
            return;
        }
        UnlimitedEntity unlimitedEntity = this.getUnlimitedObject(tp.getUniqueId());
        if (unlimitedEntity == null) {
            return;
        }
        unlimitedEntity.teleport(receiver, x, y, z, onGround);
    }

    public void handleEntityDestroyPacket(Player receiver, List<Integer> list) {
        for (int id : list) {
            this.handleSingleEntityDestroy(receiver, id);
        }
    }

    private void handleSingleEntityDestroy(Player receiver, int entityID) {
        Entity deSpawned = this.manager.getEntityByEntityID(entityID);
        if (deSpawned == null) {
            return;
        }
        UnlimitedEntity unlimitedEntity = this.getUnlimitedObject(deSpawned.getUniqueId());
        if (unlimitedEntity == null) {
            return;
        }
        unlimitedEntity.removeNearbyPlayerNaturally(receiver);
    }

    public void handlePlayerSneak(Player sneaker, boolean sneaking, boolean flying) {
        UnlimitedEntity unlimitedEntity = this.getUnlimitedObject(sneaker.getUniqueId());
        if (!(unlimitedEntity instanceof UnlimitedPlayer)) {
            return;
        }
        UnlimitedPlayer unlimitedPlayer = (UnlimitedPlayer)unlimitedEntity;
        unlimitedPlayer.sneak(sneaking, flying);
    }
}

