/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.scheduler.CancellableTask;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited.UnlimitedEntity;
import net.momirealms.customnameplates.paper.mechanic.nameplate.tag.unlimited.UnlimitedTagManagerImpl;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.spigotmc.event.entity.EntityDismountEvent;
import org.spigotmc.event.entity.EntityMountEvent;

public class VehicleChecker
implements Listener {
    private final Set<UUID> entitiesOnVehicle;
    private final UnlimitedTagManagerImpl unlimitedTagManager;
    private CancellableTask updatePosTask;

    public VehicleChecker(UnlimitedTagManagerImpl unlimitedTagManager) {
        this.unlimitedTagManager = unlimitedTagManager;
        this.entitiesOnVehicle = Collections.synchronizedSet(new HashSet());
    }

    public void load() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)CustomNameplatesPlugin.get());
        for (Player all : Bukkit.getOnlinePlayers()) {
            Entity vehicle = all.getVehicle();
            if (vehicle == null) continue;
            this.entitiesOnVehicle.add(all.getUniqueId());
        }
        this.updatePosTask = CustomNameplatesPlugin.getInstance().getScheduler().runTaskAsyncTimer(() -> {
            for (UUID inVehicle : this.entitiesOnVehicle) {
                UnlimitedEntity unlimitedEntity = this.unlimitedTagManager.getUnlimitedObject(inVehicle);
                if (unlimitedEntity == null) continue;
                unlimitedEntity.teleport();
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
    }

    public void unload() {
        HandlerList.unregisterAll((Listener)this);
        if (this.updatePosTask != null && !this.updatePosTask.isCancelled()) {
            this.updatePosTask.cancel();
        }
        this.entitiesOnVehicle.clear();
    }

    @EventHandler(ignoreCancelled=true)
    public void onMount(EntityMountEvent event) {
        Entity passenger = event.getEntity();
        UUID uuid = passenger.getUniqueId();
        UnlimitedEntity unlimitedEntity = this.unlimitedTagManager.getUnlimitedObject(uuid);
        if (unlimitedEntity != null) {
            unlimitedEntity.teleport();
            this.entitiesOnVehicle.add(uuid);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDeath(EntityDeathEvent event) {
        UUID uuid = event.getEntity().getUniqueId();
        this.entitiesOnVehicle.remove(uuid);
    }

    @EventHandler(ignoreCancelled=true)
    public void onDismount(EntityDismountEvent event) {
        Entity passenger = event.getEntity();
        UUID uuid = passenger.getUniqueId();
        UnlimitedEntity unlimitedEntity = this.unlimitedTagManager.getUnlimitedObject(uuid);
        if (unlimitedEntity != null) {
            unlimitedEntity.respawn();
            this.entitiesOnVehicle.remove(uuid);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Entity vehicle = player.getVehicle();
        if (vehicle != null) {
            this.entitiesOnVehicle.add(player.getUniqueId());
        }
    }

    @EventHandler
    public void onQuit(PlayerJoinEvent event) {
        this.entitiesOnVehicle.remove(event.getPlayer().getUniqueId());
    }
}

