/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.pack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.manager.ResourcePackManager;
import net.momirealms.customnameplates.api.mechanic.background.BackGround;
import net.momirealms.customnameplates.api.mechanic.bubble.Bubble;
import net.momirealms.customnameplates.api.mechanic.character.ConfiguredChar;
import net.momirealms.customnameplates.api.mechanic.font.OffsetFont;
import net.momirealms.customnameplates.api.mechanic.nameplate.Nameplate;
import net.momirealms.customnameplates.api.mechanic.placeholder.DescentText;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.paper.mechanic.bossbar.BarColor;
import net.momirealms.customnameplates.paper.setting.CNConfig;
import net.momirealms.customnameplates.paper.util.ConfigUtils;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ResourcePackManagerImpl
implements ResourcePackManager {
    private final CustomNameplatesPlugin plugin;

    public ResourcePackManagerImpl(CustomNameplatesPlugin plugin) {
        this.plugin = plugin;
    }

    public void reload() {
        this.unload();
        this.load();
    }

    public void load() {
    }

    public void unload() {
    }

    @Override
    public void generateResourcePack() {
        File resourcePackFolder = new File(this.plugin.getDataFolder() + File.separator + "ResourcePack");
        this.deleteDirectory(resourcePackFolder);
        File fontFolder = new File(this.plugin.getDataFolder(), "ResourcePack" + File.separator + "assets" + File.separator + CNConfig.namespace + File.separatorChar + "font");
        File texturesFolder = new File(this.plugin.getDataFolder(), "ResourcePack" + File.separator + "assets" + File.separator + CNConfig.namespace + File.separatorChar + "textures");
        if (!fontFolder.mkdirs() || !texturesFolder.mkdirs()) {
            LogUtils.severe("Failed to generate resource pack folders");
            return;
        }
        JsonObject fontJson = new JsonObject();
        JsonArray providers = new JsonArray();
        fontJson.add("providers", (JsonElement)providers);
        this.saveBossBar();
        this.saveLegacyUnicodes();
        this.generateShaders();
        this.getOffsets(texturesFolder).forEach(arg_0 -> ((JsonArray)providers).add(arg_0));
        this.getNameplates(texturesFolder).forEach(arg_0 -> ((JsonArray)providers).add(arg_0));
        this.getBubbles(texturesFolder).forEach(arg_0 -> ((JsonArray)providers).add(arg_0));
        this.getBackgrounds(texturesFolder).forEach(arg_0 -> ((JsonArray)providers).add(arg_0));
        this.getImages(texturesFolder).forEach(arg_0 -> ((JsonArray)providers).add(arg_0));
        this.setPackFormat();
        this.saveFont(fontJson);
        this.copyResourcePackToHookedPlugins(resourcePackFolder);
    }

    private void generateShaders() {
        String line;
        if (!CNConfig.enableShader) {
            return;
        }
        String path = "ResourcePack" + File.separator + "assets" + File.separator + "minecraft" + File.separator + "shaders" + File.separator + "core" + File.separator;
        this.plugin.saveResource(path + "rendertype_text.fsh", true);
        this.plugin.saveResource(path + "rendertype_text.json", true);
        this.plugin.saveResource(path + "rendertype_text.vsh", true);
        StringBuilder sb1 = new StringBuilder();
        File shader1 = new File(this.plugin.getDataFolder(), path + "rendertype_text.vsh");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(shader1), StandardCharsets.UTF_8));){
            while ((line = reader.readLine()) != null) {
                sb1.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(shader1), StandardCharsets.UTF_8));){
            writer.write(sb1.toString().replace("%SHADER_0%", !CNConfig.animatedImage ? "" : "\nout vec2 pos1;\nout vec2 pos2;\nout vec2 coord;\nflat out int posID;\n").replace("%SHADER_1%", !CNConfig.textEffects ? "if (Color.xyz == vec3(255., 254., 253.) / 255.) {\n        vertexColor = Color*texelFetch(Sampler2, UV2 / 16, 0);\n        vertex.y += 1;\n        vertex.x += 1;\n        gl_Position = ProjMat * ModelViewMat * vertex;\n    } else if (Color.xyz == vec3(254., 254., 254.) / 255.) {\n        vertexColor = Color*texelFetch(Sampler2, UV2 / 16, 0);\n        vertex.z -= 0.001;\n        gl_Position = ProjMat * ModelViewMat * vertex;\n    } else if (Color.xyz == vec3(253., 254., 254.) / 255.) {\n        vertexColor = Color*texelFetch(Sampler2, UV2 / 16, 0);\n        vertex.z -= 0.0011;\n        gl_Position = ProjMat * ModelViewMat * vertex;\n    } else {\n        vertexColor = Color*texelFetch(Sampler2, UV2 / 16, 0);\n        gl_Position = ProjMat * ModelViewMat * vertex;\n    }" : "if (Color.xyz == vec3(255., 255., 254.) / 255.) {\n        gl_Position = ProjMat * ModelViewMat * vertex;\n        vertexColor = ((.6 + .6 * cos(6. * (gl_Position.x + GameTime * 1000.) + vec4(0, 23, 21, 1))) + vec4(0., 0., 0., 1.)) * texelFetch(Sampler2, UV2 / 16, 0);\n    } else if (Color.xyz == vec3(255., 255., 253.) / 255.) {\n        gl_Position = ProjMat * ModelViewMat * vertex;\n        vertexColor = Color * texelFetch(Sampler2, UV2 / 16, 0);\n        gl_Position.y = gl_Position.y + sin(GameTime * 12000. + (gl_Position.x * 6)) / 150.;\n    } else if (Color.xyz == vec3(255., 255., 252.) / 255.) {\n        gl_Position = ProjMat * ModelViewMat * vertex;\n        vertexColor = ((.6 + .6 * cos(6. * (gl_Position.x + GameTime * 1000.) + vec4(0, 23, 21, 1))) + vec4(0., 0., 0., 1.)) * texelFetch(Sampler2, UV2 / 16, 0);\n        gl_Position.y = gl_Position.y + sin(GameTime*12000. + (gl_Position.x*6)) / 150.;\n    } else if (Color.xyz == vec3(255., 255., 251.) / 255.) {\n        vertexColor = Color * texelFetch(Sampler2, UV2 / 16, 0);\n        float vertexId = mod(gl_VertexID, 4.0);\n        if (vertex.z <= 0.) {\n            if (vertexId == 3. || vertexId == 0.) vertex.y += cos(GameTime * 12000. / 4) * 0.1;\n            vertex.y += max(cos(GameTime*12000. / 4) * 0.1, 0.);\n        } else {\n            if (vertexId == 3. || vertexId == 0.) vertex.y -= cos(GameTime * 12000. / 4) * 3;\n            vertex.y -= max(cos(GameTime*12000. / 4) * 4, 0.);\n        }\n        gl_Position = ProjMat * ModelViewMat * vertex;\n    } else if (Color.xyz == vec3(255., 254., 254.) / 255.) {\n        float vertexId = mod(gl_VertexID, 4.0);\n        if (vertex.z <= 0.) {\n            if (vertexId == 3. || vertexId == 0.) vertex.y += cos(GameTime * 12000. / 4) * 0.1;\n            vertex.y += max(cos(GameTime*12000. / 4) * 0.1, 0.);\n        } else {\n            if (vertexId == 3. || vertexId == 0.) vertex.y -= cos(GameTime * 12000. / 4) * 3;\n            vertex.y -= max(cos(GameTime*12000. / 4) * 4, 0.);\n        }\n        vertexColor = ((.6 + .6 * cos(6. * (gl_Position.x + GameTime * 1000.) + vec4(0, 23, 21, 1))) + vec4(0., 0., 0., 1.)) * texelFetch(Sampler2, UV2 / 16, 0);\n        gl_Position = ProjMat * ModelViewMat * vertex;\n    } else if (Color.xyz == vec3(255., 254., 253.) / 255.) {\n        vertexColor = Color*texelFetch(Sampler2, UV2 / 16, 0);\n        vertex.y += 1;\n        vertex.x += 1;\n        gl_Position = ProjMat * ModelViewMat * vertex;\n    } else if (Color.xyz == vec3(254., 254., 254.) / 255.) {\n        vertexColor = Color*texelFetch(Sampler2, UV2 / 16, 0);\n        vertex.z -= 0.001;\n        gl_Position = ProjMat * ModelViewMat * vertex;\n    } else if (Color.xyz == vec3(253., 254., 254.) / 255.) {\n        vertexColor = Color*texelFetch(Sampler2, UV2 / 16, 0);\n        vertex.z -= 0.0011;\n        gl_Position = ProjMat * ModelViewMat * vertex;\n    } else {\n        vertexColor = Color*texelFetch(Sampler2, UV2 / 16, 0);\n        gl_Position = ProjMat * ModelViewMat * vertex;\n    }").replace("%SHADER_2%", !CNConfig.animatedImage ? "" : "\n    pos1 = pos2 = vec2(0);\n    posID = gl_VertexID % 4;\n    const vec2[4] corners = vec2[4](vec2(0), vec2(0, 1), vec2(1), vec2(1, 0));\n    coord = corners[posID];\n    if (posID == 0) pos1 = UV0 * 256;\n    if (posID == 2) pos2 = UV0 * 256;").replace("%SHADER_3%", !CNConfig.hideScoreboardNumber ? "" : "\n    if (Position.z == 0.0\n        && gl_Position.x >= 0.94\n        && gl_Position.y >= -0.35\n        && vertexColor.g == 84.0/255.0\n        && vertexColor.g == 84.0/255.0\n        && vertexColor.r == 252.0/255.0\n        && gl_VertexID <= 7\n    ) {\n        gl_Position = ProjMat * ModelViewMat * vec4(ScreenSize + 100.0, 0.0, ScreenSize + 100.0);\n    }"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File shader2 = new File(this.plugin.getDataFolder(), path + "rendertype_text.fsh");
        StringBuilder sb2 = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(shader2), StandardCharsets.UTF_8));){
            while ((line = reader.readLine()) != null) {
                sb2.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(shader2), StandardCharsets.UTF_8));){
            writer.write(sb2.toString().replace("%SHADER_0%", !CNConfig.animatedImage ? "" : "\nin vec2 pos1;\nin vec2 pos2;\nin vec2 coord;\nflat in int posID;\n").replace("%SHADER_1%", !CNConfig.animatedImage ? "" : "\n    vec2 p1 = round(pos1 / (posID == 0 ? 1 - coord.x : 1 - coord.y));\n    vec2 p2 = round(pos2 / (posID == 0 ? coord.y : coord.x));\n    ivec2 resolution = ivec2(abs(p1 - p2));\n    ivec2 corner = ivec2(min(p1, p2));\n    vec4 pixel = texture(Sampler0, corner / 256.0) * 255;\n    if (pixel.a == 1) {\n        ivec2 frames = ivec2(resolution / pixel.gb);\n        vec2 uv = (texCoord0 * 256 - corner) / frames.x;\n        if (uv.x > pixel.y || uv.y > pixel.z)\n            discard;\n        int time = int(GameTime * 1200 * pixel.x) % int(frames.x * frames.y);\n        uv = corner + mod(uv, pixel.yz) + vec2(time % frames.x, time / frames.x % frames.y) * pixel.yz;\n        color = texture(Sampler0, uv / 256.0) * vertexColor * ColorModulator;\n    }"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveLegacyUnicodes() {
        if (CNConfig.legacyUnicodes) {
            for (int i = 0; i < 256; ++i) {
                String path = "font" + File.separator + "unicode_page_" + String.format("%02x", i) + ".png";
                String destination = "ResourcePack" + File.separator + "assets" + File.separator + "minecraft" + File.separator + "textures" + File.separator + "font" + File.separator + "unicode_page_" + String.format("%02x", i) + ".png";
                File imageFile = new File(this.plugin.getDataFolder(), path);
                File destinationFile = new File(this.plugin.getDataFolder(), destination);
                if (!imageFile.exists()) continue;
                try {
                    FileUtils.copyFile((File)imageFile, (File)destinationFile);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void saveBossBar() {
        if (CNConfig.newBossBarImage) {
            String color = CNConfig.barColorToRemove.name().toLowerCase(Locale.ENGLISH);
            String path = "ResourcePack" + File.separator + "assets" + File.separator + "minecraft" + File.separator + "textures" + File.separator + "gui" + File.separator + "sprites" + File.separator + "boss_bar" + File.separator;
            this.plugin.saveResource(path + color + "_background.png", true);
            this.plugin.saveResource(path + color + "_progress.png", true);
        }
        if (CNConfig.legacyBossBarImage) {
            String path = "ResourcePack" + File.separator + "assets" + File.separator + "minecraft" + File.separator + "textures" + File.separator + "gui" + File.separator + "bars.png";
            this.plugin.saveResource(path, true);
            try {
                File inputFile = new File(this.plugin.getDataFolder(), path);
                BufferedImage image = ImageIO.read(inputFile);
                int y = switch (CNConfig.barColorToRemove) {
                    case BarColor.PINK -> 0;
                    case BarColor.BLUE -> 10;
                    case BarColor.RED -> 20;
                    case BarColor.GREEN -> 30;
                    case BarColor.PURPLE -> 50;
                    case BarColor.WHITE -> 60;
                    default -> 40;
                };
                int width = 182;
                int height = 10;
                for (int i = 0; i < width; ++i) {
                    for (int j = y; j < y + height; ++j) {
                        image.setRGB(i, j, 0);
                    }
                }
                ImageIO.write((RenderedImage)image, "png", inputFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void saveFont(JsonObject fontJson) {
        String line;
        BufferedReader reader;
        StringBuilder sb;
        try (FileWriter fileWriter = new FileWriter(this.plugin.getDataFolder() + File.separator + "ResourcePack" + File.separator + "assets" + File.separator + CNConfig.namespace + File.separator + "font" + File.separator + CNConfig.font + ".json");){
            fileWriter.write(fontJson.toString().replace("\\\\", "\\"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<Integer> ascentTexts = new ArrayList<Integer>();
        ArrayList<Integer> ascentUnicodes = new ArrayList<Integer>();
        for (DescentText descentText : this.plugin.getPlaceholderManager().getDescentTexts()) {
            if (descentText.isUnicode()) {
                ascentUnicodes.add(descentText.getAscent());
                continue;
            }
            ascentTexts.add(descentText.getAscent());
        }
        ascentTexts.removeAll(ascentUnicodes);
        Iterator<DescentText> iterator = ascentTexts.iterator();
        while (iterator.hasNext()) {
            int ascent = (Integer)((Object)iterator.next());
            sb = new StringBuilder();
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(this.plugin.getDataFolder(), "font" + File.separator + "default.json")), StandardCharsets.UTF_8));
                try {
                    while ((line = reader.readLine()) != null) {
                        sb.append(line).append(System.lineSeparator());
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            File outPut = new File(this.plugin.getDataFolder(), "ResourcePack" + File.separator + "assets" + File.separator + CNConfig.namespace + File.separator + "font" + File.separator + "ascent_" + ascent + ".json");
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outPut), StandardCharsets.UTF_8));){
                writer.write(sb.toString().replace("\\\\", "\\").replace("%ascent%", String.valueOf(ascent)).replace("%ASCENT%", String.valueOf(ascent + 3)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        iterator = ascentUnicodes.iterator();
        while (iterator.hasNext()) {
            int ascent = (Integer)((Object)iterator.next());
            sb = new StringBuilder();
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(this.plugin.getDataFolder(), "font" + File.separator + "unicode.json")), StandardCharsets.UTF_8));
                try {
                    while ((line = reader.readLine()) != null) {
                        sb.append(line).append(System.lineSeparator());
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.plugin.getDataFolder(), "ResourcePack" + File.separator + "assets" + File.separator + CNConfig.namespace + File.separator + "font" + File.separator + "ascent_" + ascent + ".json")), StandardCharsets.UTF_8));){
                writer.write(sb.toString().replace("\\\\", "\\").replace("%ascent%", String.valueOf(ascent)).replace("%ASCENT%", String.valueOf(ascent + 3)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void deleteDirectory(File file) {
        if (file.exists()) {
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void saveSplit(File texturesFolder) {
        try {
            this.plugin.saveResource("space_split.png", false);
            FileUtils.copyFile((File)new File(this.plugin.getDataFolder(), "space_split.png"), (File)new File(texturesFolder, CNConfig.folderSplit.replace("\\", File.separator) + "space_split.png"));
            File file = new File(this.plugin.getDataFolder(), "space_split.png");
            if (file.exists()) {
                file.delete();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void copyResourcePackToHookedPlugins(File resourcePackFolder) {
        Plugin ia = Bukkit.getPluginManager().getPlugin("ItemsAdder");
        if (ia != null) {
            File file = new File(ia.getDataFolder(), "config.yml");
            YamlConfiguration iaConfig = YamlConfiguration.loadConfiguration((File)file);
            List folders = iaConfig.getStringList("resource-pack.zip.merge_other_plugins_resourcepacks_folders");
            boolean changed = false;
            if (CNConfig.copyPackIA) {
                if (!folders.contains("CustomNameplates/ResourcePack")) {
                    folders.add("CustomNameplates/ResourcePack");
                    iaConfig.set("resource-pack.zip.merge_other_plugins_resourcepacks_folders", (Object)folders);
                    changed = true;
                }
            } else if (folders.contains("CustomNameplates/ResourcePack")) {
                folders.remove("CustomNameplates/ResourcePack");
                iaConfig.set("resource-pack.zip.merge_other_plugins_resourcepacks_folders", (Object)folders);
                changed = true;
            }
            if (changed) {
                try {
                    iaConfig.save(file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (CNConfig.copyPackIAOld) {
            try {
                FileUtils.copyDirectory((File)new File(resourcePackFolder, "assets"), (File)new File(Objects.requireNonNull(Bukkit.getPluginManager().getPlugin("ItemsAdder")).getDataFolder() + File.separator + "contents" + File.separator + "nameplates" + File.separator + "resourcepack" + File.separator + "assets"));
            }
            catch (IOException e) {
                e.printStackTrace();
                LogUtils.warn("Failed to copy files to ItemsAdder...");
            }
        }
        if (CNConfig.copyPackOraxen) {
            try {
                FileUtils.copyDirectory((File)new File(resourcePackFolder, "assets"), (File)new File(Objects.requireNonNull(Bukkit.getPluginManager().getPlugin("Oraxen")).getDataFolder() + File.separator + "pack" + File.separator + "assets"));
            }
            catch (IOException e) {
                e.printStackTrace();
                LogUtils.warn("Failed to copy files to Oraxen...");
            }
        }
    }

    private List<JsonObject> getNameplates(File texturesFolder) {
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        if (!CNConfig.nameplateModule) {
            return list;
        }
        for (Nameplate nameplate : this.plugin.getNameplateManager().getNameplates()) {
            for (ConfiguredChar configuredChar : new ConfiguredChar[]{nameplate.getLeft(), nameplate.getMiddle(), nameplate.getRight()}) {
                JsonObject jo = new JsonObject();
                jo.add("type", (JsonElement)new JsonPrimitive("bitmap"));
                jo.add("file", (JsonElement)new JsonPrimitive(CNConfig.namespace + ":" + CNConfig.folderNameplate.replaceAll("\\\\", "/") + configuredChar.getFile()));
                jo.add("ascent", (JsonElement)new JsonPrimitive((Number)configuredChar.getAscent()));
                jo.add("height", (JsonElement)new JsonPrimitive((Number)configuredChar.getHeight()));
                JsonArray ja = new JsonArray();
                ja.add(ConfigUtils.native2ascii(configuredChar.getCharacter()));
                jo.add("chars", (JsonElement)ja);
                list.add(jo);
                try {
                    FileUtils.copyFile((File)new File(this.plugin.getDataFolder(), "contents" + File.separator + "nameplates" + File.separator + configuredChar.getFile()), (File)new File(texturesFolder, CNConfig.folderNameplate.replace("\\", File.separator) + configuredChar.getFile()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    private List<JsonObject> getBackgrounds(File texturesFolder) {
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        if (!CNConfig.backgroundModule) {
            return list;
        }
        for (BackGround backGround : this.plugin.getBackGroundManager().getBackGrounds()) {
            for (ConfiguredChar configuredChar : new ConfiguredChar[]{backGround.getLeft(), backGround.getOffset_1(), backGround.getOffset_2(), backGround.getOffset_4(), backGround.getOffset_8(), backGround.getOffset_16(), backGround.getOffset_32(), backGround.getOffset_64(), backGround.getOffset_128(), backGround.getRight()}) {
                JsonObject jo = new JsonObject();
                jo.add("type", (JsonElement)new JsonPrimitive("bitmap"));
                jo.add("file", (JsonElement)new JsonPrimitive(CNConfig.namespace + ":" + CNConfig.folderBackground.replaceAll("\\\\", "/") + configuredChar.getFile()));
                jo.add("ascent", (JsonElement)new JsonPrimitive((Number)configuredChar.getAscent()));
                jo.add("height", (JsonElement)new JsonPrimitive((Number)configuredChar.getHeight()));
                JsonArray ja = new JsonArray();
                ja.add(ConfigUtils.native2ascii(configuredChar.getCharacter()));
                jo.add("chars", (JsonElement)ja);
                list.add(jo);
                try {
                    FileUtils.copyFile((File)new File(this.plugin.getDataFolder(), "contents" + File.separator + "backgrounds" + File.separator + configuredChar.getFile()), (File)new File(texturesFolder, CNConfig.folderBackground.replace("\\", File.separator) + configuredChar.getFile()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    private List<JsonObject> getBubbles(File texturesFolder) {
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        if (!CNConfig.bubbleModule) {
            return list;
        }
        for (Bubble bubble : this.plugin.getBubbleManager().getBubbles()) {
            for (ConfiguredChar configuredChar : new ConfiguredChar[]{bubble.getLeft(), bubble.getMiddle(), bubble.getRight(), bubble.getTail()}) {
                JsonObject jo = new JsonObject();
                jo.add("type", (JsonElement)new JsonPrimitive("bitmap"));
                jo.add("file", (JsonElement)new JsonPrimitive(CNConfig.namespace + ":" + CNConfig.folderBubble.replaceAll("\\\\", "/") + configuredChar.getFile()));
                jo.add("ascent", (JsonElement)new JsonPrimitive((Number)configuredChar.getAscent()));
                jo.add("height", (JsonElement)new JsonPrimitive((Number)configuredChar.getHeight()));
                JsonArray ja = new JsonArray();
                ja.add(ConfigUtils.native2ascii(configuredChar.getCharacter()));
                jo.add("chars", (JsonElement)ja);
                list.add(jo);
                try {
                    FileUtils.copyFile((File)new File(this.plugin.getDataFolder(), "contents" + File.separator + "bubbles" + File.separator + configuredChar.getFile()), (File)new File(texturesFolder, CNConfig.folderBubble.replace("\\", File.separator) + configuredChar.getFile()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    private List<JsonObject> getImages(File texturesFolder) {
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        if (!CNConfig.imageModule) {
            return list;
        }
        for (ConfiguredChar configuredChar : this.plugin.getImageManager().getImages()) {
            JsonObject jo = new JsonObject();
            jo.add("type", (JsonElement)new JsonPrimitive("bitmap"));
            jo.add("file", (JsonElement)new JsonPrimitive(CNConfig.namespace + ":" + CNConfig.folderImage.replaceAll("\\\\", "/") + configuredChar.getFile()));
            jo.add("ascent", (JsonElement)new JsonPrimitive((Number)configuredChar.getAscent()));
            jo.add("height", (JsonElement)new JsonPrimitive((Number)configuredChar.getHeight()));
            JsonArray ja = new JsonArray();
            ja.add(ConfigUtils.native2ascii(configuredChar.getCharacter()));
            jo.add("chars", (JsonElement)ja);
            list.add(jo);
            try {
                FileUtils.copyFile((File)new File(this.plugin.getDataFolder(), "contents" + File.separator + "images" + File.separator + configuredChar.getFile()), (File)new File(texturesFolder, CNConfig.folderImage.replace("\\", File.separator) + configuredChar.getFile()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    private List<JsonObject> getOffsets(File texturesFolder) {
        this.saveSplit(texturesFolder);
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        for (OffsetFont offsetFont : OffsetFont.values()) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("type", (JsonElement)new JsonPrimitive("bitmap"));
            jsonObject.add("file", (JsonElement)new JsonPrimitive(CNConfig.namespace + ":" + CNConfig.folderSplit.replaceAll("\\\\", "/") + "space_split.png"));
            jsonObject.add("ascent", (JsonElement)new JsonPrimitive((Number)-5000));
            jsonObject.add("height", (JsonElement)new JsonPrimitive((Number)offsetFont.getHeight()));
            JsonArray jsonArray = new JsonArray();
            jsonArray.add(ConfigUtils.native2ascii(offsetFont.getCharacter()));
            jsonObject.add("chars", (JsonElement)jsonArray);
            list.add(jsonObject);
        }
        return list;
    }

    private void setPackFormat() {
        this.plugin.saveResource("ResourcePack" + File.separator + "pack.mcmeta", false);
        File format_file = new File(this.plugin.getDataFolder(), "ResourcePack" + File.separator + "pack.mcmeta");
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(format_file), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.plugin.getDataFolder(), "ResourcePack" + File.separator + "pack.mcmeta")), StandardCharsets.UTF_8));){
            writer.write(sb.toString().replace("%version%", String.valueOf(this.plugin.getVersionManager().getPackFormat())));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class ShaderConstants {
        public static final String Nameplates_Shader = "if (Color.xyz == vec3(255., 254., 253.) / 255.) {\n        vertexColor = Color*texelFetch(Sampler2, UV2 / 16, 0);\n        vertex.y += 1;\n        vertex.x += 1;\n        gl_Position = ProjMat * ModelViewMat * vertex;\n    } else if (Color.xyz == vec3(254., 254., 254.) / 255.) {\n        vertexColor = Color*texelFetch(Sampler2, UV2 / 16, 0);\n        vertex.z -= 0.001;\n        gl_Position = ProjMat * ModelViewMat * vertex;\n    } else if (Color.xyz == vec3(253., 254., 254.) / 255.) {\n        vertexColor = Color*texelFetch(Sampler2, UV2 / 16, 0);\n        vertex.z -= 0.0011;\n        gl_Position = ProjMat * ModelViewMat * vertex;\n    } else {\n        vertexColor = Color*texelFetch(Sampler2, UV2 / 16, 0);\n        gl_Position = ProjMat * ModelViewMat * vertex;\n    }";
        public static final String ItemsAdder_Text_Effects = "if (Color.xyz == vec3(255., 255., 254.) / 255.) {\n        gl_Position = ProjMat * ModelViewMat * vertex;\n        vertexColor = ((.6 + .6 * cos(6. * (gl_Position.x + GameTime * 1000.) + vec4(0, 23, 21, 1))) + vec4(0., 0., 0., 1.)) * texelFetch(Sampler2, UV2 / 16, 0);\n    } else if (Color.xyz == vec3(255., 255., 253.) / 255.) {\n        gl_Position = ProjMat * ModelViewMat * vertex;\n        vertexColor = Color * texelFetch(Sampler2, UV2 / 16, 0);\n        gl_Position.y = gl_Position.y + sin(GameTime * 12000. + (gl_Position.x * 6)) / 150.;\n    } else if (Color.xyz == vec3(255., 255., 252.) / 255.) {\n        gl_Position = ProjMat * ModelViewMat * vertex;\n        vertexColor = ((.6 + .6 * cos(6. * (gl_Position.x + GameTime * 1000.) + vec4(0, 23, 21, 1))) + vec4(0., 0., 0., 1.)) * texelFetch(Sampler2, UV2 / 16, 0);\n        gl_Position.y = gl_Position.y + sin(GameTime*12000. + (gl_Position.x*6)) / 150.;\n    } else if (Color.xyz == vec3(255., 255., 251.) / 255.) {\n        vertexColor = Color * texelFetch(Sampler2, UV2 / 16, 0);\n        float vertexId = mod(gl_VertexID, 4.0);\n        if (vertex.z <= 0.) {\n            if (vertexId == 3. || vertexId == 0.) vertex.y += cos(GameTime * 12000. / 4) * 0.1;\n            vertex.y += max(cos(GameTime*12000. / 4) * 0.1, 0.);\n        } else {\n            if (vertexId == 3. || vertexId == 0.) vertex.y -= cos(GameTime * 12000. / 4) * 3;\n            vertex.y -= max(cos(GameTime*12000. / 4) * 4, 0.);\n        }\n        gl_Position = ProjMat * ModelViewMat * vertex;\n    } else if (Color.xyz == vec3(255., 254., 254.) / 255.) {\n        float vertexId = mod(gl_VertexID, 4.0);\n        if (vertex.z <= 0.) {\n            if (vertexId == 3. || vertexId == 0.) vertex.y += cos(GameTime * 12000. / 4) * 0.1;\n            vertex.y += max(cos(GameTime*12000. / 4) * 0.1, 0.);\n        } else {\n            if (vertexId == 3. || vertexId == 0.) vertex.y -= cos(GameTime * 12000. / 4) * 3;\n            vertex.y -= max(cos(GameTime*12000. / 4) * 4, 0.);\n        }\n        vertexColor = ((.6 + .6 * cos(6. * (gl_Position.x + GameTime * 1000.) + vec4(0, 23, 21, 1))) + vec4(0., 0., 0., 1.)) * texelFetch(Sampler2, UV2 / 16, 0);\n        gl_Position = ProjMat * ModelViewMat * vertex;\n    } else ";
        public static final String Hide_ScoreBoard_Numbers = "\n    if (Position.z == 0.0\n        && gl_Position.x >= 0.94\n        && gl_Position.y >= -0.35\n        && vertexColor.g == 84.0/255.0\n        && vertexColor.g == 84.0/255.0\n        && vertexColor.r == 252.0/255.0\n        && gl_VertexID <= 7\n    ) {\n        gl_Position = ProjMat * ModelViewMat * vec4(ScreenSize + 100.0, 0.0, ScreenSize + 100.0);\n    }";
        public static final String Animated_Text_FSH = "\n    vec2 p1 = round(pos1 / (posID == 0 ? 1 - coord.x : 1 - coord.y));\n    vec2 p2 = round(pos2 / (posID == 0 ? coord.y : coord.x));\n    ivec2 resolution = ivec2(abs(p1 - p2));\n    ivec2 corner = ivec2(min(p1, p2));\n    vec4 pixel = texture(Sampler0, corner / 256.0) * 255;\n    if (pixel.a == 1) {\n        ivec2 frames = ivec2(resolution / pixel.gb);\n        vec2 uv = (texCoord0 * 256 - corner) / frames.x;\n        if (uv.x > pixel.y || uv.y > pixel.z)\n            discard;\n        int time = int(GameTime * 1200 * pixel.x) % int(frames.x * frames.y);\n        uv = corner + mod(uv, pixel.yz) + vec2(time % frames.x, time / frames.x % frames.y) * pixel.yz;\n        color = texture(Sampler0, uv / 256.0) * vertexColor * ColorModulator;\n    }";
        public static final String Animated_Text_VSH = "\n    pos1 = pos2 = vec2(0);\n    posID = gl_VertexID % 4;\n    const vec2[4] corners = vec2[4](vec2(0), vec2(0, 1), vec2(1), vec2(1, 0));\n    coord = corners[posID];\n    if (posID == 0) pos1 = UV0 * 256;\n    if (posID == 2) pos2 = UV0 * 256;";
        public static final String Animated_Text_Out = "\nout vec2 pos1;\nout vec2 pos2;\nout vec2 coord;\nflat out int posID;\n";
        public static final String Animated_Text_In = "\nin vec2 pos1;\nin vec2 pos2;\nin vec2 coord;\nflat in int posID;\n";
    }
}

