/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.placeholder;

import java.util.Optional;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.data.OnlineUser;
import net.momirealms.customnameplates.api.manager.PlaceholderManager;
import net.momirealms.customnameplates.api.mechanic.bubble.Bubble;
import net.momirealms.customnameplates.api.mechanic.character.ConfiguredChar;
import net.momirealms.customnameplates.api.mechanic.font.OffsetFont;
import net.momirealms.customnameplates.api.mechanic.nameplate.Nameplate;
import net.momirealms.customnameplates.api.mechanic.placeholder.BackGroundText;
import net.momirealms.customnameplates.api.mechanic.placeholder.ConditionalText;
import net.momirealms.customnameplates.api.mechanic.placeholder.DescentText;
import net.momirealms.customnameplates.api.mechanic.placeholder.NameplateText;
import net.momirealms.customnameplates.api.mechanic.placeholder.StaticText;
import net.momirealms.customnameplates.api.mechanic.placeholder.SwitchText;
import net.momirealms.customnameplates.api.mechanic.placeholder.VanillaHud;
import net.momirealms.customnameplates.api.util.FontUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginPlaceholders
extends PlaceholderExpansion {
    private final CustomNameplatesPlugin plugin;
    private final PlaceholderManager placeholderManager;

    public PluginPlaceholders(CustomNameplatesPlugin plugin, PlaceholderManager placeholderManager) {
        this.plugin = plugin;
        this.placeholderManager = placeholderManager;
    }

    @NotNull
    public String getIdentifier() {
        return "nameplates";
    }

    @NotNull
    public String getAuthor() {
        return "XiaoMoMi";
    }

    @NotNull
    public String getVersion() {
        return "2.3";
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String params) {
        String[] mainSplit = params.split("_", 2);
        String mainPara = mainSplit[0];
        String mainArg = mainSplit.length == 1 ? "" : mainSplit[1];
        switch (mainPara) {
            case "image": {
                ConfiguredChar configuredChar = this.plugin.getImageManager().getImage(mainArg);
                if (configuredChar == null) {
                    return "Image not exists";
                }
                return FontUtils.surroundNameplateFont(String.valueOf(configuredChar.getCharacter()));
            }
            case "image-char": {
                ConfiguredChar configuredChar = this.plugin.getImageManager().getImage(mainArg);
                if (configuredChar == null) {
                    return "Image not exists";
                }
                return String.valueOf(configuredChar.getCharacter());
            }
            case "offset": {
                return FontUtils.surroundNameplateFont(OffsetFont.getOffsetChars(Integer.parseInt(mainArg)));
            }
            case "offset-char": {
                return OffsetFont.getOffsetChars(Integer.parseInt(mainArg));
            }
            case "checkupdate": {
                return String.valueOf(!this.plugin.getVersionManager().isLatest());
            }
            case "is-latest": {
                return String.valueOf(this.plugin.getVersionManager().isLatest());
            }
            case "static": {
                StaticText text = this.placeholderManager.getStaticText(mainArg);
                if (text == null) {
                    return "Static text not exists: " + mainArg;
                }
                return text.getValue(offlinePlayer);
            }
            case "unicode": 
            case "descent": {
                DescentText descentText = this.placeholderManager.getDescentText(mainArg);
                if (descentText == null) {
                    return "Descent text not exists: " + mainArg;
                }
                return descentText.getValue(offlinePlayer);
            }
            case "conditional": {
                ConditionalText conditionalText = this.placeholderManager.getConditionalText(mainArg);
                if (conditionalText == null) {
                    return "Conditional text not exists: " + mainArg;
                }
                return conditionalText.getValue(offlinePlayer);
            }
            case "nameplate": {
                NameplateText nameplateText = this.placeholderManager.getNameplateText(mainArg);
                if (nameplateText == null) {
                    return "Nameplate text not exists: " + mainArg;
                }
                return nameplateText.getValue(offlinePlayer);
            }
            case "background": {
                BackGroundText backGroundText = this.placeholderManager.getBackGroundText(mainArg);
                if (backGroundText == null) {
                    return "Background text not exists: " + mainArg;
                }
                return backGroundText.getValue(offlinePlayer);
            }
            case "vanilla": {
                VanillaHud vanillaHud = this.placeholderManager.getVanillaHud(mainArg);
                if (vanillaHud == null) {
                    return "Vanilla text not exists: " + mainArg;
                }
                return vanillaHud.getValue(offlinePlayer);
            }
            case "switch": {
                SwitchText switchText = this.placeholderManager.getSwitchText(mainArg);
                if (switchText == null) {
                    return "Switch text not exists: " + mainArg;
                }
                return switchText.getValue(offlinePlayer);
            }
        }
        Player onlinePlayer = offlinePlayer.getPlayer();
        if (onlinePlayer == null) {
            return null;
        }
        switch (mainPara) {
            case "time": {
                long time = onlinePlayer.getWorld().getTime();
                String ap = time >= 6000L && time < 18000L ? " PM" : " AM";
                int hours = (int)(time / 1000L);
                int minutes = (int)((double)(time - (long)(hours * 1000)) * 0.06);
                hours += 6;
                while (hours >= 12) {
                    hours -= 12;
                }
                if (minutes < 10) {
                    return hours + ":0" + minutes + ap;
                }
                return hours + ":" + minutes + ap;
            }
            case "actionbar": {
                return this.plugin.getActionBarManager().getOtherPluginActionBar(onlinePlayer);
            }
            case "prefix": {
                return this.plugin.getNameplateManager().getNameplatePrefix(onlinePlayer);
            }
            case "suffix": {
                return this.plugin.getNameplateManager().getNameplateSuffix(onlinePlayer);
            }
            case "nametag": {
                return this.plugin.getNameplateManager().getFullNameTag(onlinePlayer);
            }
            case "equipped": {
                Optional<OnlineUser> optPlayer = this.plugin.getStorageManager().getOnlineUser(onlinePlayer.getUniqueId());
                if (optPlayer.isEmpty()) {
                    return "Data not loaded";
                }
                switch (mainArg) {
                    case "nameplate": {
                        return optPlayer.get().getNameplateKey();
                    }
                    case "nameplate-name": {
                        Nameplate nameplate = optPlayer.get().getNameplate();
                        if (nameplate == null) {
                            return "";
                        }
                        return nameplate.getDisplayName();
                    }
                    case "bubble": {
                        return optPlayer.get().getBubbleKey();
                    }
                    case "bubble-name": {
                        Bubble bubble = optPlayer.get().getBubble();
                        if (bubble == null) {
                            return "";
                        }
                        return bubble.getDisplayName();
                    }
                }
            }
        }
        return null;
    }
}

