/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.requirement;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import me.clip.placeholderapi.PlaceholderAPI;
import net.momirealms.customnameplates.api.manager.RequirementManager;
import net.momirealms.customnameplates.api.requirement.Requirement;
import net.momirealms.customnameplates.api.requirement.RequirementExpansion;
import net.momirealms.customnameplates.api.requirement.RequirementFactory;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.common.Pair;
import net.momirealms.customnameplates.libraries.biomeapi.BiomeAPI;
import net.momirealms.customnameplates.paper.CustomNameplatesPluginImpl;
import net.momirealms.customnameplates.paper.mechanic.requirement.EmptyRequirement;
import net.momirealms.customnameplates.paper.mechanic.requirement.papi.PapiCondition;
import net.momirealms.customnameplates.paper.util.ClassUtils;
import net.momirealms.customnameplates.paper.util.ConfigUtils;
import net.momirealms.customnameplates.paper.util.GeyserUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequirementManagerImpl
implements RequirementManager {
    private final CustomNameplatesPluginImpl plugin;
    private final String EXPANSION_FOLDER = "expansions/requirement";
    private final HashMap<String, RequirementFactory> requirementBuilderMap;

    public RequirementManagerImpl(CustomNameplatesPluginImpl plugin) {
        this.plugin = plugin;
        this.requirementBuilderMap = new HashMap(64);
        this.registerInbuiltRequirements();
    }

    public void load() {
        this.loadExpansions();
    }

    public void unload() {
    }

    public void reload() {
        this.unload();
        this.load();
    }

    public void disable() {
        this.requirementBuilderMap.clear();
    }

    @Override
    public boolean registerRequirement(String type, RequirementFactory requirementFactory) {
        if (this.requirementBuilderMap.containsKey(type)) {
            return false;
        }
        this.requirementBuilderMap.put(type, requirementFactory);
        return true;
    }

    @Override
    public boolean unregisterRequirement(String type) {
        return this.requirementBuilderMap.remove(type) != null;
    }

    private void registerInbuiltRequirements() {
        this.registerTimeRequirement();
        this.registerYRequirement();
        this.registerContainRequirement();
        this.registerStartWithRequirement();
        this.registerEndWithRequirement();
        this.registerEqualsRequirement();
        this.registerBiomeRequirement();
        this.registerDateRequirement();
        this.registerPermissionRequirement();
        this.registerWorldRequirement();
        this.registerWeatherRequirement();
        this.registerGreaterThanRequirement();
        this.registerAndRequirement();
        this.registerOrRequirement();
        this.registerLevelRequirement();
        this.registerRandomRequirement();
        this.registerCoolDownRequirement();
        this.registerLessThanRequirement();
        this.registerNumberEqualRequirement();
        this.registerRegexRequirement();
        this.registerEnvironmentRequirement();
        this.registerPotionEffectRequirement();
        this.registerPapiRequirement();
        this.registerInListRequirement();
        this.registerGameModeRequirement();
        this.registerGeyserRequirement();
    }

    @Override
    @NotNull
    public Requirement[] getRequirements(ConfigurationSection section) {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        if (section == null) {
            return requirements.toArray(new Requirement[0]);
        }
        for (Map.Entry entry : section.getValues(false).entrySet()) {
            String typeOrName = (String)entry.getKey();
            if (this.hasRequirement(typeOrName)) {
                requirements.add(this.getRequirement(typeOrName, entry.getValue()));
                continue;
            }
            requirements.add(this.getRequirement(section.getConfigurationSection(typeOrName)));
        }
        return requirements.toArray(new Requirement[0]);
    }

    public boolean hasRequirement(String type) {
        return this.requirementBuilderMap.containsKey(type);
    }

    @Override
    @NotNull
    public Requirement getRequirement(ConfigurationSection section) {
        if (section == null) {
            return EmptyRequirement.instance;
        }
        String type = section.getString("type");
        if (type == null) {
            LogUtils.warn("No requirement type found at " + section.getCurrentPath());
            return EmptyRequirement.instance;
        }
        RequirementFactory builder = this.getRequirementFactory(type);
        if (builder == null) {
            return EmptyRequirement.instance;
        }
        return builder.build(section.get("value"));
    }

    @Override
    @NotNull
    public Requirement getRequirement(String type, Object value) {
        RequirementFactory factory = this.getRequirementFactory(type);
        if (factory == null) {
            LogUtils.warn("Requirement type: " + type + " doesn't exist.");
            return EmptyRequirement.instance;
        }
        return factory.build(value);
    }

    @Override
    @Nullable
    public RequirementFactory getRequirementFactory(String type) {
        return this.requirementBuilderMap.get(type);
    }

    private void registerTimeRequirement() {
        this.registerRequirement("time", args -> {
            List<Pair> timePairs = ConfigUtils.stringListArgs(args).stream().map(it -> ConfigUtils.splitStringIntegerArgs(it, "~")).toList();
            return condition -> {
                long time = Objects.requireNonNull(condition.getOfflinePlayer().getPlayer()).getWorld().getTime();
                for (Pair pair : timePairs) {
                    if (time < (long)((Integer)pair.left()).intValue() || time > (long)((Integer)pair.right()).intValue()) continue;
                    return true;
                }
                return false;
            };
        });
    }

    private void registerYRequirement() {
        this.registerRequirement("ypos", args -> {
            List<Pair> timePairs = ConfigUtils.stringListArgs(args).stream().map(it -> ConfigUtils.splitStringIntegerArgs(it, "~")).toList();
            return condition -> {
                int y = Objects.requireNonNull(condition.getOfflinePlayer().getPlayer()).getLocation().getBlockY();
                for (Pair pair : timePairs) {
                    if (y < (Integer)pair.left() || y > (Integer)pair.right()) continue;
                    return true;
                }
                return false;
            };
        });
    }

    private void registerOrRequirement() {
        this.registerRequirement("||", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                Requirement[] requirements = this.getRequirements(section);
                return condition -> {
                    for (Requirement requirement : requirements) {
                        if (!requirement.isConditionMet(condition)) continue;
                        return true;
                    }
                    return false;
                };
            }
            LogUtils.warn("Wrong value format found at || requirement.");
            return EmptyRequirement.instance;
        });
    }

    private void registerAndRequirement() {
        this.registerRequirement("&&", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                Requirement[] requirements = this.getRequirements(section);
                return condition -> {
                    block2: {
                        for (Requirement requirement : requirements) {
                            if (requirement.isConditionMet(condition)) {
                                continue;
                            }
                            break block2;
                        }
                        return true;
                    }
                    return false;
                };
            }
            LogUtils.warn("Wrong value format found at && requirement.");
            return EmptyRequirement.instance;
        });
    }

    private void registerLevelRequirement() {
        this.registerRequirement("level", args -> {
            int level = (Integer)args;
            return condition -> {
                int current = Objects.requireNonNull(condition.getOfflinePlayer().getPlayer()).getLevel();
                return current >= level;
            };
        });
    }

    private void registerRandomRequirement() {
        this.registerRequirement("random", args -> {
            double random = ConfigUtils.getDoubleValue(args);
            return condition -> Math.random() < random;
        });
    }

    private void registerGeyserRequirement() {
        this.registerRequirement("geyser", args -> {
            boolean arg = (Boolean)args;
            return condition -> {
                if (arg) {
                    return GeyserUtils.isBedrockPlayer(condition.getOfflinePlayer().getUniqueId());
                }
                return !GeyserUtils.isBedrockPlayer(condition.getOfflinePlayer().getUniqueId());
            };
        });
    }

    private void registerBiomeRequirement() {
        this.registerRequirement("biome", args -> {
            HashSet<String> biomes = new HashSet<String>(ConfigUtils.stringListArgs(args));
            return condition -> {
                String currentBiome = BiomeAPI.getBiome(Objects.requireNonNull(condition.getOfflinePlayer().getPlayer()).getLocation());
                return biomes.contains(currentBiome);
            };
        });
        this.registerRequirement("!biome", args -> {
            HashSet<String> biomes = new HashSet<String>(ConfigUtils.stringListArgs(args));
            return condition -> {
                String currentBiome = BiomeAPI.getBiome(Objects.requireNonNull(condition.getOfflinePlayer().getPlayer()).getLocation());
                return !biomes.contains(currentBiome);
            };
        });
    }

    private void registerWorldRequirement() {
        this.registerRequirement("world", args -> {
            HashSet<String> worlds = new HashSet<String>(ConfigUtils.stringListArgs(args));
            return condition -> worlds.contains(Objects.requireNonNull(condition.getOfflinePlayer().getPlayer()).getWorld().getName());
        });
        this.registerRequirement("!world", args -> {
            HashSet<String> worlds = new HashSet<String>(ConfigUtils.stringListArgs(args));
            return condition -> !worlds.contains(Objects.requireNonNull(condition.getOfflinePlayer().getPlayer()).getWorld().getName());
        });
    }

    private void registerWeatherRequirement() {
        this.registerRequirement("weather", args -> {
            ArrayList<String> weathers = ConfigUtils.stringListArgs(args);
            return condition -> {
                World world = Objects.requireNonNull(condition.getOfflinePlayer().getPlayer()).getWorld();
                String currentWeather = world.isThundering() ? "thunder" : (world.isClearWeather() ? "clear" : "rain");
                for (String weather : weathers) {
                    if (!weather.equalsIgnoreCase(currentWeather)) continue;
                    return true;
                }
                return false;
            };
        });
    }

    private void registerCoolDownRequirement() {
        this.registerRequirement("cooldown", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String key = section.getString("key");
                int time = section.getInt("time");
                return condition -> !this.plugin.getCoolDownManager().isCoolDown(condition.getOfflinePlayer().getUniqueId(), key, time);
            }
            LogUtils.warn("Wrong value format found at cooldown requirement.");
            return EmptyRequirement.instance;
        });
    }

    private void registerDateRequirement() {
        this.registerRequirement("date", args -> {
            HashSet<String> dates = new HashSet<String>(ConfigUtils.stringListArgs(args));
            return condition -> {
                Calendar calendar = Calendar.getInstance();
                String current = calendar.get(2) + 1 + "/" + calendar.get(5);
                return dates.contains(current);
            };
        });
    }

    private void registerPermissionRequirement() {
        this.registerRequirement("permission", args -> {
            ArrayList<String> perms = ConfigUtils.stringListArgs(args);
            return condition -> {
                for (String perm : perms) {
                    if (!Objects.requireNonNull(condition.getOfflinePlayer().getPlayer()).hasPermission(perm)) continue;
                    return true;
                }
                return false;
            };
        });
        this.registerRequirement("!permission", args -> {
            ArrayList<String> perms = ConfigUtils.stringListArgs(args);
            return condition -> {
                for (String perm : perms) {
                    if (!Objects.requireNonNull(condition.getOfflinePlayer().getPlayer()).hasPermission(perm)) continue;
                    return false;
                }
                return true;
            };
        });
    }

    private void registerGreaterThanRequirement() {
        this.registerRequirement(">=", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String v1 = section.getString("value1", "");
                String v2 = section.getString("value2", "");
                return condition -> {
                    String p1 = v1.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v1) : v1;
                    String p2 = v2.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v2) : v2;
                    return Double.parseDouble(p1) >= Double.parseDouble(p2);
                };
            }
            LogUtils.warn("Wrong value format found at >= requirement.");
            return EmptyRequirement.instance;
        });
        this.registerRequirement(">", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String v1 = section.getString("value1", "");
                String v2 = section.getString("value2", "");
                return condition -> {
                    String p1 = v1.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v1) : v1;
                    String p2 = v2.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v2) : v2;
                    return Double.parseDouble(p1) > Double.parseDouble(p2);
                };
            }
            LogUtils.warn("Wrong value format found at > requirement.");
            return EmptyRequirement.instance;
        });
    }

    private void registerRegexRequirement() {
        this.registerRequirement("regex", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String v1 = section.getString("papi", "");
                String v2 = section.getString("regex", "");
                return condition -> PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v1).matches(v2);
            }
            LogUtils.warn("Wrong value format found at regex requirement.");
            return EmptyRequirement.instance;
        });
    }

    private void registerNumberEqualRequirement() {
        this.registerRequirement("=", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String v1 = section.getString("value1", "");
                String v2 = section.getString("value2", "");
                return condition -> {
                    String p1 = v1.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v1) : v1;
                    String p2 = v2.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v2) : v2;
                    return Double.parseDouble(p1) == Double.parseDouble(p2);
                };
            }
            LogUtils.warn("Wrong value format found at !startsWith requirement.");
            return EmptyRequirement.instance;
        });
        this.registerRequirement("!=", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String v1 = section.getString("value1", "");
                String v2 = section.getString("value2", "");
                return condition -> {
                    String p1 = v1.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v1) : v1;
                    String p2 = v2.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v2) : v2;
                    return Double.parseDouble(p1) != Double.parseDouble(p2);
                };
            }
            LogUtils.warn("Wrong value format found at !startsWith requirement.");
            return EmptyRequirement.instance;
        });
    }

    private void registerLessThanRequirement() {
        this.registerRequirement("<", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String v1 = section.getString("value1", "");
                String v2 = section.getString("value2", "");
                return condition -> {
                    String p1 = v1.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v1) : v1;
                    String p2 = v2.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v2) : v2;
                    return Double.parseDouble(p1) < Double.parseDouble(p2);
                };
            }
            LogUtils.warn("Wrong value format found at < requirement.");
            return EmptyRequirement.instance;
        });
        this.registerRequirement("<=", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String v1 = section.getString("value1", "");
                String v2 = section.getString("value2", "");
                return condition -> {
                    String p1 = v1.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v1) : v1;
                    String p2 = v2.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v2) : v2;
                    return Double.parseDouble(p1) <= Double.parseDouble(p2);
                };
            }
            LogUtils.warn("Wrong value format found at <= requirement.");
            return EmptyRequirement.instance;
        });
    }

    private void registerStartWithRequirement() {
        this.registerRequirement("startsWith", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String v1 = section.getString("value1", "");
                String v2 = section.getString("value2", "");
                return condition -> {
                    String p1 = v1.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v1) : v1;
                    String p2 = v2.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v2) : v2;
                    return p1.startsWith(p2);
                };
            }
            LogUtils.warn("Wrong value format found at startsWith requirement.");
            return EmptyRequirement.instance;
        });
        this.registerRequirement("!startsWith", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String v1 = section.getString("value1", "");
                String v2 = section.getString("value2", "");
                return condition -> {
                    String p1 = v1.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v1) : v1;
                    String p2 = v2.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v2) : v2;
                    return !p1.startsWith(p2);
                };
            }
            LogUtils.warn("Wrong value format found at !startsWith requirement.");
            return EmptyRequirement.instance;
        });
    }

    private void registerEndWithRequirement() {
        this.registerRequirement("endsWith", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String v1 = section.getString("value1", "");
                String v2 = section.getString("value2", "");
                return condition -> {
                    String p1 = v1.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v1) : v1;
                    String p2 = v2.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v2) : v2;
                    return p1.endsWith(p2);
                };
            }
            LogUtils.warn("Wrong value format found at endsWith requirement.");
            return EmptyRequirement.instance;
        });
        this.registerRequirement("!endsWith", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String v1 = section.getString("value1", "");
                String v2 = section.getString("value2", "");
                return condition -> {
                    String p1 = v1.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v1) : v1;
                    String p2 = v2.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v2) : v2;
                    return !p1.endsWith(p2);
                };
            }
            LogUtils.warn("Wrong value format found at !endsWith requirement.");
            return EmptyRequirement.instance;
        });
    }

    private void registerContainRequirement() {
        this.registerRequirement("contains", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String v1 = section.getString("value1", "");
                String v2 = section.getString("value2", "");
                return condition -> {
                    String p1 = v1.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v1) : v1;
                    String p2 = v2.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v2) : v2;
                    return p1.contains(p2);
                };
            }
            LogUtils.warn("Wrong value format found at contains requirement.");
            return EmptyRequirement.instance;
        });
        this.registerRequirement("!contains", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String v1 = section.getString("value1", "");
                String v2 = section.getString("value2", "");
                return condition -> {
                    String p1 = v1.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v1) : v1;
                    String p2 = v2.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v2) : v2;
                    return !p1.contains(p2);
                };
            }
            LogUtils.warn("Wrong value format found at !contains requirement.");
            return EmptyRequirement.instance;
        });
    }

    private void registerEqualsRequirement() {
        this.registerRequirement("equals", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String v1 = section.getString("value1", "");
                String v2 = section.getString("value2", "");
                return condition -> {
                    String p1 = v1.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v1) : v1;
                    String p2 = v2.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v2) : v2;
                    return p1.equals(p2);
                };
            }
            LogUtils.warn("Wrong value format found at equals requirement.");
            return EmptyRequirement.instance;
        });
        this.registerRequirement("!equals", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String v1 = section.getString("value1", "");
                String v2 = section.getString("value2", "");
                return condition -> {
                    String p1 = v1.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v1) : v1;
                    String p2 = v2.startsWith("%") ? PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)v2) : v2;
                    return !p1.equals(p2);
                };
            }
            LogUtils.warn("Wrong value format found at !equals requirement.");
            return EmptyRequirement.instance;
        });
    }

    private void registerPapiRequirement() {
        this.registerRequirement("papi-condition", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                return new PapiCondition(section.getValues(false));
            }
            LogUtils.warn("Wrong value format found at papi-condition requirement.");
            return EmptyRequirement.instance;
        });
    }

    private void registerEnvironmentRequirement() {
        this.registerRequirement("environment", args -> {
            ArrayList<String> environments = ConfigUtils.stringListArgs(args);
            return condition -> {
                String name = condition.getOfflinePlayer().getPlayer().getWorld().getEnvironment().name().toLowerCase(Locale.ENGLISH);
                return environments.contains(name);
            };
        });
        this.registerRequirement("!environment", args -> {
            ArrayList<String> environments = ConfigUtils.stringListArgs(args);
            return condition -> {
                String name = condition.getOfflinePlayer().getPlayer().getWorld().getEnvironment().name().toLowerCase(Locale.ENGLISH);
                return !environments.contains(name);
            };
        });
    }

    private void registerGameModeRequirement() {
        this.registerRequirement("gamemode", args -> {
            ArrayList<String> modes = ConfigUtils.stringListArgs(args);
            return condition -> {
                String name = condition.getOfflinePlayer().getPlayer().getGameMode().name().toLowerCase(Locale.ENGLISH);
                return modes.contains(name);
            };
        });
        this.registerRequirement("!gamemode", args -> {
            ArrayList<String> modes = ConfigUtils.stringListArgs(args);
            return condition -> {
                String name = condition.getOfflinePlayer().getPlayer().getGameMode().name().toLowerCase(Locale.ENGLISH);
                return !modes.contains(name);
            };
        });
    }

    private void registerPotionEffectRequirement() {
        this.registerRequirement("potion-effect", args -> {
            String potions = (String)args;
            String[] split = potions.split("(<=|>=|<|>|==)", 2);
            PotionEffectType type = PotionEffectType.getByName((String)split[0]);
            if (type == null) {
                LogUtils.warn("Potion effect doesn't exist: " + split[0]);
                return EmptyRequirement.instance;
            }
            int required = Integer.parseInt(split[1]);
            String operator = potions.substring(split[0].length(), potions.length() - split[1].length());
            return condition -> {
                int level = -1;
                PotionEffect potionEffect = Objects.requireNonNull(condition.getOfflinePlayer().getPlayer()).getPotionEffect(type);
                if (potionEffect != null) {
                    level = potionEffect.getAmplifier();
                }
                boolean result = false;
                switch (operator) {
                    case ">=": {
                        if (level < required) break;
                        result = true;
                        break;
                    }
                    case ">": {
                        if (level <= required) break;
                        result = true;
                        break;
                    }
                    case "==": {
                        if (level != required) break;
                        result = true;
                        break;
                    }
                    case "!=": {
                        if (level == required) break;
                        result = true;
                        break;
                    }
                    case "<=": {
                        if (level > required) break;
                        result = true;
                        break;
                    }
                    case "<": {
                        if (level >= required) break;
                        result = true;
                    }
                }
                return result;
            };
        });
    }

    private void registerInListRequirement() {
        this.registerRequirement("in-list", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String papi = section.getString("papi", "");
                ArrayList<String> values = ConfigUtils.stringListArgs(section.get("values"));
                return condition -> {
                    String p1 = PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)papi);
                    return values.contains(p1);
                };
            }
            LogUtils.warn("Wrong value format found at in-list requirement.");
            return EmptyRequirement.instance;
        });
        this.registerRequirement("!in-list", args -> {
            if (args instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)args;
                String papi = section.getString("papi", "");
                ArrayList<String> values = ConfigUtils.stringListArgs(section.get("values"));
                return condition -> {
                    String p1 = PlaceholderAPI.setPlaceholders((OfflinePlayer)condition.getOfflinePlayer(), (String)papi);
                    return !values.contains(p1);
                };
            }
            LogUtils.warn("Wrong value format found at in-list requirement.");
            return EmptyRequirement.instance;
        });
    }

    private void loadExpansions() {
        File expansionFolder = new File(this.plugin.getDataFolder(), "expansions/requirement");
        if (!expansionFolder.exists()) {
            expansionFolder.mkdirs();
        }
        ArrayList<Class<RequirementExpansion>> classes = new ArrayList<Class<RequirementExpansion>>();
        File[] expansionJars = expansionFolder.listFiles();
        if (expansionJars == null) {
            return;
        }
        for (File expansionJar : expansionJars) {
            if (!expansionJar.getName().endsWith(".jar")) continue;
            try {
                Class<RequirementExpansion> expansionClass = ClassUtils.findClass(expansionJar, RequirementExpansion.class);
                classes.add(expansionClass);
            }
            catch (IOException | ClassNotFoundException e) {
                LogUtils.warn("Failed to load expansion: " + expansionJar.getName(), e);
            }
        }
        try {
            for (Class clazz : classes) {
                RequirementExpansion expansion = (RequirementExpansion)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.unregisterRequirement(expansion.getRequirementType());
                this.registerRequirement(expansion.getRequirementType(), expansion.getRequirementFactory());
                LogUtils.info("Loaded requirement expansion: " + expansion.getRequirementType() + "[" + expansion.getVersion() + "] by " + expansion.getAuthor());
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LogUtils.warn("Error occurred when creating expansion instance.", e);
        }
    }
}

