/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.mechanic.requirement.papi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.momirealms.customnameplates.api.requirement.Condition;
import net.momirealms.customnameplates.api.requirement.Requirement;
import net.momirealms.customnameplates.paper.mechanic.requirement.papi.ExpressionAnd;
import net.momirealms.customnameplates.paper.mechanic.requirement.papi.ExpressionOr;
import net.momirealms.customnameplates.paper.mechanic.requirement.papi.PapiEquals;
import net.momirealms.customnameplates.paper.mechanic.requirement.papi.PapiGreater;
import net.momirealms.customnameplates.paper.mechanic.requirement.papi.PapiNoLarger;
import net.momirealms.customnameplates.paper.mechanic.requirement.papi.PapiNoLess;
import net.momirealms.customnameplates.paper.mechanic.requirement.papi.PapiNotEquals;
import net.momirealms.customnameplates.paper.mechanic.requirement.papi.PapiRegex;
import net.momirealms.customnameplates.paper.mechanic.requirement.papi.PapiRequirement;
import net.momirealms.customnameplates.paper.mechanic.requirement.papi.PapiSmaller;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.MemorySection;

public class PapiCondition
implements Requirement {
    private final List<PapiRequirement> papiRequirement;

    public PapiCondition(Map<String, Object> expressions) {
        this.papiRequirement = this.getRequirements(expressions);
    }

    @Override
    public boolean isConditionMet(Condition condition) {
        OfflinePlayer player = condition.getOfflinePlayer();
        for (PapiRequirement requirement : this.papiRequirement) {
            if (requirement.isMet(player)) continue;
            return false;
        }
        return true;
    }

    private List<PapiRequirement> getRequirements(Map<String, Object> map) {
        ArrayList<PapiRequirement> papiRequirements = new ArrayList<PapiRequirement>();
        map.keySet().forEach(key -> {
            if (key.startsWith("&&")) {
                Object patt1918$temp = map.get(key);
                if (patt1918$temp instanceof MemorySection) {
                    MemorySection map2 = (MemorySection)patt1918$temp;
                    papiRequirements.add(new ExpressionAnd(this.getRequirements(map2.getValues(false))));
                }
            } else if (key.startsWith("||")) {
                Object patt2154$temp = map.get(key);
                if (patt2154$temp instanceof MemorySection) {
                    MemorySection map2 = (MemorySection)patt2154$temp;
                    papiRequirements.add(new ExpressionOr(this.getRequirements(map2.getValues(false))));
                }
            } else {
                Object patt2363$temp = map.get(key);
                if (patt2363$temp instanceof MemorySection) {
                    MemorySection map2 = (MemorySection)patt2363$temp;
                    String type = map2.getString("type");
                    String papi = map2.getString("papi");
                    String value = map2.getString("value");
                    if (value == null || papi == null || type == null) {
                        return;
                    }
                    switch (type) {
                        case "==": {
                            papiRequirements.add(new PapiEquals(papi, value));
                            break;
                        }
                        case "!=": {
                            papiRequirements.add(new PapiNotEquals(papi, value));
                            break;
                        }
                        case ">=": {
                            papiRequirements.add(new PapiNoLess(papi, value));
                            break;
                        }
                        case "<=": {
                            papiRequirements.add(new PapiNoLarger(papi, value));
                            break;
                        }
                        case "<": {
                            papiRequirements.add(new PapiSmaller(papi, value));
                            break;
                        }
                        case ">": {
                            papiRequirements.add(new PapiGreater(papi, value));
                            break;
                        }
                        case "regex": {
                            papiRequirements.add(new PapiRegex(papi, value));
                        }
                    }
                }
            }
        });
        return papiRequirements;
    }
}

