/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.scheduler;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.momirealms.customnameplates.api.scheduler.CancellableTask;
import net.momirealms.customnameplates.api.scheduler.Scheduler;
import net.momirealms.customnameplates.paper.CustomNameplatesPluginImpl;
import net.momirealms.customnameplates.paper.scheduler.BukkitSchedulerImpl;
import net.momirealms.customnameplates.paper.scheduler.FoliaSchedulerImpl;
import net.momirealms.customnameplates.paper.scheduler.SyncScheduler;
import net.momirealms.customnameplates.paper.setting.CNConfig;
import org.bukkit.Location;

public class SchedulerImpl
implements Scheduler {
    private final SyncScheduler syncScheduler;
    private final ScheduledThreadPoolExecutor schedule;
    private final CustomNameplatesPluginImpl plugin;

    public SchedulerImpl(CustomNameplatesPluginImpl plugin) {
        this.plugin = plugin;
        this.syncScheduler = plugin.getVersionManager().isFolia() ? new FoliaSchedulerImpl(plugin) : new BukkitSchedulerImpl(plugin);
        this.schedule = new ScheduledThreadPoolExecutor(1);
        this.schedule.setMaximumPoolSize(1);
        this.schedule.setKeepAliveTime(30L, TimeUnit.SECONDS);
        this.schedule.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    public void reload() {
        try {
            this.schedule.setMaximumPoolSize(CNConfig.maximumPoolSize);
            this.schedule.setCorePoolSize(CNConfig.corePoolSize);
            this.schedule.setKeepAliveTime(CNConfig.keepAliveTime, TimeUnit.SECONDS);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().severe("Failed to create thread pool. Please lower the corePoolSize in config.yml.");
        }
    }

    public void shutdown() {
        if (this.schedule != null && !this.schedule.isShutdown()) {
            this.schedule.shutdown();
        }
    }

    @Override
    public void runTaskSync(Runnable runnable, Location location) {
        this.syncScheduler.runSyncTask(runnable, location);
    }

    @Override
    public void runTaskAsync(Runnable runnable) {
        this.schedule.execute(runnable);
    }

    @Override
    public CancellableTask runTaskSyncTimer(Runnable runnable, Location location, long delayTicks, long periodTicks) {
        return this.syncScheduler.runTaskSyncTimer(runnable, location, delayTicks, periodTicks);
    }

    @Override
    public CancellableTask runTaskAsyncLater(Runnable runnable, long delay, TimeUnit timeUnit) {
        return new ScheduledTask(this.schedule.schedule(runnable, delay, timeUnit));
    }

    @Override
    public CancellableTask runTaskSyncLater(Runnable runnable, Location location, long delay, TimeUnit timeUnit) {
        return new ScheduledTask(this.schedule.schedule(() -> this.runTaskSync(runnable, location), delay, timeUnit));
    }

    @Override
    public CancellableTask runTaskSyncLater(Runnable runnable, Location location, long delayTicks) {
        return this.syncScheduler.runTaskSyncLater(runnable, location, delayTicks);
    }

    @Override
    public CancellableTask runTaskAsyncTimer(Runnable runnable, long delay, long period, TimeUnit timeUnit) {
        return new ScheduledTask(this.schedule.scheduleAtFixedRate(runnable, delay, period, timeUnit));
    }

    public static class ScheduledTask
    implements CancellableTask {
        private final ScheduledFuture<?> scheduledFuture;

        public ScheduledTask(ScheduledFuture<?> scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        @Override
        public void cancel() {
            this.scheduledFuture.cancel(false);
        }

        @Override
        public boolean isCancelled() {
            return this.scheduledFuture.isCancelled();
        }
    }
}

