/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.storage.method.database.nosql;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.UpdateResult;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.momirealms.customnameplates.api.data.PlayerData;
import net.momirealms.customnameplates.api.data.StorageType;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.paper.CustomNameplatesPluginImpl;
import net.momirealms.customnameplates.paper.storage.method.AbstractStorage;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class MongoDBImpl
extends AbstractStorage {
    private MongoClient mongoClient;
    private MongoDatabase database;
    private String collectionPrefix;

    public MongoDBImpl(CustomNameplatesPluginImpl plugin) {
        super(plugin);
    }

    @Override
    public void initialize() {
        YamlConfiguration config = this.plugin.getConfig("database.yml");
        ConfigurationSection section = config.getConfigurationSection("MongoDB");
        if (section == null) {
            LogUtils.warn("Failed to load database config. It seems that your config is broken. Please regenerate a new one.");
            return;
        }
        this.collectionPrefix = section.getString("collection-prefix", "nameplates");
        MongoClientSettings.Builder settings = MongoClientSettings.builder().uuidRepresentation(UuidRepresentation.STANDARD);
        if (!section.getString("connection-uri", "").equals("")) {
            settings.applyConnectionString(new ConnectionString(section.getString("connection-uri", "")));
            this.mongoClient = MongoClients.create((MongoClientSettings)settings.build());
            return;
        }
        if (section.contains("user")) {
            MongoCredential credential = MongoCredential.createCredential((String)section.getString("user", "root"), (String)section.getString("database", "minecraft"), (char[])section.getString("password", "password").toCharArray());
            settings.credential(credential);
        }
        settings.applyToClusterSettings(builder -> builder.hosts(Collections.singletonList(new ServerAddress(section.getString("host", "localhost"), section.getInt("port", 27017)))));
        this.mongoClient = MongoClients.create((MongoClientSettings)settings.build());
        this.database = this.mongoClient.getDatabase(section.getString("database", "minecraft"));
    }

    @Override
    public void disable() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    @Override
    public CompletableFuture<Boolean> updatePlayerData(UUID uuid, PlayerData playerData) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.plugin.getScheduler().runTaskAsync(() -> {
            MongoCollection collection = this.database.getCollection(this.getCollectionName("data"));
            try {
                Document query = new Document("uuid", (Object)uuid);
                Bson updates = Updates.combine((Bson[])new Bson[]{Updates.set((String)"data", (Object)new Binary(this.plugin.getStorageManager().toBytes(playerData)))});
                UpdateOptions options = new UpdateOptions().upsert(true);
                UpdateResult result = collection.updateOne((Bson)query, updates, options);
                future.complete(result.wasAcknowledged());
            }
            catch (MongoException e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Optional<PlayerData>> getPlayerData(UUID uuid) {
        CompletableFuture<Optional<PlayerData>> future = new CompletableFuture<Optional<PlayerData>>();
        this.plugin.getScheduler().runTaskAsync(() -> {
            MongoCollection collection = this.database.getCollection(this.getCollectionName("data"));
            Document doc = (Document)collection.find(Filters.eq((String)"uuid", (Object)uuid)).first();
            if (doc == null) {
                future.complete(Optional.empty());
            } else if (Bukkit.getPlayer((UUID)uuid) != null) {
                Binary binary = (Binary)doc.get((Object)"data");
                future.complete(Optional.of(this.plugin.getStorageManager().fromBytes(binary.getData())));
            } else {
                future.complete(Optional.empty());
            }
        });
        return future;
    }

    @Override
    public Set<UUID> getUniqueUsers(boolean legacy) {
        HashSet<UUID> uuids = new HashSet<UUID>();
        MongoCollection collection = this.database.getCollection(this.getCollectionName("data"));
        try {
            Bson projectionFields = Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{"uuid"})});
            try (MongoCursor cursor = collection.find().projection(projectionFields).iterator();){
                while (cursor.hasNext()) {
                    uuids.add((UUID)((Document)cursor.next()).get((Object)"uuid", UUID.class));
                }
            }
        }
        catch (MongoException e) {
            LogUtils.warn("Failed to get unique data.", e);
        }
        return uuids;
    }

    public String getCollectionName(String value) {
        return this.getCollectionPrefix() + "_" + value;
    }

    public String getCollectionPrefix() {
        return this.collectionPrefix;
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.MongoDB;
    }
}

