/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.storage.method.database.sql;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.data.PlayerData;
import net.momirealms.customnameplates.api.util.LogUtils;
import net.momirealms.customnameplates.paper.storage.method.AbstractStorage;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSQLDatabase
extends AbstractStorage {
    protected String tablePrefix;

    public AbstractSQLDatabase(CustomNameplatesPlugin plugin) {
        super(plugin);
    }

    public abstract Connection getConnection() throws SQLException;

    public void createTableIfNotExist() {
        try (Connection connection = this.getConnection();){
            String[] databaseSchema = this.getSchema(this.getStorageType().name().toLowerCase(Locale.ENGLISH));
            try (Statement statement = connection.createStatement();){
                for (String tableCreationStatement : databaseSchema) {
                    statement.execute(tableCreationStatement);
                }
            }
            catch (SQLException e) {
                LogUtils.warn("Failed to create tables");
            }
        }
        catch (SQLException e) {
            LogUtils.warn("Failed to get sql connection");
        }
        catch (IOException e) {
            LogUtils.warn("Failed to get schema resource");
        }
    }

    @Override
    public CompletableFuture<Boolean> updateOrInsertPlayerData(UUID uuid, PlayerData playerData) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.plugin.getScheduler().runTaskAsync(() -> {
            try (Connection connection = this.getConnection();
                 PreparedStatement statement = connection.prepareStatement(String.format("SELECT * FROM `%s` WHERE `uuid` = ?", this.getTableName("data")));){
                statement.setString(1, uuid.toString());
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    this.updatePlayerData(uuid, playerData).thenRun(() -> future.complete(true));
                } else {
                    this.insertPlayerData(uuid, playerData);
                    future.complete(true);
                }
            }
            catch (SQLException e) {
                LogUtils.warn("Failed to update " + uuid + "'s data.", e);
            }
        });
        return future;
    }

    private String[] getSchema(@NotNull String fileName) throws IOException {
        return this.replaceSchemaPlaceholder(new String(Objects.requireNonNull(this.plugin.getResource("schema/" + fileName + ".sql")).readAllBytes(), StandardCharsets.UTF_8)).split(";");
    }

    private String replaceSchemaPlaceholder(@NotNull String sql) {
        return sql.replace("{prefix}", this.tablePrefix);
    }

    public String getTableName(String sub) {
        return this.getTablePrefix() + "_" + sub;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    @Override
    public CompletableFuture<Boolean> updatePlayerData(UUID uuid, PlayerData playerData) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.plugin.getScheduler().runTaskAsync(() -> {
            try (Connection connection = this.getConnection();
                 PreparedStatement statement = connection.prepareStatement(String.format("UPDATE `%s` SET `data` = ? WHERE `uuid` = ?", this.getTableName("data")));){
                statement.setBlob(1, new ByteArrayInputStream(this.plugin.getStorageManager().toBytes(playerData)));
                statement.setString(2, uuid.toString());
                statement.executeUpdate();
                future.complete(true);
            }
            catch (SQLException e) {
                LogUtils.warn("Failed to update " + uuid + "'s data.", e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Optional<PlayerData>> getPlayerData(UUID uuid) {
        CompletableFuture<Optional<PlayerData>> future = new CompletableFuture<Optional<PlayerData>>();
        this.plugin.getScheduler().runTaskAsync(() -> {
            try (Connection connection = this.getConnection();
                 PreparedStatement statement = connection.prepareStatement(String.format("SELECT * FROM `%s` WHERE `uuid` = ?", this.getTableName("data")));){
                statement.setString(1, uuid.toString());
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    Blob blob = rs.getBlob("data");
                    byte[] dataByteArray = blob.getBytes(1L, (int)blob.length());
                    blob.free();
                    future.complete(Optional.of(this.plugin.getStorageManager().fromBytes(dataByteArray)));
                } else if (Bukkit.getPlayer((UUID)uuid) != null) {
                    PlayerData data = PlayerData.empty();
                    this.insertPlayerData(uuid, data);
                    future.complete(Optional.of(data));
                } else {
                    future.complete(Optional.empty());
                }
            }
            catch (SQLException e) {
                LogUtils.warn("Failed to get " + uuid + "'s data.", e);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public void insertPlayerData(UUID uuid, PlayerData playerData) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(String.format("INSERT INTO `%s`(`uuid`, `data`) VALUES(?, ?)", this.getTableName("data")));){
            statement.setString(1, uuid.toString());
            statement.setBlob(2, new ByteArrayInputStream(this.plugin.getStorageManager().toBytes(playerData)));
            statement.execute();
        }
        catch (SQLException e) {
            LogUtils.warn("Failed to insert " + uuid + "'s data.", e);
        }
    }

    @Override
    public Set<UUID> getUniqueUsers(boolean legacy) {
        HashSet<UUID> uuids = new HashSet<UUID>();
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(String.format("SELECT uuid FROM `%s`", legacy ? this.getTableName("fishingbag") : this.getTableName("data")));
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                UUID uuid = UUID.fromString(rs.getString("uuid"));
                uuids.add(uuid);
            }
        }
        catch (SQLException e) {
            LogUtils.warn("Failed to get unique data.", e);
        }
        return uuids;
    }

    public static class SqlConstants {
        public static final String SQL_SELECT_BY_UUID = "SELECT * FROM `%s` WHERE `uuid` = ?";
        public static final String SQL_SELECT_ALL_UUID = "SELECT uuid FROM `%s`";
        public static final String SQL_UPDATE_BY_UUID = "UPDATE `%s` SET `data` = ? WHERE `uuid` = ?";
        public static final String SQL_INSERT_DATA_BY_UUID = "INSERT INTO `%s`(`uuid`, `data`) VALUES(?, ?)";
    }
}

