/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.storage.method.database.sql;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import net.momirealms.customnameplates.api.CustomNameplatesPlugin;
import net.momirealms.customnameplates.api.data.StorageType;
import net.momirealms.customnameplates.paper.storage.method.database.sql.AbstractSQLDatabase;
import org.bukkit.configuration.file.YamlConfiguration;
import org.h2.jdbcx.JdbcConnectionPool;

public class H2Impl
extends AbstractSQLDatabase {
    private JdbcConnectionPool connectionPool;

    public H2Impl(CustomNameplatesPlugin plugin) {
        super(plugin);
    }

    @Override
    public void initialize() {
        YamlConfiguration config = this.plugin.getConfig("database.yml");
        File databaseFile = new File(this.plugin.getDataFolder(), config.getString("H2.file", "data.db"));
        this.tablePrefix = config.getString("H2.table-prefix", "customnameplates");
        String url = String.format("jdbc:h2:%s", databaseFile.getAbsolutePath());
        this.connectionPool = JdbcConnectionPool.create((String)url, (String)"sa", (String)"");
        super.createTableIfNotExist();
    }

    @Override
    public void disable() {
        if (this.connectionPool != null) {
            this.connectionPool.dispose();
        }
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.H2;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connectionPool.getConnection();
    }
}

