/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.customnameplates.paper.util;

import com.comphenix.protocol.utility.MinecraftReflection;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.momirealms.customnameplates.api.util.LogUtils;

public class ReflectionUtils {
    private static Object removeBossBarPacket;
    private static Constructor<?> progressConstructor;
    private static Constructor<?> updateConstructor;
    private static Method iChatComponentMethod;
    private static Object emptyComponent;
    private static Method serializeComponentMethod;
    private static Method keyAsStringMethod;
    private static Method keyFromStringMethod;
    private static Object miniMessageInstance;
    private static Class<?> keyClass;

    private ReflectionUtils() {
    }

    public static void load() {
        try {
            Class<?> bar = Class.forName("net.minecraft.network.protocol.game.PacketPlayOutBoss");
            Field remove = bar.getDeclaredField("f");
            remove.setAccessible(true);
            removeBossBarPacket = remove.get(null);
            Class<?> packetBossClassF = Class.forName("net.minecraft.network.protocol.game.PacketPlayOutBoss$f");
            progressConstructor = packetBossClassF.getDeclaredConstructor(Float.TYPE);
            progressConstructor.setAccessible(true);
            Class<?> packetBossClassE = Class.forName("net.minecraft.network.protocol.game.PacketPlayOutBoss$e");
            updateConstructor = packetBossClassE.getDeclaredConstructor(MinecraftReflection.getIChatBaseComponentClass());
            updateConstructor.setAccessible(true);
            iChatComponentMethod = MinecraftReflection.getChatSerializerClass().getMethod("a", String.class);
            iChatComponentMethod.setAccessible(true);
            emptyComponent = iChatComponentMethod.invoke(null, "{\"text\":\"\"}");
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException exception) {
            LogUtils.severe("Error occurred when loading reflections", exception);
            exception.printStackTrace();
        }
        try {
            Class<?> componentClass = Class.forName("net;kyori;adventure;text;Component".replace(";", "."));
            Class<?> miniMessageClass = Class.forName("net;kyori;adventure;text;minimessage;MiniMessage".replace(";", "."));
            Method miniMessageInstanceGetMethod = miniMessageClass.getMethod("miniMessage", new Class[0]);
            miniMessageInstance = miniMessageInstanceGetMethod.invoke(null, new Object[0]);
            serializeComponentMethod = miniMessageClass.getMethod("serialize", componentClass);
            keyClass = Class.forName("net;kyori;adventure;key;Key".replace(";", "."));
            keyAsStringMethod = keyClass.getMethod("asString", new Class[0]);
            keyFromStringMethod = keyClass.getMethod("key", String.class);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    public static Object getRemoveBossBarPacket() {
        return removeBossBarPacket;
    }

    public static Constructor<?> getProgressConstructor() {
        return progressConstructor;
    }

    public static Constructor<?> getUpdateConstructor() {
        return updateConstructor;
    }

    public static Method getiChatComponentMethod() {
        return iChatComponentMethod;
    }

    public static Object getEmptyComponent() {
        return emptyComponent;
    }

    public static Class<?> getKeyClass() {
        return keyClass;
    }

    public static String getKeyAsString(Object key) {
        try {
            return (String)keyAsStringMethod.invoke(key, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Object getKerFromString(String key) {
        try {
            return keyFromStringMethod.invoke((Object)key, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMiniMessageTextFromNonShadedComponent(Object component) {
        try {
            return (String)serializeComponentMethod.invoke(miniMessageInstance, component);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return "";
        }
    }
}

