/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.api.event;

import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;

public class ShopEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled;
    private final Player buyer;
    private final int page;
    private final int row;
    private final int column;
    private final ItemStack item;

    public ShopEvent(Player buyer, int page, int row, int column, ItemStack item) {
        this.buyer = buyer;
        this.page = page;
        this.row = row;
        this.column = column;
        this.item = item;
    }

    public Player getPlayer() {
        return this.buyer;
    }

    public int getPage() {
        return this.page;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public int getNum() {
        return (this.page - 1) * 36 + (this.row - 1) * 9 + (this.column - 1);
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }
}

