/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.arenas;

import com.valorin.arenas.Arena;
import com.valorin.data.Data;
import java.util.ArrayList;
import java.util.List;

public class ArenaManager {
    public static List<Arena> arenas = new ArrayList<Arena>();
    public static List<String> busyArenasName = new ArrayList<String>();

    public ArenaManager() {
        if (Data.getArenas().isEmpty()) {
            return;
        }
        for (String arena : Data.getArenas()) {
            arenas.add(new Arena(arena));
        }
    }

    public Arena getArena(String name) {
        if (name == null) {
            return null;
        }
        if (arenas.isEmpty()) {
            return null;
        }
        for (Arena arena : arenas) {
            if (!arena.getName().equals(name)) continue;
            return arena;
        }
        return null;
    }

    public void addArena(String name) {
        arenas.add(new Arena(name));
    }

    public void removeArena(String name) {
        arenas.remove(this.getArena(name));
    }

    public String getPlayerOfArena(String pn) {
        if (arenas.isEmpty()) {
            return null;
        }
        for (Arena arena : arenas) {
            if (!arena.getEnable() || !arena.getp1().equals(pn) && !arena.getp2().equals(pn)) continue;
            return arena.getName();
        }
        return null;
    }

    public String getWatcherOfArena(String pn) {
        if (arenas.isEmpty()) {
            return null;
        }
        for (Arena arena : arenas) {
            if (!arena.getEnable() || !arena.getWatchers().contains(pn)) continue;
            return arena.getName();
        }
        return null;
    }

    public String getTheOtherPlayer(String pn) {
        String arenaName = this.getPlayerOfArena(pn);
        if (arenaName != null) {
            Arena arena = this.getArena(arenaName);
            if (arena.getp1().equals(pn)) {
                return arena.getp2();
            }
            return arena.getp1();
        }
        return null;
    }

    public boolean isContainPlayer(String arenaName, String pn) {
        if (this.getArena(arenaName) == null) {
            return false;
        }
        if (this.getArena(arenaName).getEnable()) {
            return this.getArena(arenaName).getp1().equals(pn) || this.getArena(arenaName).getp2().equals(pn);
        }
        return false;
    }

    public boolean isPlayerBusy(String pn) {
        if (arenas.isEmpty()) {
            return false;
        }
        for (Arena arena : arenas) {
            if (!this.isContainPlayer(arena.getName(), pn)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return arenas.size();
    }
}

