/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.caches;

import com.valorin.Main;
import com.valorin.dan.DanHandler;
import com.valorin.data.Data;
import com.valorin.util.Debug;
import com.valorin.util.ViaVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DanCache {
    private final Map<String, Integer> map = new HashMap<String, Integer>();

    public DanCache() {
        try {
            for (Player player : ViaVersion.getOnlinePlayers()) {
                this.load(player.getName());
            }
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                this.load(player.getName());
            }
            Debug.send("\u6bb5\u4f4d\u7ecf\u9a8c\u6570\u636e\u7f13\u5b58\u5df2\u5c31\u7eea", "The Dan Exp cache has been initialized");
        }
        catch (Exception e) {
            Debug.send("\u00a7c\u6bb5\u4f4d\u7ecf\u9a8c\u6570\u636e\u7f13\u5b58\u672a\u80fd\u52a0\u8f7d", "\u00a7cThe Dan Exp cache failed to initialize");
            e.printStackTrace();
        }
    }

    public int get(String name) {
        try {
            return this.map.get(name);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public void load(String name) {
        if (!this.map.containsKey(name)) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getInstance(), () -> {
                int exp = Data.getDanExp(name);
                this.map.put(name, exp);
                DanHandler danHandler = Main.getInstance().getDanHandler();
                if (danHandler != null) {
                    danHandler.refreshPlayerDan(name);
                }
            });
        }
    }

    public void set(String name, int exp) {
        this.map.put(name, exp);
        Main.getInstance().getDanHandler().refreshPlayerDan(name);
        Data.setDanExp(name, exp, true);
    }
}

