/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.commands.sub;

import com.valorin.Main;
import com.valorin.caches.ShopCache;
import com.valorin.commands.SubCommand;
import com.valorin.commands.sub.CMDShop_Commands;
import com.valorin.commands.way.InServerCommand;
import com.valorin.configuration.languagefile.MessageSender;
import com.valorin.inventory.INVShop;
import com.valorin.util.ViaVersion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CMDShop
extends SubCommand
implements InServerCommand {
    public CMDShop() {
        super("shop", "s");
    }

    public static int getNum(int page, int row, int column) {
        return (page - 1) * 36 + (row - 1) * 9 + (column - 1);
    }

    public static boolean isOutOfRange(int page, int row, int column, String pageArg, String rowArg, String columnArg, Player p) {
        boolean result = false;
        page = Integer.parseInt(pageArg);
        if (page > INVShop.getMaxPage() || page == 0) {
            MessageSender.sm("&c[x]\u9875\u7801\u8d85\u51fa\u503c\u57df\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5b58\u5728\u6b64\u9875", p);
            result = true;
        }
        if ((row = Integer.parseInt(rowArg)) > 4 || row == 0) {
            MessageSender.sm("&c[x]\u884c\u6570\u8d85\u51fa\u503c\u57df\uff0c\u8bf7\u8f93\u51651~4", p);
            result = true;
        }
        if ((column = Integer.parseInt(columnArg)) > 9 || column == 0) {
            MessageSender.sm("&c[x]\u5217\u6570\u8d85\u51fa\u503c\u57df\uff0c\u8bf7\u8f93\u51651~9", p);
            result = true;
        }
        return result;
    }

    public static boolean isInt(String ... nl) {
        boolean result = true;
        for (String n : nl) {
            Pattern pattern = Pattern.compile("[0-9]+");
            Matcher matcher = pattern.matcher(n);
            if (matcher.matches()) continue;
            result = false;
        }
        return result;
    }

    public void sendHelp(Player p) {
        MessageSender.sm("", p);
        MessageSender.sm("&3&lDan&b&l&oTiao &f&l>> &a\u7ba1\u7406\u5458\u5e2e\u52a9\uff1a\u5546\u57ce\u64cd\u4f5c", p, false);
        MessageSender.sm("&b/dt shop(s) add <\u4ef7\u683c> &f- &a\u4e0a\u67b6\u624b\u4e2d\u7684\u7269\u54c1\u4f5c\u4e3a\u5546\u54c1", p, false);
        MessageSender.sm("&b/dt shop(s) remove <\u9875\u6570> <\u884c> <\u5217> &f- &a\u4e0b\u67b6\u67d0\u4e2a\u5546\u54c1", p, false);
        MessageSender.sm("&b/dt shop(s) des <\u9875\u6570> <\u884c> <\u5217> <\u5185\u5bb9>&f- &a\u4e3a\u5df2\u6709\u5546\u54c1\u6dfb\u52a0\u5907\u6ce8\uff0c\u652f\u6301\u989c\u8272\u4ee3\u7801", p, false);
        MessageSender.sm("&b/dt shop(s) rdes <\u9875\u6570> <\u884c> <\u5217> &f- &a\u5220\u9664\u5546\u54c1\u5907\u6ce8", p, false);
        MessageSender.sm("&b/dt shop(s) bc <\u9875\u6570> <\u884c> <\u5217> <\u5185\u5bb9> &f- &a\u8bbe\u7f6e\u73a9\u5bb6\u8d2d\u4e70\u6210\u529f\u540e\u53d1\u9001\u7684\u5168\u670d\u516c\u544a\uff0c\u652f\u6301\u989c\u8272\u4ee3\u7801\uff0c\u4ee5{player}\u4ee3\u8868\u73a9\u5bb6\u540d", p, false);
        MessageSender.sm("&b/dt shop(s) rbc <\u9875\u6570> <\u884c> <\u5217> &f- &a\u5220\u9664\u8d2d\u4e70\u6210\u529f\u540e\u53d1\u9001\u7684\u5168\u670d\u516c\u544a", p, false);
        MessageSender.sm("&b/dt shop(s) dan <\u9875\u6570> <\u884c> <\u5217> <\u6bb5\u4f4d\u7684\u7f16\u8f91\u540d> &f- &a\u4e3a\u5df2\u6709\u5546\u54c1\u8bbe\u7f6e\u8d2d\u4e70\u7684\u6bb5\u4f4d\u9650\u5236", p, false);
        MessageSender.sm("&b/dt shop(s) rdan <\u9875\u6570> <\u884c> <\u5217> &f- &a\u53d6\u6d88\u6bb5\u4f4d\u9650\u5236", p, false);
        MessageSender.sm("&b/dt shop(s) commands add <\u9875\u6570> <\u884c> <\u5217> <\u6267\u884c\u65b9\u5f0f(player/op/console)> <\u5185\u5bb9> &f- &a\u6dfb\u52a0\u4e00\u6761\u8d2d\u4e70\u540e\u6267\u884c\u7684\u6307\u4ee4", p);
        MessageSender.sm("&b/dt shop(s) commands clear <\u9875\u6570> <\u884c> <\u5217> &f- &a\u6e05\u7a7a\u6240\u6709\u5df2\u6dfb\u52a0\u7684\u6307\u4ee4", p);
        MessageSender.sm("&b/dt shop(s) commands list <\u9875\u6570> <\u884c> <\u5217> &f- &a\u67e5\u770b\u6240\u6709\u5df2\u6dfb\u52a0\u7684\u6307\u4ee4", p);
        MessageSender.sm("", p);
    }

    public Integer[] getLocation(int num) {
        int column;
        int row;
        int page = num % 36 != 0 ? num / 36 + 1 : num / 36;
        if ((num - (page - 1)) % 9 != 0) {
            row = (num - (page - 1)) / 9 + 1;
            column = num - page * 36 - row * 9 + 1;
        } else {
            row = (num - (page - 1)) / 9;
            column = 9;
        }
        return new Integer[]{page, row, column};
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (args.length == 1) {
            Inventory inv = Bukkit.createInventory(null, (int)54, (String)MessageSender.gm("&0&l\u79ef\u5206\u5546\u57ce &9&l[right]", player));
            INVShop.loadInv(player.getName(), inv);
            MessageSender.sm("&a[v]\u6b22\u8fce\u5149\u4e34\u5355\u6311\u79ef\u5206\u5546\u57ce\uff01", player);
            return true;
        }
        if (!player.hasPermission("dt.admin")) {
            MessageSender.sm("&c[x]\u65e0\u6743\u9650\uff01", player);
            return true;
        }
        if (args[1].equalsIgnoreCase("help")) {
            this.sendHelp(player);
            return true;
        }
        if (args[1].equalsIgnoreCase("commands")) {
            return CMDShop_Commands.onCommand(sender, args);
        }
        ShopCache cache = Main.getInstance().getCacheHandler().getShop();
        if (args[1].equalsIgnoreCase("add")) {
            if (args.length != 3) {
                MessageSender.sm("&7\u6b63\u786e\u7528\u6cd5\uff1a/dt s add <\u4ef7\u683c>\uff0c\u6ce8\u610f\u8bf7\u5c06\u8981\u4e0a\u67b6\u7684\u7269\u54c1\u62ff\u5728\u624b\u4e0a", player);
                return true;
            }
            ItemStack now = ViaVersion.getItemInMainHand(player);
            if (now.equals((Object)new ItemStack(Material.AIR))) {
                MessageSender.sm("&c[x]\u8bf7\u5c06\u8981\u4e0a\u67b6\u7684\u7269\u54c1\u62ff\u5728\u624b\u4e2d\uff01", player);
                return true;
            }
            if (!CMDShop.isInt(args[2])) {
                MessageSender.sm("&c[x]\u8bf7\u8f93\u5165\u6709\u6548\u7684\u963f\u62c9\u4f2f\u6570\u5b57\uff01", player);
                return true;
            }
            int price = Integer.parseInt(args[2]);
            if (price <= 0) {
                MessageSender.sm("&c[x]\u8bf7\u8f93\u5165\u5927\u4e8e\u96f6\u7684\u963f\u62c9\u4f2f\u6570\u5b57\uff01", player);
                return true;
            }
            cache.add(ViaVersion.getItemInMainHand(player), price);
            MessageSender.sm("&a[v]\u5546\u54c1\u4e0a\u67b6\u6210\u529f\uff01", player);
            return true;
        }
        if (args[1].equalsIgnoreCase("remove")) {
            int column;
            int row;
            if (args.length != 5) {
                MessageSender.sm("&7\u6b63\u786e\u7528\u6cd5\uff1a/dt s remove <\u9875\u6570> <\u884c> <\u5217>\uff0c\u884c\u548c\u5217\u4e0d\u8003\u8651GUI\u9876\u90e8\u548c\u5e95\u90e8\u7684\u73bb\u7483\u677f", player);
                return true;
            }
            if (!CMDShop.isInt(args[2], args[3], args[4])) {
                MessageSender.sm("&c[x]\u8bf7\u8f93\u5165\u6709\u6548\u7684\u963f\u62c9\u4f2f\u6570\u5b57\uff01", player);
                return true;
            }
            int page = Integer.parseInt(args[2]);
            int index = CMDShop.getNum(page, row = Integer.parseInt(args[3]), column = Integer.parseInt(args[4]));
            if (index >= cache.size()) {
                MessageSender.sm("&c[x]\u4e0d\u5b58\u5728\u8fd9\u4e2a\u5546\u54c1", player);
                return true;
            }
            cache.remove(cache.getNumByIndex(index));
            MessageSender.sm("&a[v]\u5546\u54c1\u4e0b\u67b6\u5b8c\u6bd5\uff01", player);
            return true;
        }
        if (args[1].equalsIgnoreCase("des") || args[1].equalsIgnoreCase("bc") || args[1].equalsIgnoreCase("dan")) {
            int column;
            int row;
            if (args.length != 6) {
                if (args[1].equalsIgnoreCase("des")) {
                    MessageSender.sm("&7\u6b63\u786e\u7528\u6cd5\uff1a/dt s des <\u9875\u6570> <\u884c> <\u5217> <\u5185\u5bb9>\uff0c\u884c\u548c\u5217\u4e0d\u8003\u8651GUI\u9876\u90e8\u548c\u5e95\u90e8\u7684\u73bb\u7483\u677f\uff0c\u652f\u6301\u989c\u8272\u4ee3\u7801", player);
                }
                if (args[1].equalsIgnoreCase("bc")) {
                    MessageSender.sm("&7\u6b63\u786e\u7528\u6cd5\uff1a/dt s bc <\u9875\u6570> <\u884c> <\u5217> <\u5185\u5bb9>\uff0c\u884c\u548c\u5217\u4e0d\u8003\u8651GUI\u9876\u90e8\u548c\u5e95\u90e8\u7684\u73bb\u7483\u677f\uff0c\u652f\u6301\u989c\u8272\u4ee3\u7801\uff0c\u53ef\u4ee5\u7528{player}\u4ee3\u66ff\u73a9\u5bb6\u540d\u79f0", player);
                }
                if (args[1].equalsIgnoreCase("dan")) {
                    MessageSender.sm("&7\u6b63\u786e\u7528\u6cd5\uff1a/dt s dan <\u9875\u6570> <\u884c> <\u5217> <\u6bb5\u4f4d\u7684\u7f16\u8f91\u540d>\uff0c\u884c\u548c\u5217\u4e0d\u8003\u8651GUI\u9876\u90e8\u548c\u5e95\u90e8\u7684\u73bb\u7483\u677f", player);
                }
                return true;
            }
            if (!CMDShop.isInt(args[2], args[3], args[4])) {
                MessageSender.sm("&c[x]\u8bf7\u8f93\u5165\u6709\u6548\u7684\u963f\u62c9\u4f2f\u6570\u5b57\uff01", player);
                return true;
            }
            int page = Integer.parseInt(args[2]);
            if (CMDShop.isOutOfRange(page, row = Integer.parseInt(args[3]), column = Integer.parseInt(args[4]), args[2], args[3], args[4], player)) {
                return true;
            }
            int index = CMDShop.getNum(page, row, column);
            if (index >= cache.size()) {
                MessageSender.sm("&c[x]\u4e0d\u5b58\u5728\u8fd9\u4e2a\u5546\u54c1", player);
                return true;
            }
            if (args[1].equalsIgnoreCase("des")) {
                String description = args[5];
                cache.setDescription(cache.getNumByIndex(index), description);
                MessageSender.sm("&a[v]\u5907\u6ce8\u8bbe\u7f6e\u5b8c\u6bd5\uff01", player);
            }
            if (args[1].equalsIgnoreCase("bc")) {
                String broadcast = args[5];
                cache.setBroadcast(cache.getNumByIndex(index), broadcast);
                MessageSender.sm("&a[v]\u516c\u544a\u8bbe\u7f6e\u5b8c\u6bd5\uff01", player);
            }
            if (args[1].equalsIgnoreCase("dan")) {
                String dan = args[5];
                cache.setDan(cache.getNumByIndex(index), dan);
                MessageSender.sm("&a[v]\u6bb5\u4f4d\u9650\u5236\u8bbe\u7f6e\u5b8c\u6bd5\uff01", player);
            }
            return true;
        }
        if (args[1].equalsIgnoreCase("rdes") || args[1].equalsIgnoreCase("rbc") || args[1].equalsIgnoreCase("rdan")) {
            int column;
            int row;
            if (args.length != 5) {
                if (args[1].equalsIgnoreCase("rdes")) {
                    MessageSender.sm("&7\u6b63\u786e\u7528\u6cd5\uff1a/dt s rdes <\u9875\u6570> <\u884c> <\u5217>\uff0c\u884c\u548c\u5217\u4e0d\u8003\u8651GUI\u9876\u90e8\u548c\u5e95\u90e8\u7684\u73bb\u7483\u677f", player);
                }
                if (args[1].equalsIgnoreCase("rbc")) {
                    MessageSender.sm("&7\u6b63\u786e\u7528\u6cd5\uff1a/dt s rbc <\u9875\u6570> <\u884c> <\u5217>\uff0c\u884c\u548c\u5217\u4e0d\u8003\u8651GUI\u9876\u90e8\u548c\u5e95\u90e8\u7684\u73bb\u7483\u677f", player);
                }
                if (args[1].equalsIgnoreCase("rdan")) {
                    MessageSender.sm("&7\u6b63\u786e\u7528\u6cd5\uff1a/dt s rdan <\u9875\u6570> <\u884c> <\u5217>\uff0c\u884c\u548c\u5217\u4e0d\u8003\u8651GUI\u9876\u90e8\u548c\u5e95\u90e8\u7684\u73bb\u7483\u677f", player);
                }
                return true;
            }
            if (!CMDShop.isInt(args[2], args[3], args[4])) {
                MessageSender.sm("&c[x]\u8bf7\u8f93\u5165\u6709\u6548\u7684\u963f\u62c9\u4f2f\u6570\u5b57\uff01", player);
                return true;
            }
            int page = Integer.parseInt(args[2]);
            if (CMDShop.isOutOfRange(page, row = Integer.parseInt(args[3]), column = Integer.parseInt(args[4]), args[2], args[3], args[4], player)) {
                return true;
            }
            int index = CMDShop.getNum(page, row, column);
            if (index >= cache.size()) {
                MessageSender.sm("&c[x]\u4e0d\u5b58\u5728\u8fd9\u4e2a\u5546\u54c1", player);
                return true;
            }
            if (args[1].equalsIgnoreCase("rdes")) {
                cache.setDescription(cache.getNumByIndex(index), null);
                MessageSender.sm("&a[v]\u5907\u6ce8\u5220\u9664\u5b8c\u6bd5\uff01", player);
            }
            if (args[1].equalsIgnoreCase("rbc")) {
                cache.setBroadcast(cache.getNumByIndex(index), null);
                MessageSender.sm("&a[v]\u516c\u544a\u5220\u9664\u5b8c\u6bd5\uff01", player);
            }
            if (args[1].equalsIgnoreCase("rdan")) {
                cache.setDan(cache.getNumByIndex(index), null);
                MessageSender.sm("&a[v]\u6bb5\u4f4d\u9650\u5236\u53d6\u6d88\u5b8c\u6bd5\uff01", player);
            }
            return true;
        }
        this.sendHelp(player);
        return true;
    }
}

