/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.configuration.languagefile;

import com.valorin.Main;
import com.valorin.configuration.ConfigManager;
import com.valorin.configuration.languagefile.LanguageFileLoader;
import com.valorin.configuration.languagefile.SymbolsExecutor;
import java.io.File;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;

public class MessageBuilder {
    public static String gmLog(String Chinese, Player player, String v, String[] vl, boolean prefix, boolean hdTitle) {
        if (Chinese.length() == 0) {
            return "";
        }
        LanguageFileLoader languageFileLoader = Main.getInstance().getLanguageFileLoader();
        Map<File, List<String>> lang = languageFileLoader.getLang();
        List<File> languagesList = languageFileLoader.getLanguagesList();
        List<String> defaultLang = languageFileLoader.getDefaultLang();
        if (defaultLang.contains(Chinese)) {
            String finalMessage = "";
            int number = 0;
            for (int i = 0; i < defaultLang.size(); ++i) {
                if (!defaultLang.get(i).equals(Chinese)) continue;
                number = i;
            }
            if (player == null) {
                ConfigManager configManager = Main.getInstance().getConfigManager();
                boolean exist = false;
                if (configManager.getDefaultLanguage() != null) {
                    for (File file : languagesList) {
                        if (!file.getName().replace(".txt", "").equals(configManager.getDefaultLanguage())) continue;
                        exist = true;
                        finalMessage = lang.get(file).get(number);
                    }
                }
                if (!exist) {
                    finalMessage = defaultLang.get(number);
                }
            } else {
                String plang = Main.getInstance().getCacheHandler().getLanguageFile().get(player.getName());
                if (plang == null) {
                    String configDefaultLang = Main.getInstance().getConfigManager().getDefaultLanguage();
                    boolean exist = false;
                    if (configDefaultLang != null) {
                        for (File f : languagesList) {
                            if (!f.getName().replace(".txt", "").equals(configDefaultLang)) continue;
                            exist = true;
                            finalMessage = lang.get(f).get(number);
                        }
                    }
                    if (!exist) {
                        finalMessage = defaultLang.get(number);
                    }
                } else {
                    boolean isDefaultLang = true;
                    if (languagesList != null) {
                        for (File file : languagesList) {
                            if (!file.getName().split("\\.")[0].equals(plang)) continue;
                            if (number > lang.get(file).size() - 1) {
                                return "";
                            }
                            finalMessage = lang.get(file).get(number);
                            isDefaultLang = false;
                            break;
                        }
                    }
                    if (isDefaultLang) {
                        finalMessage = defaultLang.get(number);
                    }
                }
            }
            if (vl != null) {
                String[] vll = v.split("\\ ");
                for (int i = 0; i < vll.length; ++i) {
                    finalMessage = finalMessage.replace("{" + vll[i] + "}", vl[i]);
                }
            }
            finalMessage = finalMessage.replace("&", "\u00a7");
            if (player != null) {
                finalMessage = SymbolsExecutor.execute(finalMessage);
            } else if (hdTitle) {
                finalMessage = SymbolsExecutor.execute(finalMessage);
            } else {
                List<String> symbolsMark = Main.getInstance().getSymbolLoader().getSymbolsMark();
                for (String s : symbolsMark) {
                    finalMessage = finalMessage.replace(s, "");
                }
            }
            if (prefix) {
                finalMessage = Main.getInstance().getConfigManager().getPrefix() + finalMessage;
            }
            return finalMessage;
        }
        return Chinese + "\u00a78Error:This message hasn't registered!(\u6d88\u606f\u672a\u6ce8\u518c\uff0c\u53ef\u80fd\u662f\u7f16\u7801\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u8150\u7af9\u5efa\u8baeTA\u4e3a\u8bed\u8a00\u6587\u4ef6\u8f6c\u7801)";
    }

    public static String getRankingString(int rank, List<String> dataList, boolean isWin) {
        if (rank + 1 <= dataList.size()) {
            String playerName = dataList.get(rank).split("\\|")[0];
            BigDecimal bg = BigDecimal.valueOf(Double.parseDouble(dataList.get(rank).split("\\|")[1]));
            double value = bg.setScale(1, 4).doubleValue();
            switch (rank) {
                case 0: {
                    return isWin ? MessageBuilder.gmLog("&b&l[n1] &f{player} &7[right] &a{value}\u573a", null, "player value", new String[]{playerName, "" + (int)value}, false, true) : MessageBuilder.gmLog("&b&l[n1] &f{player} &7[right] &a{value}", null, "player value", new String[]{playerName, "" + value}, false, true);
                }
                case 1: {
                    return isWin ? MessageBuilder.gmLog("&e&l[n2] &f{player} &7[right] &a{value}\u573a", null, "player value", new String[]{playerName, "" + (int)value}, false, true) : MessageBuilder.gmLog("&e&l[n2] &f{player} &7[right] &a{value}", null, "player value", new String[]{playerName, "" + value}, false, true);
                }
                case 2: {
                    return isWin ? MessageBuilder.gmLog("&6&l[n3] &f{player} &7[right] &a{value}\u573a", null, "player value", new String[]{playerName, "" + (int)value}, false, true) : MessageBuilder.gmLog("&6&l[n3] &f{player} &7[right] &a{value}", null, "player value", new String[]{playerName, "" + value}, false, true);
                }
                case 3: {
                    return isWin ? MessageBuilder.gmLog("&b[n4] &f{player} &7[right] &a{value}\u573a", null, "player value", new String[]{playerName, "" + (int)value}, false, true) : MessageBuilder.gmLog("&b[n4] &f{player} &7[right] &a{value}", null, "player value", new String[]{playerName, "" + value}, false, true);
                }
                case 4: {
                    return isWin ? MessageBuilder.gmLog("&b[n5] &f{player} &7[right] &a{value}\u573a", null, "player value", new String[]{playerName, "" + (int)value}, false, true) : MessageBuilder.gmLog("&b[n5] &f{player} &7[right] &a{value}", null, "player value", new String[]{playerName, "" + value}, false, true);
                }
                case 5: {
                    return isWin ? MessageBuilder.gmLog("&b[n6] &f{player} &7[right] &a{value}\u573a", null, "player value", new String[]{playerName, "" + (int)value}, false, true) : MessageBuilder.gmLog("&b[n6] &f{player} &7[right] &a{value}", null, "player value", new String[]{playerName, "" + value}, false, true);
                }
                case 6: {
                    return isWin ? MessageBuilder.gmLog("&b[n7] &f{player} &7[right] &a{value}\u573a", null, "player value", new String[]{playerName, "" + (int)value}, false, true) : MessageBuilder.gmLog("&b[n7] &f{player} &7[right] &a{value}", null, "player value", new String[]{playerName, "" + value}, false, true);
                }
                case 7: {
                    return isWin ? MessageBuilder.gmLog("&b[n8] &f{player} &7[right] &a{value}\u573a", null, "player value", new String[]{playerName, "" + (int)value}, false, true) : MessageBuilder.gmLog("&b[n8] &f{player} &7[right] &a{value}", null, "player value", new String[]{playerName, "" + value}, false, true);
                }
                case 8: {
                    return isWin ? MessageBuilder.gmLog("&b[n9] &f{player} &7[right] &a{value}\u573a", null, "player value", new String[]{playerName, "" + (int)value}, false, true) : MessageBuilder.gmLog("&b[n9] &f{player} &7[right] &a{value}", null, "player value", new String[]{playerName, "" + value}, false, true);
                }
                case 9: {
                    return isWin ? MessageBuilder.gmLog("&b[n10] &f{player} &7[right] &a{value}\u573a", null, "player value", new String[]{playerName, "" + (int)value}, false, true) : MessageBuilder.gmLog("&b[n10] &f{player} &7[right] &a{value}", null, "player value", new String[]{playerName, "" + value}, false, true);
                }
            }
        }
        return null;
    }
}

