/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.configuration.update;

import com.google.common.base.Charsets;
import com.valorin.Main;
import com.valorin.configuration.update.Ver_1;
import com.valorin.configuration.update.Ver_10;
import com.valorin.configuration.update.Ver_11;
import com.valorin.configuration.update.Ver_2;
import com.valorin.configuration.update.Ver_3;
import com.valorin.configuration.update.Ver_4;
import com.valorin.configuration.update.Ver_5;
import com.valorin.configuration.update.Ver_6;
import com.valorin.configuration.update.Ver_7;
import com.valorin.configuration.update.Ver_8;
import com.valorin.configuration.update.Ver_9;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigUpdate {
    public static void execute() {
        YamlConfiguration defaultConfig = new YamlConfiguration();
        YamlConfiguration nowConfig = new YamlConfiguration();
        File nowConfigFile = new File(Main.getInstance().getDataFolder(), "config.yml");
        int nowVersion = 0;
        int lastVersion = -1;
        try {
            defaultConfig.load((Reader)new BufferedReader(new InputStreamReader(Main.getInstance().getResource("config.yml"), Charsets.UTF_8)));
            lastVersion = defaultConfig.getInt("ConfigVersion");
            nowConfig.load((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(nowConfigFile), Charsets.UTF_8)));
            nowVersion = nowConfig.getInt("ConfigVersion");
        }
        catch (IOException | InvalidConfigurationException throwable) {
            // empty catch block
        }
        if (lastVersion == -1) {
            return;
        }
        if (nowVersion >= lastVersion) {
            return;
        }
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        console.sendMessage("\u00a78\u00a7l[\u00a7bDantiao\u00a78\u00a7l]");
        console.sendMessage("\u00a7f- \u00a77\u6b63\u5728\u8fdb\u884cconfig.yml\u5347\u7ea7");
        console.sendMessage("\u00a7f- \u00a77Now updating the config.yml");
        File backUpConfigFile = new File(Main.getInstance().getDataFolder() + "/OldConfigs", ConfigUpdate.getDate() + ".yml");
        File fileParent = backUpConfigFile.getParentFile();
        if (!fileParent.exists()) {
            fileParent.mkdirs();
        }
        try {
            backUpConfigFile.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            ConfigUpdate.copyFile(nowConfigFile, backUpConfigFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (nowVersion < 1) {
            Ver_1.execute();
        } else {
            switch (nowVersion) {
                case 1: {
                    Ver_2.execute();
                }
                case 2: {
                    Ver_3.execute();
                }
                case 3: {
                    Ver_4.execute();
                }
                case 4: {
                    Ver_5.execute();
                }
                case 5: {
                    Ver_6.execute();
                }
                case 6: {
                    Ver_7.execute();
                }
                case 7: {
                    Ver_8.execute();
                }
                case 8: {
                    Ver_9.execute();
                }
                case 9: {
                    Ver_10.execute();
                }
                case 10: {
                    Ver_11.execute();
                }
            }
        }
        console.sendMessage("\u00a78\u00a7l[\u00a7bDantiao\u00a78\u00a7l]");
        console.sendMessage("\u00a7f- \u00a7a\u914d\u7f6e\u6587\u4ef6config.yml\u5df2\u5b8c\u6210\u81ea\u52a8\u5347\u7ea7\uff01");
        console.sendMessage("\u00a7f- \u00a7a\u5982\u679c\u4f60\u9700\u8981\u81ea\u52a8\u5347\u7ea7\u524d\u7684config.yml\u5907\u4efd\uff0c\u8bf7\u5230Dantiao\u6587\u4ef6\u5939\u4e0b\u7684OldConfigs\u6587\u4ef6\u5939\u4e2d\u67e5\u770b");
        console.sendMessage("\u00a7f- \u00a7aThe config.yml updated successfully!");
        console.sendMessage("\u00a7f- \u00a7aYou can access the config.yml backup saved before the automatic update in the OldConfigs folder under the Dantiao folder");
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        int len;
        FileInputStream inputStream = new FileInputStream(sourceFile);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        FileOutputStream outputStream = new FileOutputStream(targetFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        byte[] bytes = new byte[2048];
        while ((len = inputStream.read(bytes)) != -1) {
            bufferedOutputStream.write(bytes, 0, len);
        }
        bufferedOutputStream.flush();
        bufferedInputStream.close();
        bufferedOutputStream.close();
        inputStream.close();
        outputStream.close();
    }

    public static String getDate() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HHmmss");
        return formatter.format(cal.getTime());
    }

    public static List<String> readTexts(File file) {
        ArrayList<String> texts = new ArrayList<String>();
        try {
            String s;
            texts = new ArrayList();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
            while ((s = bufferedReader.readLine()) != null) {
                texts.add(s);
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return texts;
    }

    public static void writeTexts(File file, List<String> texts) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
            for (int i = 0; i < texts.size(); ++i) {
                if (i == texts.size() - 1) {
                    writer.write(texts.get(i));
                    continue;
                }
                writer.write(texts.get(i) + "\n");
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

