/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.itemstack;

import com.valorin.Main;
import com.valorin.configuration.languagefile.MessageSender;
import com.valorin.data.encapsulation.ArenaInfo;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class ArenaSelect {
    private final BukkitTask timer;
    private String arenaEditName;
    private final int firstIndex;
    private final int endIndex;
    private int nowIndex;
    private final List<String> arenaEditNameList = new ArrayList<String>();
    private final List<String> arenaDisplayNameList = new ArrayList<String>();
    private int lastEditIndex;
    private boolean color;

    public ArenaSelect(final Player player, List<ArenaInfo> arenaInfoList, int firstIndex, final Inventory inventory) {
        this.firstIndex = firstIndex;
        this.endIndex = firstIndex + arenaInfoList.size();
        this.nowIndex = firstIndex;
        this.lastEditIndex = firstIndex;
        for (ArenaInfo arenaInfo : arenaInfoList) {
            this.arenaEditNameList.add(arenaInfo.getEditName());
            if (arenaInfo.getDisplayName() != null) {
                this.arenaDisplayNameList.add(arenaInfo.getDisplayName().replace("&0", "").replace("&1", "").replace("&2", "").replace("&3", "").replace("&4", "").replace("&5", "").replace("&6", "").replace("&7", "").replace("&8", "").replace("&9", "").replace("&a", "").replace("&b", "").replace("&c", "").replace("&d", "").replace("&e", "").replace("&f", "").replace("&o", "").replace("&m", "").replace("&n", "").replace("&k", "").replace("&l", ""));
                continue;
            }
            this.arenaDisplayNameList.add(arenaInfo.getDisplayName());
        }
        this.timer = new BukkitRunnable(){

            public void run() {
                ArenaSelect.this.refreshItem(inventory, player);
            }
        }.runTaskTimerAsynchronously((Plugin)Main.getInstance(), 0L, 20L);
    }

    public void next(Player player, Inventory inventory) {
        if (this.nowIndex < this.endIndex) {
            ++this.nowIndex;
            this.arenaEditName = this.arenaEditNameList.get(this.nowIndex - (this.firstIndex + 1));
        } else {
            this.nowIndex = this.firstIndex;
            this.arenaEditName = null;
        }
        this.refreshItem(inventory, player);
    }

    public void cancel() {
        this.timer.cancel();
    }

    public String getSelectedArenaEditName() {
        return this.arenaEditName;
    }

    private void refreshItem(Inventory inventory, Player player) {
        String prefix;
        ItemStack ItemStack2 = inventory.getItem(13);
        ItemMeta ItemMeta2 = ItemStack2.getItemMeta();
        List lore = ItemMeta2.getLore();
        if (this.color) {
            prefix = "\u00a76\u27a3 ";
            this.color = false;
        } else {
            prefix = "\u00a7f\u27a3 ";
            this.color = true;
        }
        if (this.nowIndex != this.lastEditIndex) {
            if (this.lastEditIndex == this.firstIndex) {
                lore.set(this.lastEditIndex, "\u00a77" + MessageSender.gm("\u968f\u673a", player));
            } else {
                lore.set(this.lastEditIndex, "\u00a77" + this.arenaDisplayNameList.get(this.lastEditIndex - (this.firstIndex + 1)));
            }
        }
        if (this.nowIndex == this.firstIndex) {
            lore.set(this.nowIndex, prefix + "\u00a7f" + MessageSender.gm("\u968f\u673a", player));
            this.arenaEditName = null;
        } else {
            lore.set(this.nowIndex, prefix + "\u00a7f" + this.arenaDisplayNameList.get(this.nowIndex - (this.firstIndex + 1)));
            this.arenaEditName = this.arenaEditNameList.get(this.nowIndex - (this.firstIndex + 1));
        }
        this.lastEditIndex = this.nowIndex;
        ItemMeta2.setLore(lore);
        ItemStack2.setItemMeta(ItemMeta2);
        inventory.setItem(13, ItemStack2);
    }
}

