/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.ranking.hologram;

import com.valorin.Main;
import com.valorin.caches.AreaCache;
import com.valorin.caches.RankingCache;
import com.valorin.configuration.languagefile.MessageBuilder;
import com.valorin.configuration.languagefile.MessageSender;
import com.valorin.ranking.hologram.HologramInstance;
import com.valorin.ranking.hologram.HologramPlugin;
import com.valorin.util.Debug;
import com.valorin.util.ViaVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HologramManager {
    private boolean hologramPluginExist = false;
    private HologramPlugin hologramPluginUsed;
    private boolean isEnabled = false;
    private boolean isNeedRefresh = false;
    private final Map<HologramInstance.RankingType, HologramInstance> hologramInstanceMap = new HashMap<HologramInstance.RankingType, HologramInstance>();

    public HologramManager() {
        this.enable();
    }

    public void enable() {
        this.checkHologramPlugin();
        if (!this.hologramPluginExist) {
            return;
        }
        for (HologramInstance.RankingType rankingType : HologramInstance.RankingType.values()) {
            this.load(rankingType);
        }
        int interval = Main.getInstance().getConfigManager().getHologramRefreshInterval();
        interval = interval < 10 ? 200 : interval * 20;
        Bukkit.getScheduler().runTaskTimer((Plugin)Main.getInstance(), () -> {
            if (this.isNeedRefresh) {
                this.refresh(true);
                this.isNeedRefresh = false;
            }
        }, (long)interval, (long)interval);
        this.isEnabled = true;
        if (Main.getInstance().getConfigManager().isDebug()) {
            Debug.send("\u5168\u606f\u63d2\u4ef6\u542f\u52a8\u6210\u529f\uff0c\u5f53\u524d\u4f7f\u7528\u7684\u4e3a\uff1a" + this.hologramPluginUsed.getRealNames(), "The plugin " + this.hologramPluginUsed.getRealNames() + " for hologram is enabled");
        }
    }

    public void disable() {
        for (HologramInstance.RankingType rankingType : new HashSet<HologramInstance.RankingType>(this.hologramInstanceMap.keySet())) {
            this.unload(rankingType);
        }
    }

    public void setIsNeedRefresh(boolean isNeedRefresh) {
        this.isNeedRefresh = isNeedRefresh;
    }

    public void refresh(boolean auto) {
        for (HologramInstance hologramInstance : this.hologramInstanceMap.values()) {
            hologramInstance.refresh(this.getRefreshContent(hologramInstance.getRankingType()));
        }
        if (auto) {
            Bukkit.getConsoleSender().sendMessage(MessageSender.gm("&7\u5168\u606f\u56fe\u5df2\u81ea\u52a8\u5237\u65b0..."));
        }
    }

    public Map<HologramInstance.RankingType, HologramInstance> getHologramInstanceMap() {
        return this.hologramInstanceMap;
    }

    public void load(HologramInstance.RankingType rankingType) {
        ItemStack itemStack;
        Location location;
        AreaCache areaCache = Main.getInstance().getCacheHandler().getArea();
        ArrayList<String> content = new ArrayList();
        switch (rankingType) {
            case WIN: {
                location = areaCache.getWinRankingLocation();
                content = this.getRefreshContent(rankingType);
                itemStack = new ItemStack(ViaVersion.getGoldenSwordMaterial());
                break;
            }
            case KD: {
                location = areaCache.getKDRankingLocation();
                content = this.getRefreshContent(rankingType);
                itemStack = new ItemStack(ViaVersion.getGoldenAxeMaterial());
                break;
            }
            default: {
                location = null;
                itemStack = null;
            }
        }
        if (location == null) {
            return;
        }
        this.hologramInstanceMap.put(rankingType, new HologramInstance((Plugin)Main.getInstance(), this.hologramPluginUsed, location, rankingType, content, itemStack));
    }

    public void unload(HologramInstance.RankingType rankingType) {
        this.hologramInstanceMap.get((Object)rankingType).destroy();
        this.hologramInstanceMap.remove((Object)rankingType);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    private List<String> getRefreshContent(HologramInstance.RankingType rankingType) {
        ArrayList<String> content = new ArrayList<String>();
        RankingCache rankingCache = Main.getInstance().getCacheHandler().getRanking();
        switch (rankingType) {
            case WIN: {
                content.add(MessageSender.gm("&b[star1]\u5355\u6311-\u80dc\u573a\u6392\u884c\u699c[star2]"));
                content.addAll(IntStream.range(0, Math.min(rankingCache.getWin().size(), 10)).mapToObj(i -> MessageBuilder.getRankingString(i, rankingCache.getWin(), true)).filter(Objects::nonNull).collect(Collectors.toList()));
                break;
            }
            case KD: {
                content.add(MessageSender.gm("&b[star1]\u5355\u6311-KD\u6bd4\u503c\u6392\u884c\u699c[star2]"));
                content.addAll(IntStream.range(0, Math.min(rankingCache.getKD().size(), 10)).mapToObj(i -> MessageBuilder.getRankingString(i, rankingCache.getKD(), false)).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        }
        return content;
    }

    private void checkHologramPlugin() {
        String hologramPluginNameInConfig = Main.getInstance().getConfigManager().getHologramPluginUsed();
        ArrayList<HologramPlugin> hologramPluginInstalledList = new ArrayList<HologramPlugin>();
        block0: for (HologramPlugin hologramPlugin : HologramPlugin.values()) {
            String[] realNames;
            for (String realName : realNames = hologramPlugin.getRealNames()) {
                if (Bukkit.getPluginManager().getPlugin(realName) == null) continue;
                hologramPluginInstalledList.add(hologramPlugin);
                if (!realName.equals(hologramPluginNameInConfig)) continue;
                this.hologramPluginUsed = hologramPlugin;
                this.hologramPluginExist = true;
                break block0;
            }
        }
        if (!this.hologramPluginExist && !hologramPluginInstalledList.isEmpty()) {
            this.hologramPluginUsed = (HologramPlugin)((Object)hologramPluginInstalledList.get(0));
            this.hologramPluginExist = true;
        }
    }
}

