/*
 * Decompiled with CFR 0.152.
 */
package com.valorin.request;

import com.valorin.Main;
import com.valorin.configuration.languagefile.MessageSender;
import com.valorin.request.Request;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class RequestsHandler {
    private final Set<Request> requests = new HashSet<Request>();
    private final Map<Request, BukkitTask> timers = new HashMap<Request, BukkitTask>();
    private final Map<Request, Integer> times = new HashMap<Request, Integer>();

    public Request getRequest(String sender, String receiver) {
        for (Request request : this.requests) {
            if (!request.getSender().equals(sender) || !request.getReceiver().equals(receiver)) continue;
            return request;
        }
        return null;
    }

    public long getTime(String sender, String receiver) {
        if (this.getRequest(sender, receiver) == null) {
            return System.currentTimeMillis();
        }
        return this.times.get(this.getRequest(sender, receiver)).intValue();
    }

    public void addRequest(String sender, String receiver, String arenaEditName) {
        Request request = new Request(sender, receiver, arenaEditName);
        this.requests.add(request);
        this.times.put(request, 0);
        BukkitTask timer = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.getInstance(), () -> {
            this.times.put(request, this.times.get(request) + 1);
            if (this.times.get(request) == 60 && this.getRequest(sender, receiver) != null) {
                this.removeRequest(sender, receiver);
                if (Bukkit.getPlayerExact((String)sender) != null) {
                    MessageSender.sm("&b\u4f60\u53d1\u9001\u7ed9{receiver}\u7684\u8bf7\u6c42\u957f\u65f6\u95f4\u672a\u5f97\u5904\u7406\uff0c\u5df2\u53d6\u6d88...", Bukkit.getPlayerExact((String)sender), "receiver", new String[]{receiver});
                }
            }
        }, 20L, 20L);
        this.timers.put(request, timer);
    }

    public void removeRequest(String sender, String receiver) {
        Request request = this.getRequest(sender, receiver);
        this.requests.remove(request);
        if (!this.timers.containsKey(request)) {
            return;
        }
        this.timers.get(request).cancel();
        this.timers.remove(request);
        if (!this.times.containsKey(request)) {
            return;
        }
        this.times.remove(request);
    }

    public List<String> getReceivers(String sender) {
        ArrayList<String> list = new ArrayList<String>();
        for (Request request : this.requests) {
            if (!request.getSender().equals(sender)) continue;
            list.add(request.getReceiver());
        }
        return list;
    }

    public List<String> getSenders(String receiver) {
        ArrayList<String> list = new ArrayList<String>();
        for (Request request : this.requests) {
            if (!request.getReceiver().equals(receiver)) continue;
            list.add(request.getSender());
        }
        return list;
    }

    public void clearRequests(String pn, int cause, String opponentName) {
        for (String sn : this.getSenders(pn)) {
            this.removeRequest(sn, pn);
            if (cause == 0 && !sn.equals(opponentName)) {
                MessageSender.sm("&7\u73a9\u5bb6 &f{player} &7\u5f00\u59cb\u4e86\u522b\u7684\u6bd4\u8d5b\uff0c\u4e4b\u524d\u672a\u5904\u7406\u7684\u8bf7\u6c42\u5df2\u53d6\u6d88...", Bukkit.getPlayerExact((String)sn), "player", new String[]{pn});
            }
            if (cause != 1) continue;
            MessageSender.sm("&7\u73a9\u5bb6 &f{player} &7\u6682\u65f6\u4e0b\u7ebf\u4e86\uff0c\u4e4b\u524d\u672a\u5904\u7406\u7684\u8bf7\u6c42\u5df2\u53d6\u6d88...", Bukkit.getPlayerExact((String)sn), "player", new String[]{pn});
        }
        for (String rn : this.getReceivers(pn)) {
            this.removeRequest(pn, rn);
            if (cause == 0 && !rn.equals(opponentName)) {
                MessageSender.sm("&7\u4e4b\u524d\u5411\u4f60\u53d1\u9001\u5355\u6311\u8bf7\u6c42\u7684\u73a9\u5bb6 &f{player} &7\u5f00\u59cb\u4e86\u522b\u7684\u6bd4\u8d5b\uff0c\u8bf7\u5ffd\u89c6\u4e4b\u524d\u7684\u8bf7\u6c42...", Bukkit.getPlayerExact((String)rn), "player", new String[]{pn});
            }
            if (cause != 1) continue;
            MessageSender.sm("&7\u4e4b\u524d\u5411\u4f60\u53d1\u9001\u5355\u6311\u8bf7\u6c42\u7684\u73a9\u5bb6 &f{player} &7\u6682\u65f6\u4e0b\u7ebf\u4e86\uff0c\u8bf7\u5ffd\u89c6\u4e4b\u524d\u7684\u8bf7\u6c42...", Bukkit.getPlayerExact((String)rn), "player", new String[]{pn});
        }
    }
}

