/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.SingleColumnFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderLoader;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnQuadView;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.IColumnDataView;
import com.seibel.distanthorizons.core.dataObjects.transformers.FullDataToRenderDataTransformer;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhLodPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.RenderDataPointUtil;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataOutputStream;
import com.seibel.distanthorizons.coreapi.ModInfo;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;

public class ColumnRenderSource {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final boolean DO_SAFETY_CHECKS = ModInfo.IS_DEV_BUILD;
    public static final byte SECTION_SIZE_OFFSET = 6;
    public static final int SECTION_SIZE = BitShiftUtil.powerOfTwo(6);
    public static final byte DATA_FORMAT_VERSION = 1;
    public static final String DATA_NAME = "ColumnRenderSource";
    public static final int DATA_GUARD_BYTE = -1;
    public static final int NO_DATA_FLAG_BYTE = 1;
    public int verticalDataCount;
    public final DhSectionPos sectionPos;
    public final int yOffset;
    public long[] renderDataContainer;
    public final DebugSourceFlag[] debugSourceFlags;
    private boolean isEmpty = true;
    public EDhApiWorldGenerationStep worldGenStep;
    public AtomicLong localVersion = new AtomicLong(0L);

    public static ColumnRenderSource createEmptyRenderSource(DhSectionPos sectionPos) {
        return new ColumnRenderSource(sectionPos, 0, 0);
    }

    public ColumnRenderSource(DhSectionPos sectionPos, int maxVerticalSize, int yOffset) {
        this.verticalDataCount = maxVerticalSize;
        this.renderDataContainer = new long[SECTION_SIZE * SECTION_SIZE * this.verticalDataCount];
        this.debugSourceFlags = new DebugSourceFlag[SECTION_SIZE * SECTION_SIZE];
        this.sectionPos = sectionPos;
        this.yOffset = yOffset;
        this.worldGenStep = EDhApiWorldGenerationStep.EMPTY;
    }

    public ColumnRenderSource(DhSectionPos sectionPos, ColumnRenderLoader.ParsedColumnData parsedColumnData, IDhLevel level) throws IOException {
        if (sectionPos.getDetailLevel() - 6 != parsedColumnData.detailLevel) {
            throw new IOException("Invalid data: detail level does not match");
        }
        this.sectionPos = sectionPos;
        this.yOffset = level.getMinY();
        this.verticalDataCount = parsedColumnData.verticalSize;
        this.renderDataContainer = parsedColumnData.dataContainer;
        this.worldGenStep = parsedColumnData.worldGenStep;
        this.isEmpty = parsedColumnData.isEmpty;
        this.debugSourceFlags = new DebugSourceFlag[SECTION_SIZE * SECTION_SIZE];
        this.fillDebugFlag(0, 0, SECTION_SIZE, SECTION_SIZE, DebugSourceFlag.FILE);
    }

    public void clearDataPoint(int posX, int posZ) {
        for (int verticalIndex = 0; verticalIndex < this.verticalDataCount; ++verticalIndex) {
            this.renderDataContainer[posX * ColumnRenderSource.SECTION_SIZE * this.verticalDataCount + posZ * this.verticalDataCount + verticalIndex] = 0L;
        }
    }

    public boolean setDataPoint(long data, int posX, int posZ, int verticalIndex) {
        this.renderDataContainer[posX * ColumnRenderSource.SECTION_SIZE * this.verticalDataCount + posZ * this.verticalDataCount + verticalIndex] = data;
        return true;
    }

    public boolean copyVerticalData(IColumnDataView newData, int posX, int posZ, boolean overwriteDataWithSameGenerationMode) {
        if (DO_SAFETY_CHECKS) {
            if (newData.size() != this.verticalDataCount) {
                throw new IllegalArgumentException("newData size not the same as this column's vertical size");
            }
            if (posX < 0 || posX >= SECTION_SIZE) {
                throw new IllegalArgumentException("X position is out of bounds");
            }
            if (posZ < 0 || posZ >= SECTION_SIZE) {
                throw new IllegalArgumentException("Z position is out of bounds");
            }
        }
        int dataOffset = posX * SECTION_SIZE * this.verticalDataCount + posZ * this.verticalDataCount;
        int compare = RenderDataPointUtil.compareDatapointPriority(newData.get(0), this.renderDataContainer[dataOffset]);
        if (overwriteDataWithSameGenerationMode ? compare < 0 : compare <= 0) {
            return false;
        }
        newData.copyTo(this.renderDataContainer, dataOffset, newData.size());
        return true;
    }

    public long getFirstDataPoint(int posX, int posZ) {
        return this.getDataPoint(posX, posZ, 0);
    }

    public long getDataPoint(int posX, int posZ, int verticalIndex) {
        return this.renderDataContainer[posX * SECTION_SIZE * this.verticalDataCount + posZ * this.verticalDataCount + verticalIndex];
    }

    public long[] getVerticalDataPointArray(int posX, int posZ) {
        long[] result = new long[this.verticalDataCount];
        int index = posX * SECTION_SIZE * this.verticalDataCount + posZ * this.verticalDataCount;
        System.arraycopy(this.renderDataContainer, index, result, 0, this.verticalDataCount);
        return result;
    }

    public ColumnArrayView getVerticalDataPointView(int posX, int posZ) {
        return new ColumnArrayView(this.renderDataContainer, this.verticalDataCount, posX * SECTION_SIZE * this.verticalDataCount + posZ * this.verticalDataCount, this.verticalDataCount);
    }

    public ColumnQuadView getFullQuadView() {
        return this.getQuadViewOverRange(0, 0, SECTION_SIZE, SECTION_SIZE);
    }

    public ColumnQuadView getQuadViewOverRange(int quadX, int quadZ, int quadXSize, int quadZSize) {
        return new ColumnQuadView(this.renderDataContainer, SECTION_SIZE, this.verticalDataCount, quadX, quadZ, quadXSize, quadZSize);
    }

    public int getVerticalSize() {
        return this.verticalDataCount;
    }

    public void writeData(DhDataOutputStream outputStream) throws IOException {
        outputStream.flush();
        outputStream.writeByte(this.getDataDetailLevel());
        outputStream.writeInt(this.verticalDataCount);
        if (this.isEmpty) {
            outputStream.writeByte(1);
        } else {
            outputStream.writeByte(-1);
            outputStream.writeInt(this.yOffset);
            for (int xz = 0; xz < SECTION_SIZE * SECTION_SIZE; ++xz) {
                for (int y = 0; y < this.verticalDataCount; ++y) {
                    long currentDatapoint = this.renderDataContainer[xz * this.verticalDataCount + y];
                    outputStream.writeLong(Long.reverseBytes(currentDatapoint));
                }
            }
        }
        outputStream.writeByte(-1);
        outputStream.writeByte(this.worldGenStep.value);
        outputStream.flush();
    }

    public void updateFromRenderSource(ColumnRenderSource renderSource) {
        LodUtil.assertTrue(renderSource.sectionPos.equals(this.sectionPos));
        this.clearAndChangeVerticalSize(renderSource.verticalDataCount);
        LodUtil.assertTrue(renderSource.verticalDataCount == this.verticalDataCount);
        if (renderSource.isEmpty) {
            return;
        }
        this.isEmpty = false;
        for (int i = 0; i < this.renderDataContainer.length; i += this.verticalDataCount) {
            byte thisGenMode = RenderDataPointUtil.getGenerationMode(this.renderDataContainer[i]);
            byte srcGenMode = RenderDataPointUtil.getGenerationMode(renderSource.renderDataContainer[i]);
            if (srcGenMode == 0 || thisGenMode > srcGenMode) continue;
            ColumnArrayView thisColumnArrayView = new ColumnArrayView(this.renderDataContainer, this.verticalDataCount, i, this.verticalDataCount);
            ColumnArrayView srcColumnArrayView = new ColumnArrayView(renderSource.renderDataContainer, renderSource.verticalDataCount, i, renderSource.verticalDataCount);
            thisColumnArrayView.copyFrom(srcColumnArrayView);
            this.debugSourceFlags[i / this.verticalDataCount] = renderSource.debugSourceFlags[i / this.verticalDataCount];
        }
        this.localVersion.incrementAndGet();
    }

    private void clearAndChangeVerticalSize(int newVerticalSize) {
        if (newVerticalSize != this.verticalDataCount) {
            this.verticalDataCount = newVerticalSize;
            this.renderDataContainer = new long[SECTION_SIZE * SECTION_SIZE * this.verticalDataCount];
            this.localVersion.incrementAndGet();
        }
    }

    public boolean updateWithChunkData(ChunkSizedFullDataAccessor chunkDataView, IDhClientLevel level) {
        String errorMessagePrefix = "Unable to complete fastWrite for RenderSource pos: [" + this.sectionPos + "] and chunk pos: [" + chunkDataView.chunkPos + "]. Error:";
        DhSectionPos renderSourcePos = this.getSectionPos();
        int sourceBlockX = renderSourcePos.getMinCornerLodPos().getCornerBlockPos().x;
        int sourceBlockZ = renderSourcePos.getMinCornerLodPos().getCornerBlockPos().z;
        int blockOffsetX = chunkDataView.chunkPos.x * 16 - sourceBlockX;
        int blockOffsetZ = chunkDataView.chunkPos.z * 16 - sourceBlockZ;
        int sourceDataPointBlockWidth = BitShiftUtil.powerOfTwo(this.getDataDetailLevel());
        boolean dataChanged = false;
        if (chunkDataView.detailLevel == this.getDataDetailLevel()) {
            this.markNotEmpty();
            if (blockOffsetX < 0 || blockOffsetX + 16 > this.getWidthInDataPoints() || blockOffsetZ < 0 || blockOffsetZ + 16 > this.getWidthInDataPoints()) {
                LOGGER.warn(errorMessagePrefix + "Data offset is out of bounds.");
                return false;
            }
            if (Thread.interrupted()) {
                LOGGER.warn(errorMessagePrefix + "write interrupted.");
                return false;
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    ColumnArrayView columnArrayView = this.getVerticalDataPointView(blockOffsetX + x, blockOffsetZ + z);
                    int hash = columnArrayView.getDataHash();
                    SingleColumnFullDataAccessor fullArrayView = chunkDataView.get(x, z);
                    FullDataToRenderDataTransformer.convertColumnData(level, sourceBlockX + sourceDataPointBlockWidth * (blockOffsetX + x), sourceBlockZ + sourceDataPointBlockWidth * (blockOffsetZ + z), columnArrayView, fullArrayView, 2);
                    dataChanged |= hash != columnArrayView.getDataHash();
                }
            }
            this.fillDebugFlag(blockOffsetX, blockOffsetZ, 16, 16, DebugSourceFlag.DIRECT);
        } else if (chunkDataView.detailLevel < this.getDataDetailLevel() && this.getDataDetailLevel() <= chunkDataView.getSectionPos().getDetailLevel()) {
            this.markNotEmpty();
            DhLodPos dataCornerPos = chunkDataView.getSectionPos().getMinCornerLodPos(chunkDataView.detailLevel);
            DhLodPos sourceCornerPos = renderSourcePos.getMinCornerLodPos(this.getDataDetailLevel());
            DhLodPos sourceStartingChangePos = dataCornerPos.convertToDetailLevel(this.getDataDetailLevel());
            int relStartX = Math.floorMod(sourceStartingChangePos.x, this.getWidthInDataPoints());
            int relStartZ = Math.floorMod(sourceStartingChangePos.z, this.getWidthInDataPoints());
            int dataToSourceScale = sourceCornerPos.getWidthAtDetail(chunkDataView.detailLevel);
            int columnsInChunk = chunkDataView.getSectionPos().getWidthCountForLowerDetailedSection(this.getDataDetailLevel());
            for (int xOffset = 0; xOffset < columnsInChunk; ++xOffset) {
                for (int zOffset = 0; zOffset < columnsInChunk; ++zOffset) {
                    int relSourceX = relStartX + xOffset;
                    int relSourceZ = relStartZ + zOffset;
                    ColumnArrayView columnArrayView = this.getVerticalDataPointView(relSourceX, relSourceZ);
                    int hash = columnArrayView.getDataHash();
                    SingleColumnFullDataAccessor fullArrayView = chunkDataView.get(xOffset * dataToSourceScale, zOffset * dataToSourceScale);
                    FullDataToRenderDataTransformer.convertColumnData(level, sourceBlockX + sourceDataPointBlockWidth * relSourceX, sourceBlockZ + sourceDataPointBlockWidth * relSourceZ, columnArrayView, fullArrayView, 2);
                    dataChanged |= hash != columnArrayView.getDataHash();
                }
            }
            this.fillDebugFlag(relStartX, relStartZ, columnsInChunk, columnsInChunk, DebugSourceFlag.DIRECT);
        } else if (chunkDataView.getSectionPos().getDetailLevel() < this.getDataDetailLevel()) {
            DhLodPos dataCornerPos = chunkDataView.getSectionPos().getMinCornerLodPos(chunkDataView.detailLevel);
            DhLodPos sourceCornerPos = renderSourcePos.getMinCornerLodPos(this.getDataDetailLevel());
            DhLodPos sourceStartingChangePos = dataCornerPos.convertToDetailLevel(this.getDataDetailLevel());
            int chunksPerColumn = sourceStartingChangePos.getWidthAtDetail(chunkDataView.getSectionPos().getDetailLevel());
            if (chunkDataView.getSectionPos().getX() % chunksPerColumn != 0 || chunkDataView.getSectionPos().getZ() % chunksPerColumn != 0) {
                return false;
            }
            int relStartX = Math.floorMod(sourceStartingChangePos.x, this.getWidthInDataPoints());
            int relStartZ = Math.floorMod(sourceStartingChangePos.z, this.getWidthInDataPoints());
            ColumnArrayView columnArrayView = this.getVerticalDataPointView(relStartX, relStartZ);
            int hash = columnArrayView.getDataHash();
            SingleColumnFullDataAccessor fullArrayView = chunkDataView.get(0, 0);
            FullDataToRenderDataTransformer.convertColumnData(level, dataCornerPos.x * sourceDataPointBlockWidth, dataCornerPos.z * sourceDataPointBlockWidth, columnArrayView, fullArrayView, 2);
            dataChanged = hash != columnArrayView.getDataHash();
            this.fillDebugFlag(relStartX, relStartZ, 1, 1, DebugSourceFlag.DIRECT);
        }
        if (dataChanged) {
            this.localVersion.incrementAndGet();
        }
        return dataChanged;
    }

    public boolean doesDataPointExist(int posX, int posZ) {
        return RenderDataPointUtil.doesDataPointExist(this.getFirstDataPoint(posX, posZ));
    }

    public void generateData(ColumnRenderSource lowerDataContainer, int posX, int posZ) {
        ColumnArrayView outputView = this.getVerticalDataPointView(posX, posZ);
        ColumnQuadView quadView = lowerDataContainer.getQuadViewOverRange(posX * 2, posZ * 2, 2, 2);
        outputView.mergeMultiDataFrom(quadView);
    }

    public int getMaxLodCount() {
        return SECTION_SIZE * SECTION_SIZE * this.getVerticalSize();
    }

    public long getRoughRamUsageInBytes() {
        return (long)this.renderDataContainer.length * 8L;
    }

    public DhSectionPos getSectionPos() {
        return this.sectionPos;
    }

    public byte getDataDetailLevel() {
        return (byte)(this.sectionPos.getDetailLevel() - 6);
    }

    public int getWidthInDataPoints() {
        return BitShiftUtil.powerOfTwo(this.getDetailOffset());
    }

    public byte getDetailOffset() {
        return 6;
    }

    public byte getRenderDataFormatVersion() {
        return 1;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void markNotEmpty() {
        this.isEmpty = false;
    }

    public boolean hasNonVoidDataPoints() {
        if (this.isEmpty) {
            return false;
        }
        for (int x = 0; x < SECTION_SIZE; ++x) {
            for (int z = 0; z < SECTION_SIZE; ++z) {
                ColumnArrayView columnArrayView = this.getVerticalDataPointView(x, z);
                for (int i = 0; i < columnArrayView.size; ++i) {
                    long dataPoint = columnArrayView.get(i);
                    if (RenderDataPointUtil.isVoid(dataPoint)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void fillDebugFlag(int xStart, int zStart, int xWidth, int zWidth, DebugSourceFlag flag) {
        for (int x = xStart; x < xStart + xWidth; ++x) {
            for (int z = zStart; z < zStart + zWidth; ++z) {
                this.debugSourceFlags[x * ColumnRenderSource.SECTION_SIZE + z] = flag;
            }
        }
        this.localVersion.incrementAndGet();
    }

    public DebugSourceFlag debugGetFlag(int ox, int oz) {
        return this.debugSourceFlags[ox * SECTION_SIZE + oz];
    }

    public String toString() {
        String LINE_DELIMITER = "\n";
        String DATA_DELIMITER = " ";
        String SUBDATA_DELIMITER = ",";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.sectionPos);
        stringBuilder.append(LINE_DELIMITER);
        int size = 1;
        for (int z = 0; z < size; ++z) {
            for (int x = 0; x < size; ++x) {
                for (int y = 0; y < this.verticalDataCount; ++y) {
                    stringBuilder.append(Long.toHexString(this.getDataPoint(x, z, y)));
                    if (y == this.verticalDataCount - 1) continue;
                    stringBuilder.append(SUBDATA_DELIMITER);
                }
                if (x == size - 1) continue;
                stringBuilder.append(DATA_DELIMITER);
            }
            if (z == size - 1) continue;
            stringBuilder.append(LINE_DELIMITER);
        }
        return stringBuilder.toString();
    }

    public static enum DebugSourceFlag {
        FULL(ColorUtil.BLUE),
        DIRECT(ColorUtil.WHITE),
        SPARSE(ColorUtil.YELLOW),
        FILE(ColorUtil.BROWN);

        public final int color;

        private DebugSourceFlag(int color) {
            this.color = color;
        }
    }
}

