/*
 * Decompiled with CFR 0.152.
 */
package pers.neige.easyitem.taboolib.common.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import pers.neige.easyitem.taboolib.common.SkipIsolatedClassLoader;

public class IsolatedClassLoader
extends URLClassLoader {
    private static final Set<String> excludeClasses = new HashSet<String>();
    private static boolean isEnabled = false;

    public IsolatedClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name2, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name2);
        synchronized (object) {
            Class<?> loadedClass = this.findLoadedClass(name2);
            if (loadedClass == null) {
                ClassLoader parent;
                if (!excludeClasses.contains(name2)) {
                    try {
                        loadedClass = this.findClass(name2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (loadedClass == null && (parent = this.getParent()) != null) {
                    loadedClass = parent.loadClass(name2);
                }
            }
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    static {
        try {
            Class<SkipIsolatedClassLoader> clazz = SkipIsolatedClassLoader.class;
        }
        catch (NoClassDefFoundError ignored) {
            isEnabled = true;
            excludeClasses.addAll(Arrays.asList("pers.neige.easyitem.taboolib.common.classloader.IsolatedClassLoader", "pers.neige.easyitem.taboolib.common.platform.Plugin", "pers.neige.easyitem.taboolib.platform.BukkitPlugin", "pers.neige.easyitem.taboolib.platform.BungeePlugin", "pers.neige.easyitem.taboolib.platform.VelocityPlugin", "pers.neige.easyitem.taboolib.platform.CloudNetV3Plugin", "pers.neige.easyitem.taboolib.platform.NukkitPlugin", "pers.neige.easyitem.taboolib.platform.Sponge7Plugin", "pers.neige.easyitem.taboolib.platform.Sponge8Plugin", "pers.neige.easyitem.taboolib.platform.Sponge9Plugin"));
        }
    }
}

