/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants;

import com.willfp.eco.core.Prerequisite;
import com.willfp.eco.core.command.impl.PluginCommand;
import com.willfp.eco.core.display.DisplayModule;
import com.willfp.eco.core.integrations.IntegrationLoader;
import com.willfp.ecoenchants.EcoEnchantsPluginKt;
import com.willfp.ecoenchants.commands.CommandEcoEnchants;
import com.willfp.ecoenchants.commands.CommandEnchant;
import com.willfp.ecoenchants.commands.CommandEnchantInfo;
import com.willfp.ecoenchants.config.RarityYml;
import com.willfp.ecoenchants.config.TargetsYml;
import com.willfp.ecoenchants.config.TypesYml;
import com.willfp.ecoenchants.config.VanillaEnchantsYml;
import com.willfp.ecoenchants.display.DisplayCache;
import com.willfp.ecoenchants.display.EnchantDisplay;
import com.willfp.ecoenchants.display.EnchantSorter;
import com.willfp.ecoenchants.enchant.EcoEnchantLevel;
import com.willfp.ecoenchants.enchant.EcoEnchants;
import com.willfp.ecoenchants.enchant.EnchantGUI;
import com.willfp.ecoenchants.enchant.LoreConversion;
import com.willfp.ecoenchants.enchant.VanillaEnchantmentsKt;
import com.willfp.ecoenchants.enchant.registration.EnchantmentRegisterer;
import com.willfp.ecoenchants.enchant.registration.legacy.LegacyEnchantmentRegisterer;
import com.willfp.ecoenchants.enchant.registration.modern.ModernEnchantmentRegistererProxy;
import com.willfp.ecoenchants.integrations.EnchantRegistrations;
import com.willfp.ecoenchants.integrations.plugins.CMIIntegration;
import com.willfp.ecoenchants.integrations.plugins.EssentialsIntegration;
import com.willfp.ecoenchants.libreforge.loader.LibreforgePlugin;
import com.willfp.ecoenchants.libreforge.loader.configs.ConfigCategory;
import com.willfp.ecoenchants.mechanics.AnvilSupport;
import com.willfp.ecoenchants.mechanics.EnchantingTableSupport;
import com.willfp.ecoenchants.mechanics.ExtraItemSupport;
import com.willfp.ecoenchants.mechanics.GrindstoneSupport;
import com.willfp.ecoenchants.mechanics.LootSupport;
import com.willfp.ecoenchants.mechanics.VillagerSupport;
import com.willfp.ecoenchants.target.EnchantFinder;
import com.willfp.libreforge.Dispatcher;
import com.willfp.libreforge.Holder;
import com.willfp.libreforge.HolderProvider;
import com.willfp.libreforge.HolderProviderKt;
import com.willfp.libreforge.NamedValue;
import com.willfp.libreforge.ProvidedHolder;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u001eH\u0014J\b\u0010 \u001a\u00020\u001eH\u0014J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\"H\u0014J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\"H\u0014J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\"H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006*"}, d2={"Lcom/willfp/ecoenchants/EcoEnchantsPlugin;", "Lcom/willfp/ecoenchants/libreforge/loader/LibreforgePlugin;", "()V", "enchantmentRegisterer", "Lcom/willfp/ecoenchants/enchant/registration/EnchantmentRegisterer;", "getEnchantmentRegisterer", "()Lcom/willfp/ecoenchants/enchant/registration/EnchantmentRegisterer;", "<set-?>", "", "isLoaded", "()Z", "rarityYml", "Lcom/willfp/ecoenchants/config/RarityYml;", "getRarityYml", "()Lcom/willfp/ecoenchants/config/RarityYml;", "targetsYml", "Lcom/willfp/ecoenchants/config/TargetsYml;", "getTargetsYml", "()Lcom/willfp/ecoenchants/config/TargetsYml;", "typesYml", "Lcom/willfp/ecoenchants/config/TypesYml;", "getTypesYml", "()Lcom/willfp/ecoenchants/config/TypesYml;", "vanillaEnchantsYml", "Lcom/willfp/ecoenchants/config/VanillaEnchantsYml;", "getVanillaEnchantsYml", "()Lcom/willfp/ecoenchants/config/VanillaEnchantsYml;", "createDisplayModule", "Lcom/willfp/eco/core/display/DisplayModule;", "handleAfterLoad", "", "handleEnable", "handleReload", "loadConfigCategories", "", "Lcom/willfp/ecoenchants/libreforge/loader/configs/ConfigCategory;", "loadIntegrationLoaders", "Lcom/willfp/eco/core/integrations/IntegrationLoader;", "loadListeners", "Lorg/bukkit/event/Listener;", "loadPluginCommands", "Lcom/willfp/eco/core/command/impl/PluginCommand;", "core-plugin"})
@SourceDebugExtension(value={"SMAP\nEcoEnchantsPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcoEnchantsPlugin.kt\ncom/willfp/ecoenchants/EcoEnchantsPlugin\n+ 2 HolderProvider.kt\ncom/willfp/libreforge/HolderProviderKt\n*L\n1#1,137:1\n185#2,6:138\n222#2,9:144\n*S KotlinDebug\n*F\n+ 1 EcoEnchantsPlugin.kt\ncom/willfp/ecoenchants/EcoEnchantsPlugin\n*L\n79#1:138,6\n83#1:144,9\n*E\n"})
public final class EcoEnchantsPlugin
extends LibreforgePlugin {
    @NotNull
    private final TargetsYml targetsYml = new TargetsYml(this);
    @NotNull
    private final RarityYml rarityYml = new RarityYml(this);
    @NotNull
    private final TypesYml typesYml = new TypesYml(this);
    @NotNull
    private final VanillaEnchantsYml vanillaEnchantsYml = new VanillaEnchantsYml(this);
    private boolean isLoaded;
    @NotNull
    private final EnchantmentRegisterer enchantmentRegisterer;

    public EcoEnchantsPlugin() {
        EnchantmentRegisterer enchantmentRegisterer;
        if (Prerequisite.HAS_1_20_3.isMet()) {
            Object object = this.getProxy(ModernEnchantmentRegistererProxy.class);
            Intrinsics.checkNotNull((Object)object);
            enchantmentRegisterer = (EnchantmentRegisterer)object;
        } else {
            enchantmentRegisterer = LegacyEnchantmentRegisterer.INSTANCE;
        }
        this.enchantmentRegisterer = enchantmentRegisterer;
        EcoEnchantsPluginKt.access$setPlugin$p(this);
        if (Prerequisite.HAS_1_20_3.isMet()) {
            ((ModernEnchantmentRegistererProxy)EcoEnchantsPluginKt.getPlugin().getProxy(ModernEnchantmentRegistererProxy.class)).replaceRegistry();
        }
    }

    @NotNull
    public final TargetsYml getTargetsYml() {
        return this.targetsYml;
    }

    @NotNull
    public final RarityYml getRarityYml() {
        return this.rarityYml;
    }

    @NotNull
    public final TypesYml getTypesYml() {
        return this.typesYml;
    }

    @NotNull
    public final VanillaEnchantsYml getVanillaEnchantsYml() {
        return this.vanillaEnchantsYml;
    }

    public final boolean isLoaded() {
        return this.isLoaded;
    }

    @NotNull
    public final EnchantmentRegisterer getEnchantmentRegisterer() {
        return this.enchantmentRegisterer;
    }

    @Override
    @NotNull
    public List<ConfigCategory> loadConfigCategories() {
        return CollectionsKt.listOf((Object)EcoEnchants.INSTANCE);
    }

    protected void handleEnable() {
        HolderProviderKt.registerHolderProvider((HolderProvider)((HolderProvider)EnchantFinder.INSTANCE.toHolderProvider()));
        boolean $i$f$registerSpecificRefreshFunction = false;
        HolderProviderKt.registerRefreshFunction((Function1)new Function1<Dispatcher<?>, Unit>(){

            public final void invoke(@NotNull Dispatcher<?> it) {
                block1: {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    Dispatcher<?> $this$get$iv = it;
                    boolean $i$f$get = false;
                    Object object = $this$get$iv.getDispatcher();
                    if (!(object instanceof LivingEntity)) {
                        object = null;
                    }
                    LivingEntity livingEntity = (LivingEntity)object;
                    if (livingEntity == null) break block1;
                    LivingEntity t = livingEntity;
                    boolean bl = false;
                    LivingEntity it2 = t;
                    boolean bl2 = false;
                    EnchantFinder.INSTANCE.clearEnchantmentCache$core_plugin(it2);
                }
            }
        });
        boolean $i$f$registerHolderPlaceholderProvider = false;
        HolderProviderKt.registerPlaceholderProvider((Function2)new Function2<ProvidedHolder, Dispatcher<?>, Collection<? extends NamedValue>>(){

            @NotNull
            public final Collection<NamedValue> invoke(@NotNull ProvidedHolder provided, @NotNull Dispatcher<?> dispatcher) {
                Collection collection;
                Intrinsics.checkNotNullParameter((Object)provided, (String)"provided");
                Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
                Holder holder = provided.getHolder();
                if (holder instanceof EcoEnchantLevel) {
                    EcoEnchantLevel it = (EcoEnchantLevel)holder;
                    boolean bl = false;
                    collection = CollectionsKt.listOf((Object)new NamedValue("level", (Object)it.getLevel()));
                } else {
                    collection = CollectionsKt.emptyList();
                }
                return collection;
            }
        });
    }

    protected void handleAfterLoad() {
        this.isLoaded = true;
    }

    protected void handleReload() {
        if (!Prerequisite.HAS_1_20_3.isMet()) {
            VanillaEnchantmentsKt.legacyRegisterVanillaEnchantmentData(this);
        }
        DisplayCache.INSTANCE.reload$core_plugin();
        EnchantSorter.INSTANCE.reload$core_plugin(this);
        ExtraItemSupport.INSTANCE.reload$core_plugin(this);
        EnchantGUI.INSTANCE.reload$core_plugin(this);
    }

    @NotNull
    protected List<Listener> loadListeners() {
        Object[] objectArray = new Listener[]{new VillagerSupport(this), new EnchantingTableSupport(this), new LootSupport(this), new AnvilSupport(this), new LoreConversion(this), new GrindstoneSupport(this)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected List<IntegrationLoader> loadIntegrationLoaders() {
        Object[] objectArray = new IntegrationLoader[]{new IntegrationLoader("Essentials", EcoEnchantsPlugin::loadIntegrationLoaders$lambda$2), new IntegrationLoader("CMI", EcoEnchantsPlugin::loadIntegrationLoaders$lambda$3)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected List<PluginCommand> loadPluginCommands() {
        Object[] objectArray = new PluginCommand[]{new CommandEcoEnchants(this), new CommandEnchantInfo(this), new CommandEnchant(this)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    protected DisplayModule createDisplayModule() {
        return this.getConfigYml().getBool("display.enabled") ? (DisplayModule)new EnchantDisplay(this) : null;
    }

    private static final void loadIntegrationLoaders$lambda$2() {
        EnchantRegistrations.INSTANCE.register(new EssentialsIntegration());
    }

    private static final void loadIntegrationLoaders$lambda$3() {
        EnchantRegistrations.INSTANCE.register(new CMIIntegration());
    }
}

