/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.ecoenchants.enchant.impl.hardcoded;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.Prerequisite;
import com.willfp.eco.core.data.PlayerProfile;
import com.willfp.eco.core.data.ProfileExtensions;
import com.willfp.eco.core.data.keys.PersistentDataKey;
import com.willfp.eco.core.data.keys.PersistentDataKeyType;
import com.willfp.eco.core.drops.DropQueue;
import com.willfp.eco.core.fast.FastItemStackExtensions;
import com.willfp.eco.core.items.Items;
import com.willfp.ecoenchants.EcoEnchantsPlugin;
import com.willfp.ecoenchants.enchant.EcoEnchant;
import com.willfp.ecoenchants.enchant.impl.HardcodedEcoEnchant;
import com.willfp.ecoenchants.target.EnchantFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/willfp/ecoenchants/enchant/impl/hardcoded/EnchantmentSoulbound;", "Lcom/willfp/ecoenchants/enchant/impl/HardcodedEcoEnchant;", "plugin", "Lcom/willfp/ecoenchants/EcoEnchantsPlugin;", "(Lcom/willfp/ecoenchants/EcoEnchantsPlugin;)V", "handler", "Lcom/willfp/ecoenchants/enchant/impl/hardcoded/EnchantmentSoulbound$SoulboundHandler;", "onRegister", "", "onRemove", "SoulboundHandler", "core-plugin"})
public final class EnchantmentSoulbound
extends HardcodedEcoEnchant {
    @NotNull
    private final SoulboundHandler handler;

    public EnchantmentSoulbound(@NotNull EcoEnchantsPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        super("soulbound", plugin);
        this.handler = new SoulboundHandler(plugin, this);
    }

    public void onRegister() {
        this.getPlugin().getEventManager().registerListener((Listener)this.handler);
    }

    public void onRemove() {
        this.getPlugin().getEventManager().unregisterListener((Listener)this.handler);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0018H\u0007J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R8\u0010\u0007\u001a,\u0012(\u0012&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\f0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/willfp/ecoenchants/enchant/impl/hardcoded/EnchantmentSoulbound$SoulboundHandler;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "enchant", "Lcom/willfp/ecoenchants/enchant/EcoEnchant;", "(Lcom/willfp/eco/core/EcoPlugin;Lcom/willfp/ecoenchants/enchant/EcoEnchant;)V", "savedSoulboundItems", "Lcom/willfp/eco/core/data/keys/PersistentDataKey;", "", "", "kotlin.jvm.PlatformType", "", "soulboundKey", "Lorg/bukkit/NamespacedKey;", "Lorg/jetbrains/annotations/NotNull;", "giveItems", "", "player", "Lorg/bukkit/entity/Player;", "handle", "event", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "onJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "Lorg/bukkit/event/player/PlayerRespawnEvent;", "preventDroppingSoulboundItems", "core-plugin"})
    @SourceDebugExtension(value={"SMAP\nEnchantmentSoulbound.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnchantmentSoulbound.kt\ncom/willfp/ecoenchants/enchant/impl/hardcoded/EnchantmentSoulbound$SoulboundHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1549#2:134\n1620#2,3:135\n1549#2:138\n1620#2,3:139\n*S KotlinDebug\n*F\n+ 1 EnchantmentSoulbound.kt\ncom/willfp/ecoenchants/enchant/impl/hardcoded/EnchantmentSoulbound$SoulboundHandler\n*L\n86#1:134\n86#1:135,3\n110#1:138\n110#1:139,3\n*E\n"})
    private static final class SoulboundHandler
    implements Listener {
        @NotNull
        private final EcoPlugin plugin;
        @NotNull
        private final EcoEnchant enchant;
        @NotNull
        private final PersistentDataKey<List<String>> savedSoulboundItems;
        @NotNull
        private final NamespacedKey soulboundKey;

        public SoulboundHandler(@NotNull EcoPlugin plugin, @NotNull EcoEnchant enchant) {
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            Intrinsics.checkNotNullParameter((Object)enchant, (String)"enchant");
            this.plugin = plugin;
            this.enchant = enchant;
            this.savedSoulboundItems = new PersistentDataKey(this.plugin.getNamespacedKeyFactory().create("soulbound_items"), PersistentDataKeyType.STRING_LIST, (Object)CollectionsKt.emptyList());
            NamespacedKey namespacedKey = this.plugin.getNamespacedKeyFactory().create("soulbound");
            Intrinsics.checkNotNullExpressionValue((Object)namespacedKey, (String)"create(...)");
            this.soulboundKey = namespacedKey;
        }

        /*
         * WARNING - void declaration
         */
        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public final void handle(@NotNull PlayerDeathEvent event) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ItemMeta meta;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getKeepInventory()) {
                return;
            }
            Player player = event.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
            Player player2 = player;
            Set<ItemStack> items = EnchantFinder.INSTANCE.getItemsWithEnchantActive((LivingEntity)player2, this.enchant).keySet();
            if (items.isEmpty()) {
                return;
            }
            event.getDrops().removeAll((Collection)items);
            if (Prerequisite.HAS_PAPER.isMet()) {
                List list = event.getItemsToKeep();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItemsToKeep(...)");
                CollectionsKt.addAll((Collection)list, (Iterable)items);
                return;
            }
            for (ItemStack item : items) {
                FastItemStackExtensions.fast((ItemStack)item).getPersistentDataContainer().set(this.soulboundKey, PersistentDataType.INTEGER, (Object)1);
                if (!this.enchant.getConfig().getBool("single-use")) continue;
                meta = item.getItemMeta();
                meta.removeEnchant(this.enchant.getEnchantment());
                item.setItemMeta(meta);
            }
            Iterable iterable = items;
            PersistentDataKey<List<String>> persistentDataKey = this.savedSoulboundItems;
            PlayerProfile playerProfile = ProfileExtensions.getProfile((OfflinePlayer)((OfflinePlayer)player2));
            boolean $i$f$map = false;
            meta = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ItemStack itemStack = (ItemStack)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Items.toSNBT((ItemStack)it));
            }
            collection = (List)destination$iv$iv;
            playerProfile.write(persistentDataKey, (Object)collection);
        }

        @EventHandler(ignoreCancelled=true)
        public final void onJoin(@NotNull PlayerJoinEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            this.giveItems(player);
        }

        @EventHandler(ignoreCancelled=true)
        public final void onJoin(@NotNull PlayerRespawnEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            this.giveItems(player);
        }

        /*
         * WARNING - void declaration
         */
        private final void giveItems(Player player) {
            void $this$mapTo$iv$iv;
            Object object = ProfileExtensions.getProfile((OfflinePlayer)((OfflinePlayer)player)).read(this.savedSoulboundItems);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"read(...)");
            List itemStrings = (List)object;
            if (itemStrings.isEmpty()) {
                return;
            }
            Iterable $this$map$iv = itemStrings;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Items.fromSNBT((String)it));
            }
            List items = (List)destination$iv$iv;
            this.plugin.getScheduler().run(() -> SoulboundHandler.giveItems$lambda$2(player, items));
            ProfileExtensions.getProfile((OfflinePlayer)((OfflinePlayer)player)).write(this.savedSoulboundItems, (Object)CollectionsKt.emptyList());
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public final void preventDroppingSoulboundItems(@NotNull PlayerDeathEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            event.getDrops().removeIf(arg_0 -> SoulboundHandler.preventDroppingSoulboundItems$lambda$3((Function1)new Function1<ItemStack, Boolean>(this){
                final /* synthetic */ SoulboundHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(ItemStack it) {
                    Intrinsics.checkNotNull((Object)it);
                    return FastItemStackExtensions.fast((ItemStack)it).getPersistentDataContainer().has(SoulboundHandler.access$getSoulboundKey$p(this.this$0), PersistentDataType.INTEGER) && it.getItemMeta().hasEnchant(SoulboundHandler.access$getEnchant$p(this.this$0).getEnchantment());
                }
            }, arg_0));
        }

        private static final void giveItems$lambda$2(Player $player, List $items) {
            Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
            Intrinsics.checkNotNullParameter((Object)$items, (String)"$items");
            new DropQueue($player).addItems((Collection)$items).forceTelekinesis().push();
        }

        private static final boolean preventDroppingSoulboundItems$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ NamespacedKey access$getSoulboundKey$p(SoulboundHandler $this) {
            return $this.soulboundKey;
        }

        public static final /* synthetic */ EcoEnchant access$getEnchant$p(SoulboundHandler $this) {
            return $this.enchant;
        }
    }
}

